/*
 * Decompiled with CFR 0.152.
 */
package jode.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class UnifyHash
extends AbstractCollection {
    private static final int DEFAULT_CAPACITY = 11;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private ReferenceQueue queue = new ReferenceQueue();
    private Bucket[] buckets;
    int modCount = 0;
    int size = 0;
    int threshold;
    float loadFactor;

    private void grow() {
        Bucket[] bucketArray = this.buckets;
        int n = this.buckets.length * 2 + 1;
        this.threshold = (int)(this.loadFactor * (float)n);
        this.buckets = new Bucket[n];
        int n2 = 0;
        while (n2 < bucketArray.length) {
            Bucket bucket = bucketArray[n2];
            while (bucket != null) {
                if (n2 != Math.abs(bucket.hash % bucketArray.length)) {
                    throw new RuntimeException("" + n2 + ", hash: " + bucket.hash + ", oldlength: " + bucketArray.length);
                }
                int n3 = Math.abs(bucket.hash % n);
                Bucket bucket2 = bucket.next;
                bucket.next = this.buckets[n3];
                this.buckets[n3] = bucket;
                bucket = bucket2;
            }
            ++n2;
        }
    }

    public final void cleanUp() {
        Bucket bucket;
        while ((bucket = (Bucket)this.queue.poll()) != null) {
            int n = Math.abs(bucket.hash % this.buckets.length);
            if (this.buckets[n] == bucket) {
                this.buckets[n] = bucket.next;
            } else {
                Bucket bucket2 = this.buckets[n];
                while (bucket2.next != bucket) {
                    bucket2 = bucket2.next;
                }
                bucket2.next = bucket.next;
            }
            --this.size;
        }
    }

    public int size() {
        return this.size;
    }

    public Iterator iterator() {
        this.cleanUp();
        UnifyHash unifyHash = this;
        if (unifyHash == null) {
            throw null;
        }
        return new Iterator(unifyHash){
            private int bucket;
            private int known;
            private Bucket nextBucket;
            private Object nextVal;
            private final /* synthetic */ UnifyHash this$0;

            private void internalNext() {
                while (true) {
                    if (this.nextBucket == null) {
                        if (this.bucket == UnifyHash.access$0(this.this$0).length) {
                            return;
                        }
                        this.nextBucket = UnifyHash.access$0(this.this$0)[this.bucket++];
                        continue;
                    }
                    this.nextVal = this.nextBucket.get();
                    if (this.nextVal != null) {
                        return;
                    }
                    this.nextBucket = this.nextBucket.next;
                }
            }

            public boolean hasNext() {
                return this.nextBucket != null;
            }

            public Object next() {
                if (this.known != this.this$0.modCount) {
                    throw new ConcurrentModificationException();
                }
                if (this.nextBucket == null) {
                    throw new NoSuchElementException();
                }
                Object object = this.nextVal;
                this.nextBucket = this.nextBucket.next;
                this.internalNext();
                return object;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            private final void block$() {
                this.bucket = 0;
                this.known = this.this$0.modCount;
                this.internalNext();
            }
            {
                this.this$0 = unifyHash;
                this.block$();
                this.constructor$0(unifyHash);
            }

            private final void constructor$0(UnifyHash unifyHash) {
            }
        };
    }

    public Iterator iterateHashCode(int n) {
        this.cleanUp();
        UnifyHash unifyHash = this;
        if (unifyHash == null) {
            throw null;
        }
        return new Iterator(unifyHash, n){
            private int known;
            private Bucket nextBucket;
            private Object nextVal;
            private final /* synthetic */ UnifyHash this$0;
            private final /* synthetic */ int val$hash;

            private void internalNext() {
                while (this.nextBucket != null) {
                    if (this.nextBucket.hash == this.val$hash) {
                        this.nextVal = this.nextBucket.get();
                        if (this.nextVal != null) {
                            return;
                        }
                    }
                    this.nextBucket = this.nextBucket.next;
                }
            }

            public boolean hasNext() {
                return this.nextBucket != null;
            }

            public Object next() {
                if (this.known != this.this$0.modCount) {
                    throw new ConcurrentModificationException();
                }
                if (this.nextBucket == null) {
                    throw new NoSuchElementException();
                }
                Object object = this.nextVal;
                this.nextBucket = this.nextBucket.next;
                this.internalNext();
                return object;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            private final void block$() {
                this.known = this.this$0.modCount;
                this.nextBucket = UnifyHash.access$0(this.this$0)[Math.abs(this.val$hash % UnifyHash.access$0(this.this$0).length)];
                this.internalNext();
            }
            {
                this.val$hash = n;
                this.this$0 = unifyHash;
                this.block$();
                this.constructor$0(unifyHash);
            }

            private final void constructor$0(UnifyHash unifyHash) {
            }
        };
    }

    public void put(int n, Object object) {
        if (this.size++ > this.threshold) {
            this.grow();
        }
        ++this.modCount;
        int n2 = Math.abs(n % this.buckets.length);
        Bucket bucket = new Bucket(object, this.queue);
        bucket.hash = n;
        bucket.next = this.buckets[n2];
        this.buckets[n2] = bucket;
    }

    public Object unify(Object object, int n, Comparator comparator) {
        this.cleanUp();
        int n2 = Math.abs(n % this.buckets.length);
        Bucket bucket = this.buckets[n2];
        while (bucket != null) {
            Object t = bucket.get();
            if (t != null && comparator.compare(object, t) == 0) {
                return t;
            }
            bucket = bucket.next;
        }
        this.put(n, object);
        return object;
    }

    static /* synthetic */ Bucket[] access$0(UnifyHash unifyHash) {
        return unifyHash.buckets;
    }

    public UnifyHash(int n, float f) {
        this.loadFactor = f;
        this.buckets = new Bucket[n];
        this.threshold = (int)(f * (float)n);
    }

    public UnifyHash(int n) {
        this(n, 0.75f);
    }

    public UnifyHash() {
        this(11, 0.75f);
    }

    static class Bucket
    extends WeakReference {
        int hash;
        Bucket next;

        public Bucket(Object object, ReferenceQueue referenceQueue) {
            super(object, referenceQueue);
        }
    }
}

