/*
 * Decompiled with CFR 0.152.
 */
package com.cycling74.io;

import com.cycling74.max.Atom;
import com.cycling74.max.MaxObject;
import java.io.IOException;
import java.io.Writer;

public class MessageWriter
extends Writer {
    private static final String WRITER_CLOSED = "Writer is closed";
    private static final char EOL = '\n';
    private MaxObject mObj = null;
    private int mOutlet = 0;
    private StringBuffer mBuf = new StringBuffer(256);

    public MessageWriter(MaxObject obj, int outlet) {
        this.mObj = obj;
        this.mOutlet = outlet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        StringBuffer stringBuffer = this.mBuf;
        synchronized (stringBuffer) {
            if (this.mBuf != null) {
                this.flush();
                this.mBuf = null;
            }
        }
    }

    private void checkOpen() throws IOException {
        if (this.mBuf == null) {
            throw new IOException(WRITER_CLOSED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        StringBuffer stringBuffer = this.mBuf;
        synchronized (stringBuffer) {
            this.checkOpen();
            if (this.mBuf.length() == 0) {
                return;
            }
            String str = this.mBuf.toString();
            int spacePos = str.indexOf(32);
            if (spacePos == -1) {
                try {
                    int possibleInt = Integer.parseInt(str);
                    this.mObj.outlet(this.mOutlet, possibleInt);
                    this.mBuf.setLength(0);
                    return;
                }
                catch (NumberFormatException nfe) {
                    try {
                        float possibleFloat = Float.valueOf(str).floatValue();
                        this.mObj.outlet(this.mOutlet, possibleFloat);
                        this.mBuf.setLength(0);
                        return;
                    }
                    catch (NumberFormatException nfe2) {
                        this.mObj.outlet(this.mOutlet, str, Atom.emptyArray);
                        this.mBuf.setLength(0);
                        return;
                    }
                }
            }
            String token = str.substring(0, spacePos);
            try {
                Integer.parseInt(token);
                Float.valueOf(str).floatValue();
                Atom[] list = Atom.parse(token, false);
                this.mObj.outlet(this.mOutlet, list);
                this.mBuf.setLength(0);
                return;
            }
            catch (NumberFormatException nfe) {
                this.mObj.outlet(this.mOutlet, token, Atom.parse(str, true));
                this.mBuf.setLength(0);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] cbuf) throws IOException {
        StringBuffer stringBuffer = this.mBuf;
        synchronized (stringBuffer) {
            this.checkOpen();
            int length = cbuf.length;
            for (int i = 0; i < length; ++i) {
                char ch = cbuf[i];
                if (ch == '\n') {
                    this.flush();
                    continue;
                }
                this.mBuf.append(ch);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] cbuf, int off, int len) throws IOException {
        StringBuffer stringBuffer = this.mBuf;
        synchronized (stringBuffer) {
            this.checkOpen();
            for (int i = off; i < off + len - 1; ++i) {
                char ch = cbuf[i];
                if (ch == '\n') {
                    this.flush();
                    continue;
                }
                this.mBuf.append(ch);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int c) throws IOException {
        StringBuffer stringBuffer = this.mBuf;
        synchronized (stringBuffer) {
            this.checkOpen();
            char ch = (char)c;
            if (ch == '\n') {
                this.flush();
            } else {
                this.mBuf.append(ch);
            }
        }
    }

    public void write(String str) throws IOException {
        int len = str.length();
        char[] temp = new char[len];
        str.getChars(0, len, temp, 0);
        this.write(temp);
    }

    public void write(String str, int off, int len) throws IOException {
        char[] temp = new char[len];
        str.getChars(off, off + len, temp, 0);
        this.write(temp);
    }
}

