/*
 * Decompiled with CFR 0.152.
 */
package com.cycling74.max;

public final class DataTypes {
    public static final int INT = 1;
    public static final int FLOAT = 2;
    public static final int LIST = 4;
    public static final int MESSAGE = 8;
    private static final int bitsNeeded = 4;
    public static final int ALL = 15;
    public static final int ANYTHING = 15;
    private static final String[] typeNames = new String[]{"int", "float", "list", "message"};
    private static final int[] typeMasks = new int[]{1, 2, 4, 8};
    private static final String noTypesName = "NONE";
    private static final String allTypesName = "ALL";
    private static final char typeSep = ';';

    private DataTypes() {
    }

    public static String toString(int typeDescr) {
        boolean seenOne = false;
        int masked = typeDescr & 0xF;
        if (masked == 15) {
            return allTypesName;
        }
        if (masked == 0) {
            return noTypesName;
        }
        StringBuffer sb = new StringBuffer(10);
        for (int i = 0; i < 4; ++i) {
            if ((masked & typeMasks[i]) == 0) continue;
            if (seenOne) {
                sb.append(';');
            }
            sb.append(typeNames[i]);
            seenOne = true;
        }
        return sb.toString();
    }
}

