/*
 * Decompiled with CFR 0.152.
 */
package com.cycling74.max;

import com.cycling74.max.Executable;
import com.cycling74.max.MaxObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Callback
implements Executable {
    private static final String jerr = "java programming error: ";
    private Object obj = null;
    private String methodName = null;
    private Method meth = null;
    private Object[] args = null;

    public Callback(Object o, String methodname) {
        this(o, methodname, null, null);
    }

    public Callback(Object o, String methodname, int i) {
        this(o, methodname, new Object[]{new Integer(i)}, new Class[]{Integer.TYPE});
    }

    public Callback(Object o, String methodname, float f) {
        this(o, methodname, new Object[]{new Float(f)}, new Class[]{Float.TYPE});
    }

    public Callback(Object o, String methodname, String s) {
        this(o, methodname, new Object[]{s});
    }

    public Callback(Object o, String methodname, boolean b) {
        this(o, methodname, new Object[]{b ? Boolean.TRUE : Boolean.FALSE}, new Class[]{Boolean.TYPE});
    }

    public Callback(Object o, String methodname, Object[] argObjectArray) {
        this(o, methodname, argObjectArray, Callback.toClasses(argObjectArray));
    }

    public Callback(Object o, String methodname, Object[] argObjectArray, Class[] argClassArray) {
        this.obj = o;
        this.methodName = methodname;
        if (argObjectArray != null) {
            this.setArgs(argObjectArray);
            this.meth = Callback.resolveMethod(o, methodname, argClassArray);
        } else {
            this.meth = Callback.resolveMethod(o, methodname, null);
        }
        if (this.meth != null && !this.meth.isAccessible()) {
            this.meth.setAccessible(true);
        }
    }

    public void setArgs(int i) {
        this.args = new Object[]{new Integer(i)};
    }

    public void setArgs(float f) {
        this.args = new Object[]{new Float(f)};
    }

    public void setArgs(boolean b) {
        this.args = b ? new Object[]{Boolean.TRUE} : new Object[]{Boolean.FALSE};
    }

    public void setArgs(String s) {
        this.args = new Object[]{s};
    }

    public void setArgs(Object[] a) {
        this.args = new Object[a.length];
        System.arraycopy(a, 0, this.args, 0, a.length);
    }

    private static Class[] toClasses(Object[] o) {
        Class[] c = new Class[o.length];
        for (int i = 0; i < o.length; ++i) {
            c[i] = o[i].getClass();
        }
        return c;
    }

    private static Method resolveMethod(Object o, String name, Class[] c) {
        try {
            Method m = o.getClass().getDeclaredMethod(name, c);
            return m;
        }
        catch (NoSuchMethodException e) {
            MaxObject.error("java programming error: bad method / signature for Callback");
            return null;
        }
    }

    public void execute() {
        try {
            this.meth.invoke(this.obj, this.args);
        }
        catch (InvocationTargetException e) {
            MaxObject.error("java programming error: Callback InvocationTargetException");
        }
        catch (IllegalAccessException e) {
            MaxObject.error("java programming error: Callback IllegalAccessException");
        }
    }

    public Object[] getArgs() {
        return this.args;
    }

    public Object getObject() {
        return this.obj;
    }

    public Method getMethod() {
        return this.meth;
    }

    public String getMethodName() {
        return this.methodName;
    }
}

