/*
 * Decompiled with CFR 0.152.
 */
package jode.decompiler;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import jode.bytecode.ClassInfo;
import jode.bytecode.InnerClassInfo;
import jode.decompiler.ImportHandler;
import jode.decompiler.Options;
import jode.decompiler.Scope;
import jode.type.ArrayType;
import jode.type.ClassInterfacesType;
import jode.type.NullType;
import jode.type.Type;

public class TabbedPrintWriter {
    public static final int EXPL_PAREN = 0;
    public static final int NO_PAREN = 1;
    public static final int IMPL_PAREN = 2;
    public static final int DONT_BREAK = 3;
    private int indentsize;
    private int tabWidth;
    private int lineWidth;
    private int currentIndent = 0;
    private String indentStr = "";
    private PrintWriter pw;
    private ImportHandler imports;
    private Stack scopes = new Stack();
    private StringBuffer currentLine;
    private BreakPoint currentBP;

    protected String makeIndentStr(int n) {
        String string = "\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t                    ";
        if (n < 0) {
            return "NEGATIVEINDENT" + n;
        }
        int n2 = n / this.tabWidth;
        if (n2 <= 20 && (n -= n2 * this.tabWidth) <= 20) {
            return string.substring(20 - n2, 20 + n);
        }
        StringBuffer stringBuffer = new StringBuffer(n2 + n);
        while (n2 > 20) {
            stringBuffer.append(string.substring(0, 20));
            n2 -= 20;
        }
        stringBuffer.append(string.substring(0, n2));
        while (n > 20) {
            stringBuffer.append(string.substring(20));
            n -= 20;
        }
        stringBuffer.append(string.substring(40 - n));
        return stringBuffer.toString();
    }

    public void init() {
        this.indentsize = Options.outputStyle & 0xF;
        this.tabWidth = 8;
        this.lineWidth = 79;
        this.currentLine = new StringBuffer();
        TabbedPrintWriter tabbedPrintWriter = this;
        if (tabbedPrintWriter == null) {
            throw null;
        }
        this.currentBP = tabbedPrintWriter.new BreakPoint(null, 0);
        this.currentBP.startOp(3, 1, 0);
    }

    public void tab() {
        this.currentIndent += this.indentsize;
        this.indentStr = this.makeIndentStr(this.currentIndent);
    }

    public void untab() {
        this.currentIndent -= this.indentsize;
        this.indentStr = this.makeIndentStr(this.currentIndent);
    }

    public void startOp(int n, int n2) {
        this.currentBP = (BreakPoint)this.currentBP.childBPs.lastElement();
        this.currentBP.startOp(n, n2, this.currentLine.length());
    }

    public void breakOp() {
        int n = this.currentLine.length();
        if (n > this.currentBP.startPos && this.currentLine.charAt(n - 1) == ' ') {
            --n;
        }
        this.currentBP.breakOp(n);
    }

    public void endOp() {
        this.currentBP.endOp(this.currentLine.length());
        this.currentBP = this.currentBP.parentBP;
        if (this.currentBP == null) {
            throw new NullPointerException();
        }
    }

    public Object saveOps() {
        Stack<Integer> stack = new Stack<Integer>();
        int n = this.currentLine.length();
        while (this.currentBP.parentBP != null) {
            stack.push(new Integer(this.currentBP.breakPenalty));
            this.currentBP.options = 3;
            this.currentBP.endPos = n;
            this.currentBP = this.currentBP.parentBP;
        }
        return stack;
    }

    public void restoreOps(Object object) {
        Stack stack = (Stack)object;
        while (!stack.isEmpty()) {
            int n = (Integer)stack.pop();
            this.startOp(3, n);
        }
    }

    public void println(String string) {
        this.print(string);
        this.println();
    }

    public void println() {
        this.currentBP.endPos = this.currentLine.length();
        int n = this.lineWidth - this.currentIndent;
        int n2 = this.currentBP.getMinPenalty(n, n, 0x3FFFFFFF);
        this.currentBP = this.currentBP.commitMinPenalty(n, n, n2);
        this.pw.print(this.indentStr);
        this.currentBP.printLines(this.currentIndent, this.currentLine.toString());
        this.pw.println();
        this.currentLine.setLength(0);
        TabbedPrintWriter tabbedPrintWriter = this;
        if (tabbedPrintWriter == null) {
            throw null;
        }
        this.currentBP = tabbedPrintWriter.new BreakPoint(null, 0);
        this.currentBP.startOp(3, 1, 0);
    }

    public void print(String string) {
        this.currentLine.append(string);
    }

    public void printType(Type type) {
        this.print(this.getTypeString(type));
    }

    public void pushScope(Scope scope) {
        this.scopes.push(scope);
    }

    public void popScope() {
        this.scopes.pop();
    }

    public boolean conflicts(String string, Scope scope, int n) {
        int n2;
        int n3 = string.indexOf(46);
        if (n3 >= 0) {
            string = string.substring(0, n3);
        }
        int n4 = n2 = this.scopes.size();
        while (n4-- > 0) {
            Scope scope2 = (Scope)this.scopes.elementAt(n4);
            if (scope2 == scope) {
                return false;
            }
            if (!scope2.conflicts(string, n)) continue;
            return true;
        }
        return false;
    }

    public Scope getScope(Object object, int n) {
        int n2;
        int n3 = n2 = this.scopes.size();
        while (n3-- > 0) {
            Scope scope = (Scope)this.scopes.elementAt(n3);
            if (!scope.isScopeOf(object, n)) continue;
            return scope;
        }
        return null;
    }

    public String getInnerClassString(ClassInfo classInfo, int n) {
        Object object;
        InnerClassInfo[] innerClassInfoArray = classInfo.getOuterClasses();
        if (innerClassInfoArray == null) {
            return null;
        }
        int n2 = 0;
        while (n2 < innerClassInfoArray.length) {
            if (innerClassInfoArray[n2].name == null || innerClassInfoArray[n2].outer == null) {
                return null;
            }
            object = this.getScope(ClassInfo.forName(innerClassInfoArray[n2].outer), 1);
            if (object != null && !this.conflicts(innerClassInfoArray[n2].name, (Scope)object, n)) {
                StringBuffer stringBuffer = new StringBuffer(innerClassInfoArray[n2].name);
                int n3 = n2;
                while (n3-- > 0) {
                    stringBuffer.append('.').append(innerClassInfoArray[n3].name);
                }
                return stringBuffer.toString();
            }
            ++n2;
        }
        String string = this.getClassString(ClassInfo.forName(innerClassInfoArray[innerClassInfoArray.length - 1].outer), n);
        object = new StringBuffer(string);
        int n4 = innerClassInfoArray.length;
        while (n4-- > 0) {
            ((StringBuffer)object).append('.').append(innerClassInfoArray[n4].name);
        }
        return ((StringBuffer)object).toString();
    }

    public String getAnonymousClassString(ClassInfo classInfo, int n) {
        Object object;
        InnerClassInfo[] innerClassInfoArray = classInfo.getOuterClasses();
        if (innerClassInfoArray == null) {
            return null;
        }
        int n2 = 0;
        while (n2 < innerClassInfoArray.length) {
            if (innerClassInfoArray[n2].name == null) {
                return "ANONYMOUS CLASS " + classInfo.getName();
            }
            object = this.getScope(classInfo, 2);
            if (object != null && !this.conflicts(innerClassInfoArray[n2].name, (Scope)object, n)) {
                StringBuffer stringBuffer = new StringBuffer(innerClassInfoArray[n2].name);
                int n3 = n2;
                while (n3-- > 0) {
                    stringBuffer.append('.').append(innerClassInfoArray[n3].name);
                }
                return stringBuffer.toString();
            }
            if (innerClassInfoArray[n2].outer == null) {
                StringBuffer stringBuffer = object != null ? new StringBuffer("NAME CONFLICT ") : new StringBuffer("UNREACHABLE ");
                stringBuffer.append(innerClassInfoArray[n2].name);
                int n4 = n2;
                while (n4-- > 0) {
                    stringBuffer.append('.').append(innerClassInfoArray[n4].name);
                }
                return stringBuffer.toString();
            }
            ++n2;
        }
        String string = this.getClassString(ClassInfo.forName(innerClassInfoArray[innerClassInfoArray.length - 1].outer), n);
        object = new StringBuffer(string);
        int n5 = innerClassInfoArray.length;
        while (n5-- > 0) {
            ((StringBuffer)object).append('.').append(innerClassInfoArray[n5].name);
        }
        return ((StringBuffer)object).toString();
    }

    public String getClassString(ClassInfo classInfo, int n) {
        String string;
        String string2 = classInfo.getName();
        if (string2.indexOf(36) >= 0) {
            if ((Options.options & 2) != 0 && (string = this.getInnerClassString(classInfo, n)) != null) {
                return string;
            }
            if ((Options.options & 4) != 0 && (string = this.getAnonymousClassString(classInfo, n)) != null) {
                return string;
            }
        }
        if (this.imports != null && !this.conflicts(string = this.imports.getClassString(classInfo), null, n)) {
            return string;
        }
        if (this.conflicts(string2, null, 4)) {
            return "PKGNAMECONFLICT " + string2;
        }
        return string2;
    }

    public String getTypeString(Type type) {
        if (type instanceof ArrayType) {
            return this.getTypeString(((ArrayType)type).getElementType()) + "[]";
        }
        if (type instanceof ClassInterfacesType) {
            ClassInfo classInfo = ((ClassInterfacesType)type).getClassInfo();
            return this.getClassString(classInfo, 1);
        }
        if (type instanceof NullType) {
            return "Object";
        }
        return type.toString();
    }

    public void openBrace() {
        if ((Options.outputStyle & 0x10) != 0) {
            this.print(this.currentLine.length() > 0 ? " {" : "{");
            this.println();
        } else {
            if (this.currentLine.length() > 0) {
                this.println();
            }
            if ((Options.outputStyle & 0x20) == 0 && this.currentIndent > 0) {
                this.tab();
            }
            this.println("{");
        }
    }

    public void openBraceClass() {
        if (this.currentLine.length() > 0) {
            if ((Options.outputStyle & 0x10) != 0) {
                this.print(" ");
            } else {
                this.println();
            }
        }
        this.println("{");
    }

    public void openBraceNoIndent() {
        if ((Options.outputStyle & 0x10) != 0) {
            this.print(this.currentLine.length() > 0 ? " {" : "{");
            this.println();
        } else {
            if (this.currentLine.length() > 0) {
                this.println();
            }
            this.println("{");
        }
    }

    public void openBraceNoSpace() {
        if ((Options.outputStyle & 0x10) != 0) {
            this.println("{");
        } else {
            if (this.currentLine.length() > 0) {
                this.println();
            }
            if ((Options.outputStyle & 0x20) == 0 && this.currentIndent > 0) {
                this.tab();
            }
            this.println("{");
        }
    }

    public void closeBraceContinue() {
        if ((Options.outputStyle & 0x10) != 0) {
            this.print("} ");
        } else {
            this.println("}");
            if ((Options.outputStyle & 0x20) == 0 && this.currentIndent > 0) {
                this.untab();
            }
        }
    }

    public void closeBraceClass() {
        this.print("}");
    }

    public void closeBrace() {
        if ((Options.outputStyle & 0x10) != 0) {
            this.println("}");
        } else {
            this.println("}");
            if ((Options.outputStyle & 0x20) == 0 && this.currentIndent > 0) {
                this.untab();
            }
        }
    }

    public void closeBraceNoIndent() {
        this.println("}");
    }

    public void flush() {
        this.pw.flush();
    }

    public void close() {
        this.pw.close();
    }

    public TabbedPrintWriter(OutputStream outputStream, ImportHandler importHandler, boolean bl) {
        this.pw = new PrintWriter(outputStream, bl);
        this.imports = importHandler;
        this.init();
    }

    public TabbedPrintWriter(Writer writer, ImportHandler importHandler, boolean bl) {
        this.pw = new PrintWriter(writer, bl);
        this.imports = importHandler;
        this.init();
    }

    public TabbedPrintWriter(OutputStream outputStream, ImportHandler importHandler) {
        this(outputStream, importHandler, true);
    }

    public TabbedPrintWriter(Writer writer, ImportHandler importHandler) {
        this(writer, importHandler, true);
    }

    public TabbedPrintWriter(OutputStream outputStream) {
        this(outputStream, null);
    }

    public TabbedPrintWriter(Writer writer) {
        this(writer, null);
    }

    class BreakPoint {
        int options;
        int breakPenalty;
        int breakPos;
        int startPos;
        BreakPoint parentBP;
        Vector childBPs;
        int nesting = 0;
        int endPos;
        int whatBreak = 0;

        public void startOp(int n, int n2, int n3) {
            if (this.startPos != -1) {
                throw new InternalError("missing breakOp");
            }
            this.startPos = n3;
            this.options = n;
            this.breakPenalty = n2;
            this.childBPs = new Vector();
            this.breakOp(n3);
        }

        public void breakOp(int n) {
            TabbedPrintWriter tabbedPrintWriter = TabbedPrintWriter.this;
            if (tabbedPrintWriter == null) {
                throw null;
            }
            this.childBPs.addElement(tabbedPrintWriter.new BreakPoint(this, n));
        }

        public void endOp(int n) {
            this.endPos = n;
            if (this.childBPs.size() == 1) {
                BreakPoint breakPoint = (BreakPoint)this.childBPs.elementAt(0);
                this.options = Math.min(this.options, breakPoint.options);
                this.startPos = breakPoint.startPos;
                this.endPos = breakPoint.endPos;
                this.breakPenalty = breakPoint.breakPenalty;
                this.childBPs = breakPoint.childBPs;
            }
        }

        public void dump(String string) {
            if (this.startPos == -1) {
                TabbedPrintWriter.this.pw.print(string);
            } else {
                TabbedPrintWriter.this.pw.print(string.substring(0, this.startPos));
                this.dumpRegion(string);
                TabbedPrintWriter.this.pw.print(string.substring(this.endPos));
            }
        }

        public void dumpRegion(String string) {
            String string2 = "{\b{}\b}<\b<>\b>[\b[]\b]`\b`'\b'".substring(this.options * 6, this.options * 6 + 6);
            TabbedPrintWriter.this.pw.print(string2.substring(0, 3));
            Enumeration enumeration = this.childBPs.elements();
            int n = this.startPos;
            BreakPoint breakPoint = (BreakPoint)enumeration.nextElement();
            if (breakPoint.startPos >= 0) {
                TabbedPrintWriter.this.pw.print(string.substring(n, breakPoint.startPos));
                breakPoint.dumpRegion(string);
                n = breakPoint.endPos;
            }
            while (enumeration.hasMoreElements()) {
                breakPoint = (BreakPoint)enumeration.nextElement();
                TabbedPrintWriter.this.pw.print(string.substring(n, breakPoint.breakPos));
                TabbedPrintWriter.this.pw.print("!\b!" + this.breakPenalty);
                n = breakPoint.breakPos;
                if (breakPoint.startPos < 0) continue;
                TabbedPrintWriter.this.pw.print(string.substring(breakPoint.breakPos, breakPoint.startPos));
                breakPoint.dumpRegion(string);
                n = breakPoint.endPos;
            }
            TabbedPrintWriter.this.pw.print(string.substring(n, this.endPos));
            TabbedPrintWriter.this.pw.print(string2.substring(3));
        }

        public void printLines(int n, String string) {
            if (this.startPos == -1) {
                TabbedPrintWriter.this.pw.print(string);
            } else {
                TabbedPrintWriter.this.pw.print(string.substring(0, this.startPos));
                this.printRegion(n + this.startPos, string);
                TabbedPrintWriter.this.pw.print(string.substring(this.endPos));
            }
        }

        public void printRegion(int n, String string) {
            if (this.options == 2) {
                TabbedPrintWriter.this.pw.print("(");
                ++n;
            }
            Enumeration enumeration = this.childBPs.elements();
            int n2 = this.startPos;
            BreakPoint breakPoint = (BreakPoint)enumeration.nextElement();
            if (breakPoint.startPos >= 0) {
                TabbedPrintWriter.this.pw.print(string.substring(n2, breakPoint.startPos));
                breakPoint.printRegion(n + breakPoint.startPos - n2, string);
                n2 = breakPoint.endPos;
            }
            if (this.options == 1) {
                n += TabbedPrintWriter.this.indentsize;
            }
            String string2 = TabbedPrintWriter.this.makeIndentStr(n);
            while (enumeration.hasMoreElements()) {
                breakPoint = (BreakPoint)enumeration.nextElement();
                TabbedPrintWriter.this.pw.print(string.substring(n2, breakPoint.breakPos));
                TabbedPrintWriter.this.pw.println();
                TabbedPrintWriter.this.pw.print(string2);
                n2 = breakPoint.breakPos;
                if (n2 < this.endPos && string.charAt(n2) == ' ') {
                    ++n2;
                }
                if (breakPoint.startPos < 0) continue;
                TabbedPrintWriter.this.pw.print(string.substring(n2, breakPoint.startPos));
                breakPoint.printRegion(n + breakPoint.startPos - n2, string);
                n2 = breakPoint.endPos;
            }
            TabbedPrintWriter.this.pw.print(string.substring(n2, this.endPos));
            if (this.options == 2) {
                TabbedPrintWriter.this.pw.print(")");
            }
        }

        public BreakPoint commitMinPenalty(int n, int n2, int n3) {
            int n4;
            if (this.startPos == -1 || n2 > this.endPos - this.startPos || n3 == 10 * (this.endPos - this.startPos - n2)) {
                this.startPos = -1;
                this.childBPs = null;
                return this;
            }
            int n5 = this.childBPs.size();
            if (n5 > 1 && this.options != 3 && n3 == (n4 = this.getBreakPenalty(n, n2, n3 + 1))) {
                this.commitBreakPenalty(n, n2, n4);
                return this;
            }
            n4 = 0;
            while (n4 < n5) {
                int n6;
                int n7;
                BreakPoint breakPoint;
                int n8 = n3 - (n4 < n5 - 1 ? 1 : 0);
                if (n8 == (breakPoint = (BreakPoint)this.childBPs.elementAt(n4)).getMinPenalty(n - (n7 = breakPoint.startPos - this.startPos), n2 - n7 - (n6 = this.endPos - breakPoint.endPos), n8 + 1)) {
                    breakPoint = breakPoint.commitMinPenalty(n - n7, n2 - n7 - n6, n8);
                    breakPoint.breakPos = this.breakPos;
                    return breakPoint;
                }
                ++n4;
            }
            TabbedPrintWriter.this.pw.println("XXXXXXXXXXX CAN'T COMMIT");
            this.startPos = -1;
            this.childBPs = null;
            return this;
        }

        public int getMinPenalty(int n, int n2, int n3) {
            int n4;
            if (10 * -n2 >= n3) {
                return n3;
            }
            if (this.startPos == -1) {
                return 10 * -n2;
            }
            if (n2 > this.endPos - this.startPos) {
                return 0;
            }
            if (n3 <= 1) {
                return n3;
            }
            if (n3 > 10 * (this.endPos - this.startPos - n2)) {
                n3 = 10 * (this.endPos - this.startPos - n2);
            }
            if ((n4 = this.childBPs.size()) == 0) {
                return n3;
            }
            if (n4 > 1 && this.options != 3) {
                n3 = this.getBreakPenalty(n, n2, n3);
            }
            int n5 = 0;
            while (n5 < n4) {
                BreakPoint breakPoint = (BreakPoint)this.childBPs.elementAt(n5);
                int n6 = breakPoint.startPos - this.startPos;
                int n7 = this.endPos - breakPoint.endPos;
                int n8 = n5 < n4 - 1 ? 1 : 0;
                n3 = n8 + breakPoint.getMinPenalty(n - n6, n2 - n6 - n7, n3 - n8);
                ++n5;
            }
            return n3;
        }

        public void commitBreakPenalty(int n, int n2, int n3) {
            int n4;
            int n5;
            int n6;
            int n7;
            if (this.options == 2) {
                --n;
                n2 -= 2;
            }
            Enumeration enumeration = this.childBPs.elements();
            this.childBPs = new Vector();
            int n8 = 0;
            boolean bl = this.options == 1;
            BreakPoint breakPoint = (BreakPoint)enumeration.nextElement();
            while (enumeration.hasMoreElements()) {
                BreakPoint breakPoint2 = (BreakPoint)enumeration.nextElement();
                n7 = breakPoint.breakPos;
                n6 = breakPoint2.breakPos;
                if (n8 <= 0 || (n8 += n6 - n7) > n) {
                    if (n7 < this.endPos && TabbedPrintWriter.this.currentLine.charAt(n7) == ' ') {
                        ++n7;
                    }
                    if (n6 - n7 > n) {
                        n5 = breakPoint.startPos - n7;
                        n4 = n6 - breakPoint.endPos;
                        int n9 = breakPoint.getMinPenalty(n - n5, n - n5 - n4, n3);
                        n8 = 0;
                        this.childBPs.addElement(breakPoint.commitMinPenalty(n - n5, n - n5 - n4, n9));
                    } else {
                        breakPoint.startPos = -1;
                        breakPoint.childBPs = null;
                        this.childBPs.addElement(breakPoint);
                        n8 = n6 - n7;
                    }
                    if (bl) {
                        n -= TabbedPrintWriter.this.indentsize;
                        n2 -= TabbedPrintWriter.this.indentsize;
                        bl = false;
                    }
                }
                breakPoint = breakPoint2;
            }
            n7 = breakPoint.breakPos;
            if (n8 > 0 && n8 + this.endPos - n7 <= n2) {
                return;
            }
            if (n7 < this.endPos && TabbedPrintWriter.this.currentLine.charAt(n7) == ' ') {
                ++n7;
            }
            if (this.endPos - n7 > n2) {
                n6 = breakPoint.startPos - n7;
                n5 = this.endPos - breakPoint.endPos;
                n4 = breakPoint.getMinPenalty(n - n6, n2 - n6 - n5, n3 + 1);
                this.childBPs.addElement(breakPoint.commitMinPenalty(n - n6, n2 - n6 - n5, n4));
            } else {
                breakPoint.startPos = -1;
                breakPoint.childBPs = null;
                this.childBPs.addElement(breakPoint);
            }
        }

        public int getBreakPenalty(int n, int n2, int n3) {
            int n4;
            int n5;
            int n6;
            int n7 = this.breakPenalty;
            int n8 = 0;
            if (this.options == 2) {
                --n;
                n2 -= 2;
            }
            if (n < 0) {
                return n3;
            }
            Enumeration enumeration = this.childBPs.elements();
            boolean bl = this.options == 1;
            BreakPoint breakPoint = (BreakPoint)enumeration.nextElement();
            while (enumeration.hasMoreElements()) {
                BreakPoint breakPoint2;
                block19: {
                    block18: {
                        breakPoint2 = (BreakPoint)enumeration.nextElement();
                        n6 = breakPoint.breakPos;
                        n5 = breakPoint2.breakPos;
                        if (n8 <= 0) break block18;
                        if ((n8 += n5 - n6) <= n) break block19;
                        ++n7;
                        if (bl) {
                            n -= TabbedPrintWriter.this.indentsize;
                            n2 -= TabbedPrintWriter.this.indentsize;
                            bl = false;
                        }
                    }
                    if (n6 < this.endPos && TabbedPrintWriter.this.currentLine.charAt(n6) == ' ') {
                        ++n6;
                    }
                    if (n5 - n6 > n) {
                        n4 = breakPoint.startPos - n6;
                        int n9 = n5 - breakPoint.endPos;
                        n7 += 1 + breakPoint.getMinPenalty(n - n4, n - n4 - n9, n3 - n7 - 1);
                        if (bl) {
                            n -= TabbedPrintWriter.this.indentsize;
                            n2 -= TabbedPrintWriter.this.indentsize;
                            bl = false;
                        }
                        n8 = 0;
                    } else {
                        n8 = n5 - n6;
                    }
                    if (n7 >= n3) {
                        return n3;
                    }
                }
                breakPoint = breakPoint2;
            }
            n6 = breakPoint.breakPos;
            if (n8 > 0) {
                if (n8 + this.endPos - n6 <= n2) {
                    return n7;
                }
                ++n7;
                if (bl) {
                    n -= TabbedPrintWriter.this.indentsize;
                    n2 -= TabbedPrintWriter.this.indentsize;
                    bl = false;
                }
            }
            if (n6 < this.endPos && TabbedPrintWriter.this.currentLine.charAt(n6) == ' ') {
                ++n6;
            }
            if (this.endPos - n6 > n2) {
                n5 = breakPoint.startPos - n6;
                n4 = this.endPos - breakPoint.endPos;
                n7 += breakPoint.getMinPenalty(n - n5, n2 - n5 - n4, n3 - n7);
            }
            if (n7 < n3) {
                return n7;
            }
            return n3;
        }

        public BreakPoint(BreakPoint breakPoint, int n) {
            this.breakPos = n;
            this.parentBP = breakPoint;
            this.options = 3;
            this.breakPenalty = 0;
            this.startPos = -1;
            this.endPos = -1;
            this.whatBreak = 0;
            this.childBPs = null;
        }
    }
}

