/*
 * Decompiled with CFR 0.152.
 */
package jode.flow;

import java.io.IOException;
import java.util.Set;
import jode.decompiler.TabbedPrintWriter;
import jode.expr.Expression;
import jode.flow.CreateCheckNull;
import jode.flow.CreateClassField;
import jode.flow.StructuredBlock;
import jode.flow.VariableStack;
import jode.util.SimpleSet;

public class IfThenElseBlock
extends StructuredBlock {
    Expression cond;
    VariableStack condStack;
    StructuredBlock thenBlock;
    StructuredBlock elseBlock;

    public void setThenBlock(StructuredBlock structuredBlock) {
        this.thenBlock = structuredBlock;
        structuredBlock.outer = this;
        structuredBlock.setFlowBlock(this.flowBlock);
    }

    public void setElseBlock(StructuredBlock structuredBlock) {
        this.elseBlock = structuredBlock;
        structuredBlock.outer = this;
        structuredBlock.setFlowBlock(this.flowBlock);
    }

    public boolean replaceSubBlock(StructuredBlock structuredBlock, StructuredBlock structuredBlock2) {
        if (this.thenBlock == structuredBlock) {
            this.thenBlock = structuredBlock2;
        } else if (this.elseBlock == structuredBlock) {
            this.elseBlock = structuredBlock2;
        } else {
            return false;
        }
        return true;
    }

    public VariableStack mapStackToLocal(VariableStack variableStack) {
        VariableStack variableStack2;
        int n = this.cond.getFreeOperandCount();
        if (n > 0) {
            this.condStack = variableStack.peek(n);
            variableStack2 = variableStack.pop(n);
        } else {
            variableStack2 = variableStack;
        }
        VariableStack variableStack3 = VariableStack.merge(this.thenBlock.mapStackToLocal(variableStack2), this.elseBlock == null ? variableStack2 : this.elseBlock.mapStackToLocal(variableStack2));
        if (this.jump != null) {
            this.jump.stackMap = variableStack3;
            return null;
        }
        return variableStack3;
    }

    public void removePush() {
        if (this.condStack != null) {
            this.cond = this.condStack.mergeIntoExpression(this.cond);
        }
        this.thenBlock.removePush();
        if (this.elseBlock != null) {
            this.elseBlock.removePush();
        }
    }

    public Set getDeclarables() {
        SimpleSet simpleSet = new SimpleSet();
        this.cond.fillDeclarables(simpleSet);
        return simpleSet;
    }

    public void makeDeclaration(Set set) {
        this.cond.makeDeclaration(set);
        super.makeDeclaration(set);
    }

    public void dumpInstruction(TabbedPrintWriter tabbedPrintWriter) throws IOException {
        boolean bl = this.thenBlock.needsBraces();
        tabbedPrintWriter.print("if (");
        this.cond.dumpExpression(0, tabbedPrintWriter);
        tabbedPrintWriter.print(")");
        if (bl) {
            tabbedPrintWriter.openBrace();
        } else {
            tabbedPrintWriter.println();
        }
        tabbedPrintWriter.tab();
        this.thenBlock.dumpSource(tabbedPrintWriter);
        tabbedPrintWriter.untab();
        if (this.elseBlock != null) {
            if (bl) {
                tabbedPrintWriter.closeBraceContinue();
            }
            if (this.elseBlock instanceof IfThenElseBlock && (this.elseBlock.declare == null || this.elseBlock.declare.isEmpty())) {
                bl = false;
                tabbedPrintWriter.print("else ");
                this.elseBlock.dumpSource(tabbedPrintWriter);
            } else {
                bl = this.elseBlock.needsBraces();
                tabbedPrintWriter.print("else");
                if (bl) {
                    tabbedPrintWriter.openBrace();
                } else {
                    tabbedPrintWriter.println();
                }
                tabbedPrintWriter.tab();
                this.elseBlock.dumpSource(tabbedPrintWriter);
                tabbedPrintWriter.untab();
            }
        }
        if (bl) {
            tabbedPrintWriter.closeBrace();
        }
    }

    public StructuredBlock[] getSubBlocks() {
        StructuredBlock[] structuredBlockArray;
        if (this.elseBlock == null) {
            StructuredBlock[] structuredBlockArray2 = new StructuredBlock[1];
            structuredBlockArray = structuredBlockArray2;
            structuredBlockArray2[0] = this.thenBlock;
        } else {
            StructuredBlock[] structuredBlockArray3 = new StructuredBlock[2];
            structuredBlockArray3[0] = this.thenBlock;
            structuredBlockArray = structuredBlockArray3;
            structuredBlockArray3[1] = this.elseBlock;
        }
        return structuredBlockArray;
    }

    public boolean jumpMayBeChanged() {
        return !(this.thenBlock.jump == null && !this.thenBlock.jumpMayBeChanged() || this.elseBlock == null || this.elseBlock.jump == null && !this.elseBlock.jumpMayBeChanged());
    }

    public void simplify() {
        this.cond = this.cond.simplify();
        super.simplify();
    }

    public boolean doTransformations() {
        StructuredBlock structuredBlock = this.flowBlock.lastModified;
        return CreateCheckNull.transformJikes(this, structuredBlock) || CreateClassField.transform(this, structuredBlock);
    }

    public IfThenElseBlock(Expression expression) {
        this.cond = expression;
    }
}

