/*
 * Decompiled with CFR 0.152.
 */
package jode.expr;

import java.io.IOException;
import jode.AssertError;
import jode.decompiler.TabbedPrintWriter;
import jode.expr.NoArgOperator;
import jode.expr.Operator;
import jode.expr.StoreInstruction;
import jode.type.IntegerType;
import jode.type.Type;

public class ConstOperator
extends NoArgOperator {
    private static final Type tBoolConstInt = new IntegerType(31);
    Object value;
    boolean isInitializer = false;

    public Object getValue() {
        return this.value;
    }

    public boolean isOne(Type type) {
        if (type instanceof IntegerType) {
            return this.value instanceof Integer && (Integer)this.value == 1;
        }
        if (type == Type.tLong) {
            return this.value instanceof Long && (Long)this.value == 1L;
        }
        if (type == Type.tFloat) {
            return this.value instanceof Float && ((Float)this.value).floatValue() == 1.0f;
        }
        if (type == Type.tDouble) {
            return this.value instanceof Double && (Double)this.value == 1.0;
        }
        return false;
    }

    public int getPriority() {
        return 1000;
    }

    public boolean opEquals(Operator operator) {
        if (operator instanceof ConstOperator) {
            Object object = ((ConstOperator)operator).value;
            return this.value == null ? object == null : this.value.equals(object);
        }
        return false;
    }

    public void makeInitializer(Type type) {
        this.isInitializer = true;
    }

    private static String quoted(String string) {
        StringBuffer stringBuffer = new StringBuffer("\"");
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '\u0000': {
                    stringBuffer.append("\\0");
                    break;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    break;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    break;
                }
                default: {
                    String string2;
                    if (c < ' ') {
                        string2 = Integer.toOctalString(c);
                        stringBuffer.append("\\000".substring(0, 4 - string2.length())).append(string2);
                        break;
                    }
                    if (c >= ' ' && c < '\u007f') {
                        stringBuffer.append(string.charAt(n));
                        break;
                    }
                    string2 = Integer.toHexString(c);
                    stringBuffer.append("\\u0000".substring(0, 6 - string2.length())).append(string2);
                }
            }
            ++n;
        }
        return stringBuffer.append("\"").toString();
    }

    public String toString() {
        String string = String.valueOf(this.value);
        if (this.type.isOfType(Type.tBoolean)) {
            int n = (Integer)this.value;
            if (n == 0) {
                return "false";
            }
            if (n == 1) {
                return "true";
            }
            throw new AssertError("boolean is neither false nor true");
        }
        if (this.type.getHint().equals(Type.tChar)) {
            char c = (char)((Integer)this.value).intValue();
            switch (c) {
                case '\u0000': {
                    return "'\\0'";
                }
                case '\t': {
                    return "'\\t'";
                }
                case '\n': {
                    return "'\\n'";
                }
                case '\r': {
                    return "'\\r'";
                }
                case '\\': {
                    return "'\\\\'";
                }
                case '\"': {
                    return "'\\\"'";
                }
                case '\'': {
                    return "'\\''";
                }
            }
            if (c < ' ') {
                String string2 = Integer.toOctalString(c);
                return "'\\000".substring(0, 5 - string2.length()) + string2 + "'";
            }
            if (c >= ' ' && c < '\u007f') {
                return "'" + c + "'";
            }
            String string3 = Integer.toHexString(c);
            return "'\\u0000".substring(0, 7 - string3.length()) + string3 + "'";
        }
        if (this.type.equals(Type.tString)) {
            return ConstOperator.quoted(string);
        }
        if (this.parent != null) {
            int n = this.parent.getOperatorIndex();
            if (n >= 13 && n < 24) {
                n -= 12;
            }
            if (n >= 9 && n < 12) {
                if (this.type.isOfType(Type.tUInt)) {
                    int n2 = (Integer)this.value;
                    string = n2 < -1 ? "~0x" + Integer.toHexString(-n2 - 1) : "0x" + Integer.toHexString(n2);
                } else if (this.type.equals(Type.tLong)) {
                    long l = (Long)this.value;
                    string = l < -1L ? "~0x" + Long.toHexString(-l - 1L) : "0x" + Long.toHexString(l);
                }
            }
        }
        if (this.type.isOfType(Type.tLong)) {
            return string + "L";
        }
        if (this.type.isOfType(Type.tFloat)) {
            if (string.equals("NaN")) {
                return "Float.NaN";
            }
            if (string.equals("-Infinity")) {
                return "Float.NEGATIVE_INFINITY";
            }
            if (string.equals("Infinity")) {
                return "Float.POSITIVE_INFINITY";
            }
            return string + "F";
        }
        if (this.type.isOfType(Type.tDouble)) {
            if (string.equals("NaN")) {
                return "Double.NaN";
            }
            if (string.equals("-Infinity")) {
                return "Double.NEGATIVE_INFINITY";
            }
            if (string.equals("Infinity")) {
                return "Double.POSITIVE_INFINITY";
            }
            return string;
        }
        if (!(this.type.isOfType(Type.tInt) || !this.type.getHint().equals(Type.tByte) && !this.type.getHint().equals(Type.tShort) || this.isInitializer || this.parent instanceof StoreInstruction && this.parent.getOperatorIndex() != 12 && this.parent.subExpressions[1] == this)) {
            return "(" + this.type.getHint() + ") " + string;
        }
        return string;
    }

    public void dumpExpression(TabbedPrintWriter tabbedPrintWriter) throws IOException {
        tabbedPrintWriter.print(this.toString());
    }

    public ConstOperator(Object object) {
        super(Type.tUnknown);
        if (object instanceof Boolean) {
            this.updateParentType(Type.tBoolean);
            object = new Integer((Boolean)object != false ? 1 : 0);
        } else if (object instanceof Integer) {
            int n = (Integer)object;
            this.updateParentType(n == 0 || n == 1 ? tBoolConstInt : (n < Short.MIN_VALUE || n > 65535 ? Type.tInt : new IntegerType(n < -128 ? 10 : (n < 0 ? 26 : (n <= 127 ? 30 : (n <= Short.MAX_VALUE ? 14 : 6))))));
        } else if (object instanceof Long) {
            this.updateParentType(Type.tLong);
        } else if (object instanceof Float) {
            this.updateParentType(Type.tFloat);
        } else if (object instanceof Double) {
            this.updateParentType(Type.tDouble);
        } else if (object instanceof String) {
            this.updateParentType(Type.tString);
        } else if (object == null) {
            this.updateParentType(Type.tUObject);
        } else {
            throw new IllegalArgumentException("Illegal constant type: " + object.getClass());
        }
        this.value = object;
    }
}

