/*
 * Decompiled with CFR 0.152.
 */
package com.cycling74.jitter;

public class Jitter3DUtils {
    public static boolean intersectLineSphere(float[] lineA, float[] lineB, float[] center, float r, float[] p1) {
        boolean result;
        float[] EO = new float[3];
        float[] V = new float[3];
        Jitter3DUtils.vsub(center, lineA, EO);
        Jitter3DUtils.vsub(lineB, lineA, V);
        Jitter3DUtils.vnormal(V);
        float v = Jitter3DUtils.vdot(EO, V);
        float disc = r * r - (Jitter3DUtils.vdot(EO, EO) - v * v);
        if (disc < 0.0f) {
            result = false;
        } else {
            float d = (float)Math.sqrt(disc);
            Jitter3DUtils.vscale(V, v - d);
            Jitter3DUtils.vadd(V, lineA, p1);
            result = true;
        }
        return result;
    }

    public static void closestLineSphere(float[] lineA, float[] lineB, float[] center, float r, float[] p1) {
        float[] ab = new float[3];
        float[] p = new float[3];
        float x1 = lineA[0];
        float y1 = lineA[1];
        float z1 = lineA[2];
        float x2 = lineB[0];
        float y2 = lineB[1];
        float z2 = lineB[2];
        float x3 = center[0];
        float y3 = center[1];
        float z3 = center[2];
        float u = ((x3 - x1) * (x2 - x1) + (y3 - y1) * (y2 - y1) + (z3 - z1) * (z2 - z1)) / ((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1) + (z2 - z1) * (z2 - z1));
        Jitter3DUtils.vsub(lineB, lineA, ab);
        Jitter3DUtils.vscale(ab, u);
        Jitter3DUtils.vadd(lineA, ab, p);
        Jitter3DUtils.vsub(p, center, p);
        Jitter3DUtils.vnormal(p);
        Jitter3DUtils.vscale(p, r);
        Jitter3DUtils.vadd(p, center, p1);
    }

    public static boolean intersectLineQuad(float[] lineA, float[] lineB, float[] pos, float[] rot, float[] scale, float[] p1, float[] p2) {
        float[] slope = new float[3];
        float[] z0 = new float[3];
        float[] q = new float[4];
        float[] m = new float[16];
        float d2r = (float)Math.PI / 180;
        float[] axis = new float[]{rot[0], rot[1], rot[2], rot[3]};
        float[] a = new float[]{lineA[0], lineA[1], lineA[2]};
        float[] b = new float[]{lineB[0], lineB[1], lineB[2]};
        scale[2] = 1.0f;
        Jitter3DUtils.vsub(a, pos, a);
        Jitter3DUtils.vsub(b, pos, b);
        Jitter3DUtils.axisToQuat(axis, q);
        Jitter3DUtils.buildRotmatrix(m, q);
        Jitter3DUtils.transformPoint(a, m);
        Jitter3DUtils.transformPoint(b, m);
        Jitter3DUtils.vdiv(a, scale, a);
        Jitter3DUtils.vdiv(b, scale, b);
        Jitter3DUtils.vsub(a, b, slope);
        Jitter3DUtils.vscale(slope, 1.0f / slope[2]);
        Jitter3DUtils.vscale(slope, 0.0f - a[2]);
        Jitter3DUtils.vadd(a, slope, z0);
        float xz0 = z0[0];
        float yz0 = z0[1];
        Jitter3DUtils.vcopy(z0, p2);
        Jitter3DUtils.vmul(z0, scale, z0);
        axis[0] = -axis[0];
        Jitter3DUtils.axisToQuat(axis, q);
        Jitter3DUtils.buildRotmatrix(m, q);
        Jitter3DUtils.transformPoint(z0, m);
        Jitter3DUtils.vadd(z0, pos, z0);
        Jitter3DUtils.vcopy(z0, p1);
        boolean result = xz0 > 0.0f && xz0 < 1.0f && yz0 > 0.0f && yz0 < 1.0f;
        return result;
    }

    public static void xyzToAxis(float[] xyz, float[] axis) {
        float[] q1 = new float[4];
        float[] q2 = new float[4];
        float[] q3 = new float[4];
        float[] q4 = new float[4];
        float x = xyz[0];
        float y = xyz[1];
        float z = xyz[2];
        Jitter3DUtils.axisToQuat(new float[]{x, 1.0f, 0.0f, 0.0f}, q1);
        Jitter3DUtils.axisToQuat(new float[]{y, 0.0f, 1.0f, 0.0f}, q2);
        Jitter3DUtils.addQuats(q1, q2, q3);
        Jitter3DUtils.axisToQuat(new float[]{z, 0.0f, 0.0f, 1.0f}, q2);
        Jitter3DUtils.addQuats(q3, q2, q4);
        Jitter3DUtils.quatToAxis(q4, axis);
    }

    public static void axisToQuat(float[] axis, float[] quat) {
        float d2r = (float)Math.PI / 180;
        float phi = axis[0] * d2r;
        float mag = (float)Math.sqrt(axis[1] * axis[1] + axis[2] * axis[2] + axis[3] * axis[3]);
        if ((double)mag < 5.0E-4) {
            mag = 1.0f;
        }
        float scale = (float)Math.sin((double)phi / 2.0) / mag;
        quat[0] = axis[1] * scale;
        quat[1] = axis[2] * scale;
        quat[2] = axis[3] * scale;
        quat[3] = (float)Math.cos((double)phi / 2.0);
    }

    public static void quatToAxis(float[] quat, float[] axis) {
        float r2d = 57.29578f;
        float cos_a = quat[3];
        axis[0] = (float)(Math.acos(cos_a) * 2.0) * r2d;
        float sin_a = (float)Math.sqrt(1.0 - (double)(cos_a * cos_a));
        if ((double)Math.abs(sin_a) < 5.0E-5) {
            sin_a = 1.0f;
        }
        axis[1] = quat[0] / sin_a;
        axis[2] = quat[1] / sin_a;
        axis[3] = quat[2] / sin_a;
    }

    public static void addQuats(float[] q1, float[] q2, float[] result) {
        float[] t1 = new float[4];
        float[] t2 = new float[4];
        float[] t3 = new float[4];
        float[] t4 = new float[4];
        float[] tf = new float[4];
        Jitter3DUtils.vcopy(q1, t1);
        Jitter3DUtils.vscale(t1, q2[3]);
        Jitter3DUtils.vcopy(q2, t2);
        Jitter3DUtils.vscale(t2, q1[3]);
        Jitter3DUtils.vcross(q2, q1, t3);
        Jitter3DUtils.vadd(t1, t2, tf);
        Jitter3DUtils.vadd(t3, tf, tf);
        tf[3] = q1[3] * q2[3] - Jitter3DUtils.vdot(q1, q2);
        result[0] = tf[0];
        result[1] = tf[1];
        result[2] = tf[2];
        result[3] = tf[3];
        Jitter3DUtils.normalizeQuat(result);
    }

    public static void vzero(float[] v) {
        int i = 0;
        while (i < v.length) {
            v[i] = 0.0f;
            ++i;
        }
    }

    public static void vset(float[] v, float x, float y, float z) {
        v[0] = x;
        v[1] = y;
        v[2] = z;
    }

    public static void vadd(float[] src1, float[] src2, float[] dst) {
        int i = 0;
        while (i < src1.length) {
            dst[i] = src1[i] + src2[i];
            ++i;
        }
    }

    public static void vsub(float[] src1, float[] src2, float[] dst) {
        int i = 0;
        while (i < src1.length) {
            dst[i] = src1[i] - src2[i];
            ++i;
        }
    }

    public static void vmul(float[] src1, float[] src2, float[] dst) {
        int i = 0;
        while (i < src1.length) {
            dst[i] = src1[i] * src2[i];
            ++i;
        }
    }

    public static void vdiv(float[] src1, float[] src2, float[] dst) {
        int i = 0;
        while (i < src1.length) {
            dst[i] = src1[i] / src2[i];
            ++i;
        }
    }

    public static void vcopy(float[] v1, float[] v2) {
        int i = 0;
        while (i < v1.length) {
            v2[i] = v1[i];
            ++i;
        }
    }

    public static void vcross(float[] v1, float[] v2, float[] cross) {
        float[] temp = new float[]{v1[1] * v2[2] - v1[2] * v2[1], v1[2] * v2[0] - v1[0] * v2[2], v1[0] * v2[1] - v1[1] * v2[0]};
        Jitter3DUtils.vcopy(temp, cross);
    }

    public static float vlength(float[] v) {
        return (float)Math.sqrt(v[0] * v[0] + v[1] * v[1] + v[2] * v[2]);
    }

    public static float vlength2(float[] v) {
        return v[0] * v[0] + v[1] * v[1] + v[2] * v[2];
    }

    public static void vscale(float[] v, float factor) {
        int i = 0;
        while (i < v.length) {
            int n = i++;
            v[n] = v[n] * factor;
        }
    }

    public static void vnormal(float[] v) {
        float len = Jitter3DUtils.vlength(v);
        Jitter3DUtils.vscale(v, 1.0f / len);
    }

    public static float vdot(float[] v1, float[] v2) {
        return v1[0] * v2[0] + v1[1] * v2[1] + v1[2] * v2[2];
    }

    public static void normalizeQuat(float[] q) {
        float mag = q[0] * q[0] + q[1] * q[1] + q[2] * q[2] + q[3] * q[3];
        mag = 1.0f / mag;
        int i = 0;
        while (i < 4) {
            int n = i++;
            q[n] = q[n] * mag;
        }
    }

    public static void buildRotmatrix(float[] m, float[] q) {
        m[0] = 1.0f - 2.0f * (q[1] * q[1] + q[2] * q[2]);
        m[1] = 2.0f * (q[0] * q[1] - q[2] * q[3]);
        m[2] = 2.0f * (q[2] * q[0] + q[1] * q[3]);
        m[3] = 0.0f;
        m[4] = 2.0f * (q[0] * q[1] + q[2] * q[3]);
        m[5] = 1.0f - 2.0f * (q[2] * q[2] + q[0] * q[0]);
        m[6] = 2.0f * (q[1] * q[2] - q[0] * q[3]);
        m[7] = 0.0f;
        m[8] = 2.0f * (q[2] * q[0] - q[1] * q[3]);
        m[9] = 2.0f * (q[1] * q[2] + q[0] * q[3]);
        m[10] = 1.0f - 2.0f * (q[1] * q[1] + q[0] * q[0]);
        m[11] = 0.0f;
        m[12] = 0.0f;
        m[13] = 0.0f;
        m[14] = 0.0f;
        m[15] = 1.0f;
    }

    public static void transformPoint(float[] p, float[] m) {
        float[] p_in = new float[]{p[0], p[1], p[2], 1.0f};
        float a = m[0] * p_in[0] + m[4] * p_in[1] + m[8] * p_in[2] + m[12] * p_in[3];
        float b = m[1] * p_in[0] + m[5] * p_in[1] + m[9] * p_in[2] + m[13] * p_in[3];
        float c = m[2] * p_in[0] + m[6] * p_in[1] + m[10] * p_in[2] + m[14] * p_in[3];
        float d = m[3] * p_in[0] + m[7] * p_in[1] + m[11] * p_in[2] + m[15] * p_in[3];
        p[0] = a;
        p[1] = b;
        p[2] = c;
    }
}

