/*
 * Decompiled with CFR 0.152.
 */
package com.cycling74.msp;

import com.cycling74.max.MessageReceiver;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class AudioFileBuffer {
    public static final int FINISHED_READING = 1;
    private File _file;
    private AudioInputStream _ais;
    private AudioFormat _aformat;
    private int _num_channels;
    private long _framelength;
    private int _framesize;
    private int _sample_size_in_bits;
    private boolean _big_endian;
    private float _sr;
    public float[][] buf;
    private MessageReceiver _client = null;
    private buf_filler _bft;

    public AudioFileBuffer(String filename) throws FileNotFoundException, IOException, UnsupportedAudioFileException {
        this._client = null;
        this.open(filename);
    }

    public AudioFileBuffer(String filename, MessageReceiver client) throws FileNotFoundException, IOException, UnsupportedAudioFileException {
        this._client = client;
        this.open(filename);
    }

    public void open(String filename) throws FileNotFoundException, IOException, UnsupportedAudioFileException {
        this._file = new File(filename);
        if (!this._file.exists()) {
            throw new FileNotFoundException("Unable to find file " + filename);
        }
        this.kill_buf_filler();
        FileInputStream fileInputStream = new FileInputStream(this._file);
        BufferedInputStream inputStream = new BufferedInputStream(fileInputStream);
        try {
            this._ais = AudioSystem.getAudioInputStream(inputStream);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (UnsupportedAudioFileException uafe) {
            throw uafe;
        }
        this._aformat = this._ais.getFormat();
        if (this._aformat.getEncoding() != AudioFormat.Encoding.PCM_SIGNED) {
            throw new UnsupportedAudioFileException("AudioBuffer currently  only supports PCM_SIGNED encodings");
        }
        this._sr = this._aformat.getSampleRate();
        this._num_channels = this._aformat.getChannels();
        this._framelength = this._ais.getFrameLength();
        this._framesize = this._aformat.getFrameSize();
        this._sample_size_in_bits = this._aformat.getSampleSizeInBits();
        this._big_endian = this._aformat.isBigEndian();
        this.buf = new float[this._num_channels][(int)this._framelength];
        this._bft = new buf_filler(this);
        this._bft.start();
    }

    public float getSampleRate() {
        return this._sr;
    }

    public int getSampleSizeInBits() {
        return this._sample_size_in_bits;
    }

    public boolean isBigEndian() {
        return this._big_endian;
    }

    public long getFrameLength() {
        return this._framelength;
    }

    public int getChannels() {
        return this._num_channels;
    }

    public float getLengthMs() {
        return (float)this._framelength / (this.getSampleRate() / 1000.0f);
    }

    private void fill_buf() {
        byte[] tmp = new byte[2048];
        int bytesread = 0;
        short ss = 0;
        int si = 0;
        int wh = 0;
        try {
            while ((bytesread = this._ais.read(tmp, 0, tmp.length)) > 0) {
                for (int i = 0; i < bytesread; i += this._framesize) {
                    if (!this._big_endian && this._sample_size_in_bits > 8) {
                        byte t1 = 0;
                        switch (this._sample_size_in_bits) {
                            case 16: {
                                int ii;
                                for (ii = i; ii < i + this._framesize; ii += 2) {
                                    t1 = tmp[ii];
                                    tmp[ii] = tmp[ii + 1];
                                    tmp[ii + 1] = t1;
                                }
                                break;
                            }
                            case 24: {
                                int ii;
                                for (ii = i; ii < i + this._framesize; ii += 3) {
                                    t1 = tmp[ii];
                                    tmp[ii] = tmp[ii + 3];
                                    tmp[ii + 3] = t1;
                                }
                                break;
                            }
                        }
                    }
                    block15: for (int c = 0; c < this._num_channels; ++c) {
                        int ch_offset = c * this._num_channels;
                        switch (this._sample_size_in_bits) {
                            case 8: {
                                ss = (short)(tmp[i + c] & 0xFF);
                                this.buf[c][wh] = (float)ss / 16384.0f;
                                continue block15;
                            }
                            case 16: {
                                ss = (short)((tmp[i + ch_offset] & 0xFF) << 8 | tmp[i + ch_offset + 1] & 0xFF);
                                this.buf[c][wh] = (float)ss / 32767.0f;
                                continue block15;
                            }
                            case 24: {
                                si = (tmp[i + ch_offset] & 0xFF) << 16 | (tmp[i + ch_offset + 1] & 0xFF) << 8 | tmp[i + ch_offset + 2] & 0xFF;
                                this.buf[c][wh] = (float)si / 8388608.0f;
                                continue block15;
                            }
                        }
                    }
                    ++wh;
                }
            }
            this._ais.close();
            if (this._client != null) {
                this._client.messageReceived(this, 1, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void kill_buf_filler() {
        if (this._bft != null) {
            try {
                this._bft.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    class buf_filler
    extends Thread {
        AudioFileBuffer _p = null;

        public buf_filler(AudioFileBuffer p) {
            this._p = p;
        }

        public void run() {
            this._p.fill_buf();
        }
    }
}

