/*
 * Decompiled with CFR 0.152.
 */
package com.cycling74.max;

import com.cycling74.max.Atom;
import com.cycling74.max.MaxBox;
import com.cycling74.max.MaxWindow;

public class MaxPatcher {
    private long _p_patcher = 0L;
    private MaxWindow _window = null;

    protected MaxPatcher(long p_patcher) {
        this._p_patcher = p_patcher;
        this._window = null;
    }

    public MaxPatcher(int x1, int y1, int x2, int y2) {
        long p = this._patcher_construct(x1, y1, x2, y2);
        this._p_patcher = p != 0L ? p : 0L;
        this._window = null;
    }

    public native String getPath();

    public native long send(String var1, Atom[] var2);

    public native void setBackgroundColor(int var1, int var2, int var3);

    public native boolean isBPatcher();

    private native long _get_named_box(String var1);

    public MaxBox getNamedBox(String name) {
        long p_box = this._get_named_box(name);
        if (p_box != 0L) {
            return new MaxBox(this, p_box);
        }
        return null;
    }

    public MaxBox[] getAllBoxes() {
        long[] peers = this._get_all_boxes();
        if (peers != null) {
            int len = peers.length;
            MaxBox[] ret = new MaxBox[len];
            for (int i = 0; i < peers.length; ++i) {
                ret[i] = new MaxBox(this, peers[i]);
            }
            return ret;
        }
        return null;
    }

    public MaxBox newDefault(int x, int y, String maxclassname, Atom[] args) {
        long p = 0L;
        p = this._new_default(x, y, maxclassname, args);
        if (p != 0L) {
            return new MaxBox(this, p);
        }
        return null;
    }

    public MaxBox newObject(String msg, Atom[] args) {
        long p = 0L;
        p = this._new_object(msg, args);
        if (p != 0L) {
            return new MaxBox(this, p);
        }
        return null;
    }

    public void connect(MaxBox b1, int outlet, MaxBox b2, int inlet, int color) {
        this._connect(b1.getPeer(), outlet, b2.getPeer(), inlet, color);
    }

    public void connect(MaxBox b1, int outlet, MaxBox b2, int inlet) {
        this._connect(b1.getPeer(), outlet, b2.getPeer(), inlet, 0);
    }

    public void disconnect(MaxBox b1, int outlet, MaxBox b2, int inlet) {
        this._disconnect(b1.getPeer(), outlet, b2.getPeer(), inlet);
    }

    public MaxWindow getWindow() {
        if (this._window != null) {
            return this._window;
        }
        long pw = this._get_window_ptr();
        if (pw != 0L) {
            this._window = new MaxWindow(pw);
            return this._window;
        }
        return null;
    }

    public native String getName();

    public native boolean isLocked();

    public native String getParentMaxClass();

    public native int[] getOffset();

    public native int[] getOrigin();

    public native int getCount();

    public native String getFilePath();

    public native void setLocked(boolean var1);

    private native long _new_object(String var1, Atom[] var2);

    private native long _new_default(int var1, int var2, String var3, Atom[] var4);

    private native void _connect(long var1, int var3, long var4, int var6, int var7);

    private native void _disconnect(long var1, int var3, long var4, int var6);

    private native long[] _get_all_boxes();

    private native long _patcher_construct(int var1, int var2, int var3, int var4);

    private native long _get_window_ptr();

    protected void finalize() {
        this._free();
    }

    private native void _free();

    public boolean equals(Object o) {
        if (o instanceof MaxPatcher) {
            MaxPatcher p = (MaxPatcher)o;
            if (this._p_patcher == p._p_patcher) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return (int)this._p_patcher;
    }
}

