/*
 * Decompiled with CFR 0.152.
 */
package com.cycling74.jitter;

import com.cycling74.jitter.JitterObject;
import com.cycling74.max.Atom;
import com.cycling74.max.MaxSystem;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Hashtable;

public class JitterMatrix
extends JitterObject {
    public JitterMatrix() {
        this._constructor_helper(new Atom[0]);
    }

    public JitterMatrix(String name) {
        this._constructor_helper(new Atom[]{Atom.newAtom((String)name)});
    }

    public JitterMatrix(Atom[] args) {
        this._constructor_helper(args);
    }

    public JitterMatrix(int planecount, String type, int[] dim) {
        this._constructor_helper(planecount, type, dim);
    }

    public JitterMatrix(String name, int planecount, String type, int[] dim) {
        this._constructor_helper(name, planecount, type, dim);
    }

    public JitterMatrix(int planecount, String type, int x_dim) {
        this._constructor_helper(planecount, type, new int[]{x_dim});
    }

    public JitterMatrix(String name, int planecount, String type, int x_dim) {
        this._constructor_helper(name, planecount, type, new int[]{x_dim});
    }

    public JitterMatrix(int planecount, String type, int x_dim, int y_dim) {
        this._constructor_helper(planecount, type, new int[]{x_dim, y_dim});
    }

    public JitterMatrix(String name, int planecount, String type, int x_dim, int y_dim) {
        this._constructor_helper(name, planecount, type, new int[]{x_dim, y_dim});
    }

    public JitterMatrix(int planecount, String type, int x_dim, int y_dim, int z_dim) {
        this._constructor_helper(planecount, type, new int[]{x_dim, y_dim, z_dim});
    }

    public JitterMatrix(String name, int planecount, String type, int x_dim, int y_dim, int z_dim) {
        this._constructor_helper(name, planecount, type, new int[]{x_dim, y_dim, z_dim});
    }

    public JitterMatrix(BufferedImage img) {
        int imageWidth = img.getWidth();
        int imageHeight = img.getHeight();
        this._constructor_helper(4, "char", new int[]{imageWidth, imageHeight});
        this.copyBufferedImage(img);
    }

    private void _constructor_helper(int planecount, String type, int[] dim) {
        int len = dim.length + 2;
        Atom[] atoms = new Atom[len];
        atoms[0] = Atom.newAtom((int)planecount);
        atoms[1] = Atom.newAtom((String)type);
        int i = 2;
        while (i < len) {
            atoms[i] = Atom.newAtom((int)dim[i - 2]);
            ++i;
        }
        this._constructor_helper(atoms);
    }

    private void _constructor_helper(String name, int planecount, String type, int[] dim) {
        int len = dim.length + 3;
        Atom[] atoms = new Atom[len];
        atoms[0] = Atom.newAtom((String)name);
        atoms[1] = Atom.newAtom((int)planecount);
        atoms[2] = Atom.newAtom((String)type);
        int i = 3;
        while (i < len) {
            atoms[i] = Atom.newAtom((int)dim[i - 3]);
            ++i;
        }
        this._constructor_helper(atoms);
    }

    private void _constructor_helper(Atom[] args) {
        this._p_obj = this._new("jit.matrix", args);
        if (this._p_obj == 0L) {
            MaxSystem.error((String)"Could not instantiate class jit.matrix");
        }
    }

    public boolean getAdapt() {
        return this.getAttrInt("adapt") == 0;
    }

    public int[] getDim() {
        return this.getAttrIntArray("dim");
    }

    public int[] getDstdimend() {
        return this.getAttrIntArray("dstdimend");
    }

    public int[] getDstdimstart() {
        return this.getAttrIntArray("dstdimstart");
    }

    public boolean getInterp() {
        return this.getAttrInt("interp") == 0;
    }

    public String getName() {
        return this.getAttrString("name");
    }

    public int getPlanecount() {
        return this.getAttrInt("planecount");
    }

    public int[] getPlanemap() {
        return this.getAttrIntArray("planemap");
    }

    public int[] getSrcdimend() {
        return this.getAttrIntArray("srcdimend");
    }

    public int[] getSrcdimstart() {
        return this.getAttrIntArray("srcdimstart");
    }

    public String getType() {
        return this.getAttrString("type");
    }

    public boolean getUsedstdim() {
        return this.getAttrInt("usedstdim") == 0;
    }

    public boolean getUsesrcdim() {
        return this.getAttrInt("usesrcdim") == 0;
    }

    public boolean setAdapt(int on) {
        return this.setAttr("adapt", on);
    }

    public boolean setAdapt(boolean on) {
        return this.setAttr("adapt", on ? 1 : 0);
    }

    public boolean setDim(int[] dim) {
        return this.setAttr("dim", dim);
    }

    public boolean setDstdimend(int[] dim) {
        return this.setAttr("dstdimend", dim);
    }

    public boolean setDstdimstart(int[] dim) {
        return this.setAttr("dstdimstart", dim);
    }

    public boolean setName(String name) {
        return this.setAttr("name", name);
    }

    public boolean setInterp(int on) {
        return this.setAttr("interp", on);
    }

    public boolean setInterp(boolean on) {
        return this.setAttr("interp", on ? 1 : 0);
    }

    public boolean setPlanecount(int count) {
        return this.setAttr("planecount", count);
    }

    public boolean setPlanemap(int[] map) {
        return this.setAttr("planemap", map);
    }

    public boolean setSrcdimend(int[] dim) {
        return this.setAttr("srcdimend", dim);
    }

    public boolean setSrcdimstart(int[] dim) {
        return this.setAttr("srcdimstart", dim);
    }

    public boolean setType(String type) {
        return this.setAttr("type", type);
    }

    public void clear() {
        this.send("clear");
    }

    public Atom[] exportimage() {
        return this.send("exportimage");
    }

    public Atom[] exportimage(String filename) {
        return this.send("exportimage", filename);
    }

    public Atom[] exportimage(Atom[] args) {
        return this.send("exportimage", args);
    }

    public Atom[] exportmovie() {
        return this.send("exportmovie");
    }

    public Atom[] exportmovie(String filename) {
        return this.send("exportmovie", filename);
    }

    public Atom[] exportmovie(Atom[] args) {
        return this.send("exportmovie", args);
    }

    public void frommatrix(String matrixname) {
        this.send("frommatrix", matrixname);
    }

    public void frommatrix(JitterMatrix matrix) {
        this.send("frommatrix", matrix.getName());
    }

    public void copyBufferedImage(BufferedImage img) {
        int imageWidth = img.getWidth();
        int imageHeight = img.getHeight();
        this.setType("char");
        this.setPlanecount(4);
        this.setDim(new int[]{imageWidth, imageHeight});
        int[] imageData = img.getRGB(0, 0, imageWidth, imageHeight, null, 0, imageWidth);
        this.copyPackedIntArrayToMatrix(imageData);
    }

    public BufferedImage createBufferedImage() {
        if (!this.getType().equals("char")) {
            return null;
        }
        int[] dim = this.getDim();
        if (dim.length != 2) {
            return null;
        }
        int imageDepth = 8;
        int pixelStride = 4;
        int[] numBits = new int[pixelStride];
        int[] bandoffsets = new int[pixelStride];
        int i = 0;
        while (i < pixelStride) {
            numBits[i] = imageDepth;
            bandoffsets[i] = i;
            ++i;
        }
        ComponentColorModel ccm = new ComponentColorModel(ColorSpace.getInstance(1000), numBits, true, false, 3, 0);
        int[] offset = new int[2];
        int[] data = new int[dim[0] * dim[1] * pixelStride];
        int i2 = 0;
        while (i2 < dim[1]) {
            offset[1] = i2;
            this.copyVectorToArray(0, offset, data, dim[0] * 4, i2 * dim[0] * 4);
            ++i2;
        }
        byte[] datab = new byte[dim[0] * dim[1] * pixelStride];
        int i3 = 0;
        while (i3 < data.length) {
            byte alpha = (byte)data[i3++];
            datab[i3 - 1] = (byte)data[i3++];
            datab[i3 - 1] = (byte)data[i3++];
            datab[i3 - 1] = (byte)data[i3++];
            datab[i3 - 1] = alpha;
        }
        PixelInterleavedSampleModel csm = new PixelInterleavedSampleModel(0, dim[0], dim[1], pixelStride, dim[0] * pixelStride, bandoffsets);
        DataBufferByte databuf = new DataBufferByte(datab, dim[0] * dim[1] * pixelStride);
        WritableRaster wr = Raster.createWritableRaster(csm, databuf, new Point(0, 0));
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("owner", "Jitter");
        return new BufferedImage(ccm, wr, false, ht);
    }

    public Atom[] getcell(int[] position) {
        return this.send("getcell", position);
    }

    public Atom[] getcell1d(int x) {
        return this.getcell3d(x, 0, 0);
    }

    public Atom[] getcell2d(int x, int y) {
        return this.getcell3d(x, y, 0);
    }

    public native Atom[] getcell3d(int var1, int var2, int var3);

    public native int[] getcellInt(int[] var1);

    public int[] getcell1dInt(int x) {
        return this.getcell3dInt(x, 0, 0);
    }

    public int[] getcell2dInt(int x, int y) {
        return this.getcell3dInt(x, y, 0);
    }

    public native int[] getcell3dInt(int var1, int var2, int var3);

    public native float[] getcellFloat(int[] var1);

    public float[] getcell1dFloat(int x) {
        return this.getcell3dFloat(x, 0, 0);
    }

    public float[] getcell2dFloat(int x, int y) {
        return this.getcell3dFloat(x, y, 0);
    }

    public native float[] getcell3dFloat(int var1, int var2, int var3);

    public native double[] getcellDouble(int[] var1);

    public double[] getcell1dDouble(int x) {
        return this.getcell3dDouble(x, 0, 0);
    }

    public double[] getcell2dDouble(int x, int y) {
        return this.getcell3dDouble(x, y, 0);
    }

    public native double[] getcell3dDouble(int var1, int var2, int var3);

    public String importmovie() {
        Atom[] a = this.send("importmovie");
        if (a[0].toString().equals("<none>")) {
            return null;
        }
        return a[0].toString();
    }

    public String importmovie(String filename) {
        Atom[] a = this.send("importmovie", filename);
        if (a[0].toString().equals("<none>")) {
            return null;
        }
        return a[0].toString();
    }

    public String importmovie(Atom[] args) {
        Atom[] a = this.send("importmovie", args);
        if (a[0].toString().equals("<none>")) {
            return null;
        }
        return a[0].toString();
    }

    public void op(String op) {
        this.send("op", op);
    }

    public void op(String op, String matrixname) {
        this.send("op", new String[]{op, matrixname});
    }

    public void op(String op, String a_matrixname, String b_matrixname) {
        this.send("op", new String[]{op, a_matrixname, b_matrixname});
    }

    public void op(String op, JitterMatrix matrix) {
        this.send("op", new String[]{op, matrix.getName()});
    }

    public void op(String op, JitterMatrix a_matrix, JitterMatrix b_matrix) {
        this.send("op", new String[]{op, a_matrix.getName(), b_matrix.getName()});
    }

    public void op(String op, int val) {
        this.send("op", new Atom[]{Atom.newAtom((String)op), Atom.newAtom((int)val)});
    }

    public void op(String op, float val) {
        this.send("op", new Atom[]{Atom.newAtom((String)op), Atom.newAtom((float)val)});
    }

    public void op(String op, double val) {
        this.send("op", new Atom[]{Atom.newAtom((String)op), Atom.newAtom((double)val)});
    }

    public void op(String op, String matrixname, int val) {
        this.send("op", new Atom[]{Atom.newAtom((String)op), Atom.newAtom((String)matrixname), Atom.newAtom((int)val)});
    }

    public void op(String op, String matrixname, float val) {
        this.send("op", new Atom[]{Atom.newAtom((String)op), Atom.newAtom((String)matrixname), Atom.newAtom((float)val)});
    }

    public void op(String op, String matrixname, double val) {
        this.send("op", new Atom[]{Atom.newAtom((String)op), Atom.newAtom((String)matrixname), Atom.newAtom((double)val)});
    }

    public void op(String op, JitterMatrix matrix, int val) {
        this.send("op", new Atom[]{Atom.newAtom((String)op), Atom.newAtom((String)matrix.getName()), Atom.newAtom((int)val)});
    }

    public void op(String op, JitterMatrix matrix, float val) {
        this.send("op", new Atom[]{Atom.newAtom((String)op), Atom.newAtom((String)matrix.getName()), Atom.newAtom((float)val)});
    }

    public void op(String op, JitterMatrix matrix, double val) {
        this.send("op", new Atom[]{Atom.newAtom((String)op), Atom.newAtom((String)matrix.getName()), Atom.newAtom((double)val)});
    }

    public void op(String op, int[] vals) {
        Atom[] a = new Atom[vals.length + 1];
        a[0] = Atom.newAtom((String)op);
        int i = 0;
        while (i < vals.length) {
            a[i + 1] = Atom.newAtom((int)vals[i]);
            ++i;
        }
        this.send("op", a);
    }

    public void op(String op, float[] vals) {
        Atom[] a = new Atom[vals.length + 1];
        a[0] = Atom.newAtom((String)op);
        int i = 0;
        while (i < vals.length) {
            a[i + 1] = Atom.newAtom((float)vals[i]);
            ++i;
        }
        this.send("op", a);
    }

    public void op(String op, double[] vals) {
        Atom[] a = new Atom[vals.length + 1];
        a[0] = Atom.newAtom((String)op);
        int i = 0;
        while (i < vals.length) {
            a[i + 1] = Atom.newAtom((double)vals[i]);
            ++i;
        }
        this.send("op", a);
    }

    public void op(String op, String matrixname, int[] vals) {
        Atom[] a = new Atom[vals.length + 2];
        a[0] = Atom.newAtom((String)op);
        a[1] = Atom.newAtom((String)matrixname);
        int i = 0;
        while (i < vals.length) {
            a[i + 2] = Atom.newAtom((int)vals[i]);
            ++i;
        }
        this.send("op", a);
    }

    public void op(String op, String matrixname, float[] vals) {
        Atom[] a = new Atom[vals.length + 2];
        a[0] = Atom.newAtom((String)op);
        a[1] = Atom.newAtom((String)matrixname);
        int i = 0;
        while (i < vals.length) {
            a[i + 2] = Atom.newAtom((float)vals[i]);
            ++i;
        }
        this.send("op", a);
    }

    public void op(String op, String matrixname, double[] vals) {
        Atom[] a = new Atom[vals.length + 2];
        a[0] = Atom.newAtom((String)op);
        a[1] = Atom.newAtom((String)matrixname);
        int i = 0;
        while (i < vals.length) {
            a[i + 2] = Atom.newAtom((double)vals[i]);
            ++i;
        }
        this.send("op", a);
    }

    public void op(String op, JitterMatrix matrix, int[] vals) {
        Atom[] a = new Atom[vals.length + 2];
        a[0] = Atom.newAtom((String)op);
        a[1] = Atom.newAtom((String)matrix.getName());
        int i = 0;
        while (i < vals.length) {
            a[i + 2] = Atom.newAtom((int)vals[i]);
            ++i;
        }
        this.send("op", a);
    }

    public void op(String op, JitterMatrix matrix, float[] vals) {
        Atom[] a = new Atom[vals.length + 2];
        a[0] = Atom.newAtom((String)op);
        a[1] = Atom.newAtom((String)matrix.getName());
        int i = 0;
        while (i < vals.length) {
            a[i + 2] = Atom.newAtom((float)vals[i]);
            ++i;
        }
        this.send("op", a);
    }

    public void op(String op, JitterMatrix matrix, double[] vals) {
        Atom[] a = new Atom[vals.length + 2];
        a[0] = Atom.newAtom((String)op);
        a[1] = Atom.newAtom((String)matrix.getName());
        int i = 0;
        while (i < vals.length) {
            a[i + 2] = Atom.newAtom((double)vals[i]);
            ++i;
        }
        this.send("op", a);
    }

    public Atom[] read() {
        return this.send("read");
    }

    public Atom[] read(String filename) {
        return this.send("read", filename);
    }

    public Atom[] read(Atom[] args) {
        return this.send("read", args);
    }

    public void setall(Atom val) {
        this.send("setall", new Atom[]{val});
    }

    public void setall(Atom[] vals) {
        this.send("setall", vals);
    }

    public void setall(int val) {
        this.send("setall", val);
    }

    public void setall(int[] vals) {
        this.send("setall", vals);
    }

    public void setall(float val) {
        this.send("setall", val);
    }

    public void setall(float[] vals) {
        this.send("setall", vals);
    }

    public void setall(double val) {
        this.setall(new double[]{val});
    }

    public native void setall(double[] var1);

    public void setcell(Atom[] args) {
        this.send("setcell", args);
    }

    public native void setcell(int[] var1, int[] var2);

    public native void setcell(int[] var1, float[] var2);

    public native void setcell(int[] var1, double[] var2);

    public native void setcell(int[] var1, int var2, int var3);

    public native void setcell(int[] var1, int var2, float var3);

    public native void setcell(int[] var1, int var2, double var3);

    public void setcell1d(int x, int[] vals) {
        this.setcell3d(x, 0, 0, vals);
    }

    public void setcell1d(int x, float[] vals) {
        this.setcell3d(x, 0, 0, vals);
    }

    public void setcell1d(int x, double[] vals) {
        this.setcell3d(x, 0, 0, vals);
    }

    public void setcell2d(int x, int y, int[] vals) {
        this.setcell3d(x, y, 0, vals);
    }

    public void setcell2d(int x, int y, float[] vals) {
        this.setcell3d(x, y, 0, vals);
    }

    public void setcell2d(int x, int y, double[] vals) {
        this.setcell3d(x, y, 0, vals);
    }

    public native void setcell3d(int var1, int var2, int var3, int[] var4);

    public native void setcell3d(int var1, int var2, int var3, float[] var4);

    public native void setcell3d(int var1, int var2, int var3, double[] var4);

    public void setinfo(String matrixname) {
        this.send("setinfo", matrixname);
    }

    public void setinfo(JitterMatrix matrix) {
        this.send("setinfo", matrix.getName());
    }

    public Atom[] write() {
        return this.send("write");
    }

    public Atom[] write(String filename) {
        return this.send("write", filename);
    }

    public Atom[] write(Atom[] args) {
        return this.send("write", args);
    }

    public native int copyVectorToArray(int var1, int[] var2, int[] var3, int var4, int var5);

    public native int copyVectorToArray(int var1, int[] var2, float[] var3, int var4, int var5);

    public native int copyVectorToArray(int var1, int[] var2, double[] var3, int var4, int var5);

    public native int copyVectorToArrayPlanar(int var1, int var2, int[] var3, int[] var4, int var5, int var6);

    public native int copyVectorToArrayPlanar(int var1, int var2, int[] var3, float[] var4, int var5, int var6);

    public native int copyVectorToArrayPlanar(int var1, int var2, int[] var3, double[] var4, int var5, int var6);

    public native int copyArrayToVector(int var1, int[] var2, int[] var3, int var4, int var5);

    public native int copyArrayToVector(int var1, int[] var2, float[] var3, int var4, int var5);

    public native int copyArrayToVector(int var1, int[] var2, double[] var3, int var4, int var5);

    public native int copyArrayToVectorPlanar(int var1, int var2, int[] var3, int[] var4, int var5, int var6);

    public native int copyArrayToVectorPlanar(int var1, int var2, int[] var3, float[] var4, int var5, int var6);

    public native int copyArrayToVectorPlanar(int var1, int var2, int[] var3, double[] var4, int var5, int var6);

    public native int copyPackedIntArrayToMatrix(int[] var1);

    public native int copyMatrixToArray(int[] var1);

    public native int copyMatrixToArray(float[] var1);

    public native int copyMatrixToArray(double[] var1);

    public native int copyArrayToMatrix(int[] var1);

    public native int copyArrayToMatrix(float[] var1);

    public native int copyArrayToMatrix(double[] var1);
}

