/*
 * Decompiled with CFR 0.152.
 */
package jode.decompiler;

import jode.AssertError;
import jode.bytecode.Instruction;
import jode.bytecode.Reference;
import jode.decompiler.LocalInfo;
import jode.decompiler.MethodAnalyzer;
import jode.expr.ArrayLengthOperator;
import jode.expr.ArrayLoadOperator;
import jode.expr.ArrayStoreOperator;
import jode.expr.BinaryOperator;
import jode.expr.CheckCastOperator;
import jode.expr.CompareBinaryOperator;
import jode.expr.CompareToIntOperator;
import jode.expr.CompareUnaryOperator;
import jode.expr.ConstOperator;
import jode.expr.ConvertOperator;
import jode.expr.Expression;
import jode.expr.GetFieldOperator;
import jode.expr.IIncOperator;
import jode.expr.InstanceOfOperator;
import jode.expr.InvokeOperator;
import jode.expr.LocalLoadOperator;
import jode.expr.LocalStoreOperator;
import jode.expr.MonitorEnterOperator;
import jode.expr.MonitorExitOperator;
import jode.expr.NewArrayOperator;
import jode.expr.NewOperator;
import jode.expr.NopOperator;
import jode.expr.PutFieldOperator;
import jode.expr.ShiftOperator;
import jode.expr.StoreInstruction;
import jode.expr.UnaryOperator;
import jode.flow.ConditionalBlock;
import jode.flow.EmptyBlock;
import jode.flow.FlowBlock;
import jode.flow.InstructionBlock;
import jode.flow.JsrBlock;
import jode.flow.Jump;
import jode.flow.RetBlock;
import jode.flow.ReturnBlock;
import jode.flow.SpecialBlock;
import jode.flow.StructuredBlock;
import jode.flow.SwitchBlock;
import jode.flow.ThrowBlock;
import jode.type.IntegerType;
import jode.type.Type;

public abstract class Opcodes
implements jode.bytecode.Opcodes {
    private static final Type tIntHint = new IntegerType(2, 30);
    private static final Type tBoolIntHint = new IntegerType(3, 31);
    private static final int LOCAL_TYPES = 0;
    private static final int ARRAY_TYPES = 1;
    private static final int UNARY_TYPES = 2;
    private static final int I2BCS_TYPES = 3;
    private static final int BIN_TYPES = 4;
    private static final int ZBIN_TYPES = 5;
    private static final Type[][] types = new Type[][]{{Type.tBoolUInt, Type.tLong, Type.tFloat, Type.tDouble, Type.tUObject}, {Type.tInt, Type.tLong, Type.tFloat, Type.tDouble, Type.tUObject, Type.tBoolByte, Type.tChar, Type.tShort}, {Type.tInt, Type.tLong, Type.tFloat, Type.tDouble, Type.tUObject}, {Type.tByte, Type.tChar, Type.tShort}, {tIntHint, Type.tLong, Type.tFloat, Type.tDouble, Type.tUObject}, {tBoolIntHint, Type.tLong, Type.tFloat, Type.tDouble, Type.tUObject}};

    private static StructuredBlock createNormal(MethodAnalyzer methodAnalyzer, Instruction instruction, Expression expression) {
        return new InstructionBlock(expression, new Jump(FlowBlock.NEXT_BY_ADDR));
    }

    private static StructuredBlock createSpecial(MethodAnalyzer methodAnalyzer, Instruction instruction, int n, int n2, int n3) {
        return new SpecialBlock(n, n2, n3, new Jump(FlowBlock.NEXT_BY_ADDR));
    }

    private static StructuredBlock createGoto(MethodAnalyzer methodAnalyzer, Instruction instruction) {
        return new EmptyBlock(new Jump((FlowBlock)instruction.getSingleSucc().getTmpInfo()));
    }

    private static StructuredBlock createJsr(MethodAnalyzer methodAnalyzer, Instruction instruction) {
        return new JsrBlock(new Jump((FlowBlock)instruction.getSingleSucc().getTmpInfo()), new Jump(FlowBlock.NEXT_BY_ADDR));
    }

    private static StructuredBlock createIfGoto(MethodAnalyzer methodAnalyzer, Instruction instruction, Expression expression) {
        return new ConditionalBlock(expression, new Jump((FlowBlock)instruction.getSingleSucc().getTmpInfo()), new Jump(FlowBlock.NEXT_BY_ADDR));
    }

    private static StructuredBlock createSwitch(MethodAnalyzer methodAnalyzer, Instruction instruction, int[] nArray, FlowBlock[] flowBlockArray) {
        return new SwitchBlock(new NopOperator(Type.tUInt), nArray, flowBlockArray);
    }

    private static StructuredBlock createBlock(MethodAnalyzer methodAnalyzer, Instruction instruction, StructuredBlock structuredBlock) {
        return structuredBlock;
    }

    private static StructuredBlock createRet(MethodAnalyzer methodAnalyzer, Instruction instruction, LocalInfo localInfo) {
        return new RetBlock(localInfo);
    }

    public static StructuredBlock readOpcode(Instruction instruction, MethodAnalyzer methodAnalyzer) throws ClassFormatError {
        int n = instruction.getOpcode();
        switch (n) {
            case 0: {
                return Opcodes.createBlock(methodAnalyzer, instruction, new EmptyBlock(new Jump(FlowBlock.NEXT_BY_ADDR)));
            }
            case 18: 
            case 20: {
                return Opcodes.createNormal(methodAnalyzer, instruction, new ConstOperator(instruction.getConstant()));
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                return Opcodes.createNormal(methodAnalyzer, instruction, new LocalLoadOperator(types[0][n - 21], methodAnalyzer, methodAnalyzer.getLocalInfo(instruction.getAddr(), instruction.getLocalSlot())));
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                return Opcodes.createNormal(methodAnalyzer, instruction, new ArrayLoadOperator(types[1][n - 46]));
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                return Opcodes.createNormal(methodAnalyzer, instruction, new StoreInstruction(new LocalStoreOperator(types[0][n - 54], methodAnalyzer.getLocalInfo(instruction.getNextByAddr().getAddr(), instruction.getLocalSlot()))));
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                return Opcodes.createNormal(methodAnalyzer, instruction, new StoreInstruction(new ArrayStoreOperator(types[1][n - 79])));
            }
            case 87: 
            case 88: {
                return Opcodes.createSpecial(methodAnalyzer, instruction, SpecialBlock.POP, n - 87 + 1, 0);
            }
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: {
                return Opcodes.createSpecial(methodAnalyzer, instruction, SpecialBlock.DUP, (n - 89) / 3 + 1, (n - 89) % 3);
            }
            case 95: {
                return Opcodes.createSpecial(methodAnalyzer, instruction, SpecialBlock.SWAP, 1, 0);
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: {
                return Opcodes.createNormal(methodAnalyzer, instruction, new BinaryOperator(types[4][(n - 96) % 4], (n - 96) / 4 + 1));
            }
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                return Opcodes.createNormal(methodAnalyzer, instruction, new UnaryOperator(types[2][n - 116], 36));
            }
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: {
                return Opcodes.createNormal(methodAnalyzer, instruction, new ShiftOperator(types[2][(n - 120) % 2], (n - 120) / 2 + 6));
            }
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: {
                return Opcodes.createNormal(methodAnalyzer, instruction, new BinaryOperator(types[5][(n - 126) % 2], (n - 126) / 2 + 9));
            }
            case 132: {
                int n2 = instruction.getIncrement();
                int n3 = 1;
                if (n2 < 0) {
                    n2 = -n2;
                    n3 = 2;
                }
                LocalInfo localInfo = methodAnalyzer.getLocalInfo(instruction.getAddr(), instruction.getLocalSlot());
                return Opcodes.createNormal(methodAnalyzer, instruction, new IIncOperator(new LocalStoreOperator(Type.tInt, localInfo), n2, n3 + 12));
            }
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: {
                int n4 = (n - 133) / 3;
                int n5 = (n - 133) % 3;
                if (n5 >= n4) {
                    ++n5;
                }
                return Opcodes.createNormal(methodAnalyzer, instruction, new ConvertOperator(types[2][n4], types[2][n5]));
            }
            case 145: 
            case 146: 
            case 147: {
                return Opcodes.createNormal(methodAnalyzer, instruction, new ConvertOperator(types[2][0], types[3][n - 145]));
            }
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: {
                return Opcodes.createNormal(methodAnalyzer, instruction, new CompareToIntOperator(types[4][(n - 145) / 2], n == 150 || n == 152));
            }
            case 153: 
            case 154: {
                return Opcodes.createIfGoto(methodAnalyzer, instruction, new CompareUnaryOperator(Type.tBoolInt, n - 127));
            }
            case 155: 
            case 156: 
            case 157: 
            case 158: {
                return Opcodes.createIfGoto(methodAnalyzer, instruction, new CompareUnaryOperator(Type.tInt, n - 127));
            }
            case 159: 
            case 160: {
                return Opcodes.createIfGoto(methodAnalyzer, instruction, new CompareBinaryOperator(tBoolIntHint, n - 133));
            }
            case 161: 
            case 162: 
            case 163: 
            case 164: {
                return Opcodes.createIfGoto(methodAnalyzer, instruction, new CompareBinaryOperator(tIntHint, n - 133));
            }
            case 165: 
            case 166: {
                return Opcodes.createIfGoto(methodAnalyzer, instruction, new CompareBinaryOperator(Type.tUObject, n - 139));
            }
            case 167: {
                return Opcodes.createGoto(methodAnalyzer, instruction);
            }
            case 168: {
                return Opcodes.createJsr(methodAnalyzer, instruction);
            }
            case 169: {
                return Opcodes.createRet(methodAnalyzer, instruction, methodAnalyzer.getLocalInfo(instruction.getAddr(), instruction.getLocalSlot()));
            }
            case 171: {
                int[] nArray = instruction.getValues();
                FlowBlock[] flowBlockArray = new FlowBlock[instruction.getSuccs().length];
                int n6 = 0;
                while (n6 < flowBlockArray.length) {
                    flowBlockArray[n6] = (FlowBlock)instruction.getSuccs()[n6].getTmpInfo();
                    ++n6;
                }
                flowBlockArray[nArray.length] = (FlowBlock)instruction.getSuccs()[nArray.length].getTmpInfo();
                return Opcodes.createSwitch(methodAnalyzer, instruction, nArray, flowBlockArray);
            }
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: {
                Type type = Type.tSubType(methodAnalyzer.getReturnType());
                return Opcodes.createBlock(methodAnalyzer, instruction, new ReturnBlock(new NopOperator(type)));
            }
            case 177: {
                return Opcodes.createBlock(methodAnalyzer, instruction, new EmptyBlock(new Jump(FlowBlock.END_OF_METHOD)));
            }
            case 178: 
            case 180: {
                Reference reference = instruction.getReference();
                return Opcodes.createNormal(methodAnalyzer, instruction, new GetFieldOperator(methodAnalyzer, n == 178, reference));
            }
            case 179: 
            case 181: {
                Reference reference = instruction.getReference();
                return Opcodes.createNormal(methodAnalyzer, instruction, new StoreInstruction(new PutFieldOperator(methodAnalyzer, n == 179, reference)));
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                Reference reference = instruction.getReference();
                int n7 = reference.getName().equals("<init>") ? 3 : (n == 184 ? 2 : (n == 183 ? 1 : 0));
                StructuredBlock structuredBlock = Opcodes.createNormal(methodAnalyzer, instruction, new InvokeOperator(methodAnalyzer, n7, reference));
                return structuredBlock;
            }
            case 187: {
                Type type = Type.tType(instruction.getClazzType());
                methodAnalyzer.useType(type);
                return Opcodes.createNormal(methodAnalyzer, instruction, new NewOperator(type));
            }
            case 190: {
                return Opcodes.createNormal(methodAnalyzer, instruction, new ArrayLengthOperator());
            }
            case 191: {
                return Opcodes.createBlock(methodAnalyzer, instruction, new ThrowBlock(new NopOperator(Type.tUObject)));
            }
            case 192: {
                Type type = Type.tType(instruction.getClazzType());
                methodAnalyzer.useType(type);
                return Opcodes.createNormal(methodAnalyzer, instruction, new CheckCastOperator(type));
            }
            case 193: {
                Type type = Type.tType(instruction.getClazzType());
                methodAnalyzer.useType(type);
                return Opcodes.createNormal(methodAnalyzer, instruction, new InstanceOfOperator(type));
            }
            case 194: {
                return Opcodes.createNormal(methodAnalyzer, instruction, new MonitorEnterOperator());
            }
            case 195: {
                return Opcodes.createNormal(methodAnalyzer, instruction, new MonitorExitOperator());
            }
            case 197: {
                Type type = Type.tType(instruction.getClazzType());
                methodAnalyzer.useType(type);
                int n8 = instruction.getDimensions();
                return Opcodes.createNormal(methodAnalyzer, instruction, new NewArrayOperator(type, n8));
            }
            case 198: 
            case 199: {
                return Opcodes.createIfGoto(methodAnalyzer, instruction, new CompareUnaryOperator(Type.tUObject, n - 172));
            }
        }
        throw new AssertError("Invalid opcode " + n);
    }
}

