/*
 * Decompiled with CFR 0.152.
 */
package jode.decompiler;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Set;
import jode.bytecode.FieldInfo;
import jode.decompiler.Analyzer;
import jode.decompiler.ClassAnalyzer;
import jode.decompiler.ImportHandler;
import jode.decompiler.LocalInfo;
import jode.decompiler.TabbedPrintWriter;
import jode.expr.ConstOperator;
import jode.expr.Expression;
import jode.expr.OuterLocalOperator;
import jode.type.Type;

public class FieldAnalyzer
implements Analyzer {
    ClassAnalyzer clazz;
    ImportHandler imports;
    int modifiers;
    Type type;
    String fieldName;
    Expression constant;
    boolean isSynthetic;
    boolean isDeprecated;
    boolean analyzedSynthetic = false;

    public String getName() {
        return this.fieldName;
    }

    public Type getType() {
        return this.type;
    }

    public ClassAnalyzer getClassAnalyzer() {
        return this.clazz;
    }

    public Expression getConstant() {
        return this.constant;
    }

    public boolean isSynthetic() {
        return this.isSynthetic;
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.modifiers);
    }

    public void analyzedSynthetic() {
        this.analyzedSynthetic = true;
    }

    public boolean setInitializer(Expression expression) {
        if (this.constant != null) {
            return this.constant.equals(expression);
        }
        if (this.isSynthetic && (this.fieldName.startsWith("this$") || this.fieldName.startsWith("val$"))) {
            if (this.fieldName.startsWith("val$") && this.fieldName.length() > 4 && expression instanceof OuterLocalOperator) {
                LocalInfo localInfo = ((OuterLocalOperator)expression).getLocalInfo();
                localInfo.addHint(this.fieldName.substring(4), this.type);
            }
            this.analyzedSynthetic();
        } else {
            expression.makeInitializer(this.type);
        }
        this.constant = expression;
        return true;
    }

    public boolean setClassConstant(String string) {
        if (this.constant != null) {
            return false;
        }
        if (string.charAt(0) == '[') {
            if (string.charAt(string.length() - 1) == ';') {
                string = string.substring(0, string.length() - 1);
            }
            if (this.fieldName.equals("array" + string.replace('[', '$').replace('.', '$'))) {
                this.analyzedSynthetic();
                return true;
            }
        } else if (this.fieldName.equals("class$" + string.replace('.', '$')) || this.fieldName.equals("class$L" + string.replace('.', '$'))) {
            this.analyzedSynthetic();
            return true;
        }
        return false;
    }

    public void analyze() {
        this.imports.useType(this.type);
    }

    public void makeDeclaration(Set set) {
        if (this.constant != null) {
            this.constant.makeDeclaration(set);
            this.constant = this.constant.simplify();
        }
    }

    public boolean skipWriting() {
        return this.analyzedSynthetic;
    }

    public void dumpSource(TabbedPrintWriter tabbedPrintWriter) throws IOException {
        if (this.isDeprecated) {
            tabbedPrintWriter.println("/**");
            tabbedPrintWriter.println(" * @deprecated");
            tabbedPrintWriter.println(" */");
        }
        if (this.isSynthetic) {
            tabbedPrintWriter.print("/*synthetic*/ ");
        }
        int n = this.modifiers;
        tabbedPrintWriter.startOp(1, 0);
        String string = Modifier.toString(n);
        if (string.length() > 0) {
            tabbedPrintWriter.print(string + " ");
        }
        tabbedPrintWriter.printType(this.type);
        tabbedPrintWriter.print(" " + this.fieldName);
        if (this.constant != null) {
            tabbedPrintWriter.breakOp();
            tabbedPrintWriter.print(" = ");
            this.constant.dumpExpression(2, tabbedPrintWriter);
        }
        tabbedPrintWriter.endOp();
        tabbedPrintWriter.println(";");
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.clazz.getClazz() + "." + this.getName() + "]";
    }

    public FieldAnalyzer(ClassAnalyzer classAnalyzer, FieldInfo fieldInfo, ImportHandler importHandler) {
        this.clazz = classAnalyzer;
        this.imports = importHandler;
        this.modifiers = fieldInfo.getModifiers();
        this.type = Type.tType(fieldInfo.getType());
        this.fieldName = fieldInfo.getName();
        this.constant = null;
        this.isSynthetic = fieldInfo.isSynthetic();
        this.isDeprecated = fieldInfo.isDeprecated();
        if (fieldInfo.getConstant() != null) {
            this.constant = new ConstOperator(fieldInfo.getConstant());
            this.constant.setType(this.type);
            this.constant.makeInitializer(this.type);
        }
    }
}

