/*
 * Decompiled with CFR 0.152.
 */
package com.cycling74.net;

import com.cycling74.max.Atom;
import com.cycling74.max.MaxSystem;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public class UdpSender {
    private InetAddress iAddress;
    private String address = null;
    private int port = 0;
    private DatagramSocket sendSocket;
    private boolean goodParams = false;
    String objectName = "UdpSender";

    public UdpSender(String address, int port) {
        this.address = address;
        this.port = port;
        this.initSendSocket(address, port);
    }

    public UdpSender() {
    }

    public void setPort(int port) {
        if (port != this.port) {
            this.port = port;
            if (this.address != null) {
                this.initSendSocket(this.address, port);
            }
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setAddress(String address) {
        if (!address.equals(this.address)) {
            this.address = address;
            if (this.port != 0) {
                this.initSendSocket(address, this.port);
            }
        }
    }

    public String getAddress() {
        return this.address;
    }

    private void initSendSocket(String addrarg, int portarg) {
        try {
            this.goodParams = false;
            this.iAddress = InetAddress.getByName(addrarg);
            this.port = portarg;
            this.sendSocket = new DatagramSocket();
            this.goodParams = true;
        }
        catch (UnknownHostException uhe) {
            MaxSystem.error(this.objectName + ": Unknown host: " + addrarg);
        }
        catch (SocketException se) {
            MaxSystem.error(this.objectName + ": Socket exception: " + se);
        }
    }

    private void send(String msg) {
        if (this.goodParams) {
            try {
                byte[] b = msg.getBytes("UTF-8");
                DatagramPacket packet = new DatagramPacket(b, b.length, this.iAddress, this.port);
                this.sendSocket.send(packet);
            }
            catch (IOException ie) {
                MaxSystem.error(this.objectName + ": IOException: " + ie);
            }
        } else {
            MaxSystem.error(this.objectName + "not ready to send.");
        }
    }

    public void send(int i) {
        this.send(new Integer(i).toString());
    }

    public void send(float f) {
        this.send(new Float(f).toString());
    }

    public void send(Atom[] a) {
        this.send(Atom.toOneString(a));
    }

    public void send(String msg, Atom[] a) {
        this.send(msg + " " + Atom.toOneString(a));
    }
}

