/*
 * Decompiled with CFR 0.152.
 */
package jode.expr;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import jode.AssertError;
import jode.GlobalOptions;
import jode.bytecode.BytecodeInfo;
import jode.bytecode.ClassInfo;
import jode.bytecode.InnerClassInfo;
import jode.bytecode.MethodInfo;
import jode.bytecode.Reference;
import jode.bytecode.TypeSignature;
import jode.decompiler.ClassAnalyzer;
import jode.decompiler.MethodAnalyzer;
import jode.decompiler.Options;
import jode.decompiler.OuterValues;
import jode.decompiler.Scope;
import jode.decompiler.TabbedPrintWriter;
import jode.expr.CheckNullOperator;
import jode.expr.ConstOperator;
import jode.expr.ConvertOperator;
import jode.expr.Expression;
import jode.expr.GetFieldOperator;
import jode.expr.MatchableOperator;
import jode.expr.NewOperator;
import jode.expr.Operator;
import jode.expr.PutFieldOperator;
import jode.expr.StoreInstruction;
import jode.expr.StringAddOperator;
import jode.expr.ThisOperator;
import jode.jvm.Interpreter;
import jode.jvm.InterpreterException;
import jode.jvm.SimpleRuntimeEnvironment;
import jode.jvm.SyntheticAnalyzer;
import jode.type.ClassInterfacesType;
import jode.type.IntegerType;
import jode.type.MethodType;
import jode.type.NullType;
import jode.type.Type;
import jode.util.SimpleMap;

public final class InvokeOperator
extends Operator
implements MatchableOperator {
    public static final int VIRTUAL = 0;
    public static final int SPECIAL = 1;
    public static final int STATIC = 2;
    public static final int CONSTRUCTOR = 3;
    public static final int ACCESSSPECIAL = 4;
    private static final Hashtable hintTypes = new Hashtable();
    MethodAnalyzer methodAnalyzer;
    int methodFlag;
    MethodType methodType;
    String methodName;
    Reference ref;
    int skippedArgs;
    Type classType;
    Type[] hints;

    public final boolean isStatic() {
        return this.methodFlag == 2;
    }

    public MethodType getMethodType() {
        return this.methodType;
    }

    public String getMethodName() {
        return this.methodName;
    }

    private static MethodInfo getMethodInfo(ClassInfo classInfo, String string, String string2) {
        while (classInfo != null) {
            MethodInfo methodInfo = classInfo.findMethod(string, string2);
            if (methodInfo != null) {
                return methodInfo;
            }
            classInfo = classInfo.getSuperclass();
        }
        return null;
    }

    public MethodInfo getMethodInfo() {
        ClassInfo classInfo = this.ref.getClazz().charAt(0) == '[' ? ClassInfo.javaLangObject : TypeSignature.getClassInfo(this.ref.getClazz());
        return InvokeOperator.getMethodInfo(classInfo, this.ref.getName(), this.ref.getType());
    }

    public Type getClassType() {
        return this.classType;
    }

    public int getPriority() {
        return 950;
    }

    public void checkAnonymousClasses() {
        if (this.methodFlag != 3 || (Options.options & 4) == 0) {
            return;
        }
        InnerClassInfo innerClassInfo = this.getOuterClassInfo(this.getClassInfo());
        if (innerClassInfo != null && (innerClassInfo.outer == null || innerClassInfo.name == null)) {
            this.methodAnalyzer.addAnonymousConstructor(this);
        }
    }

    public void updateSubTypes() {
        int n = 0;
        if (!this.isStatic()) {
            this.subExpressions[n++].setType(Type.tSubType(this.getClassType()));
        }
        Type[] typeArray = this.methodType.getParameterTypes();
        int n2 = 0;
        while (n2 < typeArray.length) {
            Type type = this.hints != null && this.hints[n2 + 1] != null ? this.hints[n2 + 1] : typeArray[n2];
            this.subExpressions[n++].setType(Type.tSubType(type));
            ++n2;
        }
    }

    public void updateType() {
    }

    public void makeNonVoid() {
        if (this.type != Type.tVoid) {
            throw new AssertError("already non void");
        }
        ClassInfo classInfo = this.getClassInfo();
        InnerClassInfo innerClassInfo = this.getOuterClassInfo(classInfo);
        this.type = innerClassInfo != null && innerClassInfo.name == null ? (classInfo.getInterfaces().length > 0 ? Type.tClass(classInfo.getInterfaces()[0]) : Type.tClass(classInfo.getSuperclass())) : this.subExpressions[0].getType();
    }

    public boolean isConstructor() {
        return this.methodFlag == 3;
    }

    public ClassInfo getClassInfo() {
        if (this.classType instanceof ClassInterfacesType) {
            return ((ClassInterfacesType)this.classType).getClassInfo();
        }
        return null;
    }

    public boolean isThis() {
        return this.getClassInfo() == this.methodAnalyzer.getClazz();
    }

    public InnerClassInfo getOuterClassInfo(ClassInfo classInfo) {
        InnerClassInfo[] innerClassInfoArray;
        if (classInfo != null && (innerClassInfoArray = classInfo.getOuterClasses()) != null) {
            return innerClassInfoArray[0];
        }
        return null;
    }

    public ClassAnalyzer getClassAnalyzer() {
        ClassAnalyzer classAnalyzer;
        if ((Options.options & 6) == 0) {
            return null;
        }
        ClassInfo classInfo = this.getClassInfo();
        if (classInfo == null) {
            return null;
        }
        int n = 0;
        InnerClassInfo[] innerClassInfoArray = classInfo.getOuterClasses();
        if ((Options.options & 2) != 0 && innerClassInfoArray != null) {
            n = innerClassInfoArray.length;
            if (innerClassInfoArray[n - 1].outer == null || innerClassInfoArray[n - 1].name == null) {
                --n;
            }
            if (n > 0) {
                classInfo = ClassInfo.forName(innerClassInfoArray[n - 1].outer);
            }
        }
        if ((classAnalyzer = this.methodAnalyzer.getClassAnalyzer(classInfo)) == null) {
            classAnalyzer = this.methodAnalyzer.getClassAnalyzer();
            while (classInfo != classAnalyzer.getClazz()) {
                if (classAnalyzer.getParent() == null) {
                    return null;
                }
                if (classAnalyzer.getParent() instanceof MethodAnalyzer && (Options.options & 4) != 0) {
                    classAnalyzer = ((MethodAnalyzer)classAnalyzer.getParent()).getClassAnalyzer();
                    continue;
                }
                if (classAnalyzer.getParent() instanceof ClassAnalyzer && (Options.options & 2) != 0) {
                    classAnalyzer = (ClassAnalyzer)classAnalyzer.getParent();
                    continue;
                }
                throw new AssertError("Unknown parent: " + classAnalyzer + ": " + classAnalyzer.getParent());
            }
        }
        while (n > 0) {
            if ((classAnalyzer = classAnalyzer.getInnerClassAnalyzer(innerClassInfoArray[--n].name)) != null) continue;
            return null;
        }
        return classAnalyzer;
    }

    public boolean isOuter() {
        block4: {
            if (this.classType instanceof ClassInterfacesType) {
                ClassInfo classInfo = ((ClassInterfacesType)this.classType).getClassInfo();
                ClassAnalyzer classAnalyzer = this.methodAnalyzer.getClassAnalyzer();
                while (true) {
                    if (classInfo == classAnalyzer.getClazz()) {
                        return true;
                    }
                    if (classAnalyzer.getParent() == null) break block4;
                    if (classAnalyzer.getParent() instanceof MethodAnalyzer && (Options.options & 4) != 0) {
                        classAnalyzer = ((MethodAnalyzer)classAnalyzer.getParent()).getClassAnalyzer();
                        continue;
                    }
                    if (!(classAnalyzer.getParent() instanceof ClassAnalyzer) || (Options.options & 2) == 0) break;
                    classAnalyzer = (ClassAnalyzer)classAnalyzer.getParent();
                }
                throw new AssertError("Unknown parent: " + classAnalyzer + ": " + classAnalyzer.getParent());
            }
        }
        return false;
    }

    public MethodAnalyzer getMethodAnalyzer() {
        ClassAnalyzer classAnalyzer = this.getClassAnalyzer();
        if (classAnalyzer == null) {
            return null;
        }
        return classAnalyzer.getMethod(this.methodName, this.methodType);
    }

    public boolean isSuperOrThis() {
        ClassInfo classInfo = this.getClassInfo();
        if (classInfo != null) {
            return classInfo.superClassOf(this.methodAnalyzer.getClazz());
        }
        return false;
    }

    public boolean isConstant() {
        if ((Options.options & 4) == 0) {
            return super.isConstant();
        }
        ClassInfo classInfo = this.getClassInfo();
        InnerClassInfo innerClassInfo = this.getOuterClassInfo(classInfo);
        ClassAnalyzer classAnalyzer = this.methodAnalyzer.getClassAnalyzer(classInfo);
        if (classAnalyzer != null && innerClassInfo != null && innerClassInfo.outer == null && innerClassInfo.name != null && classAnalyzer.getParent() == this.methodAnalyzer) {
            return false;
        }
        return super.isConstant();
    }

    public boolean matches(Operator operator) {
        return operator instanceof InvokeOperator || operator instanceof GetFieldOperator;
    }

    public boolean isGetClass() {
        MethodAnalyzer methodAnalyzer = this.getMethodAnalyzer();
        if (methodAnalyzer == null) {
            return false;
        }
        SyntheticAnalyzer syntheticAnalyzer = this.getMethodAnalyzer().getSynthetic();
        return syntheticAnalyzer != null && syntheticAnalyzer.getKind() == 1;
    }

    public ConstOperator deobfuscateString(ConstOperator constOperator) {
        String string;
        Interpreter interpreter;
        ClassAnalyzer classAnalyzer = this.methodAnalyzer.getClassAnalyzer();
        MethodAnalyzer methodAnalyzer = classAnalyzer.getMethod(this.methodName, this.methodType);
        if (methodAnalyzer == null) {
            return null;
        }
        InvokeOperator invokeOperator = this;
        if (invokeOperator == null) {
            throw null;
        }
        Environment environment = invokeOperator.new Environment("L" + this.methodAnalyzer.getClazz().getName().replace('.', '/') + ";");
        environment.interpreter = interpreter = new Interpreter(environment);
        try {
            string = (String)interpreter.interpretMethod(methodAnalyzer.getBytecodeInfo(), null, new Object[]{constOperator.getValue()});
        }
        catch (InterpreterException interpreterException) {
            if ((GlobalOptions.debuggingFlags & 0x400) != 0) {
                GlobalOptions.err.println("Warning: Can't interpret method " + this.methodName);
                interpreterException.printStackTrace(GlobalOptions.err);
            }
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            if ((GlobalOptions.debuggingFlags & 0x400) != 0) {
                GlobalOptions.err.println("Warning: Interpreted method throws an uncaught exception: ");
                invocationTargetException.getTargetException().printStackTrace(GlobalOptions.err);
            }
            return null;
        }
        return new ConstOperator(string);
    }

    public Expression simplifyStringBuffer() {
        if (this.getClassType().equals(Type.tStringBuffer)) {
            if (this.isConstructor() && this.subExpressions[0] instanceof NewOperator) {
                if (this.methodType.getParameterTypes().length == 0) {
                    return Expression.EMPTYSTRING;
                }
                if (this.methodType.getParameterTypes().length == 1 && this.methodType.getParameterTypes()[0].equals(Type.tString)) {
                    return this.subExpressions[1].simplifyString();
                }
            }
            if (!this.isStatic() && this.getMethodName().equals("append") && this.getMethodType().getParameterTypes().length == 1) {
                Object object;
                Expression expression;
                Type[] typeArray;
                Expression expression2 = this.subExpressions[0].simplifyStringBuffer();
                if (expression2 == null) {
                    return null;
                }
                this.subExpressions[1] = this.subExpressions[1].simplifyString();
                if (expression2 == Expression.EMPTYSTRING && this.subExpressions[1].getType().isOfType(Type.tString)) {
                    return this.subExpressions[1];
                }
                if (expression2 instanceof StringAddOperator && ((Operator)expression2).getSubExpressions()[0] == Expression.EMPTYSTRING) {
                    expression2 = ((Operator)expression2).getSubExpressions()[1];
                }
                if (this.needsCast(1, typeArray = new Type[]{Type.tStringBuffer, (expression = this.subExpressions[1]).getType().getCanonic()})) {
                    object = this.methodType.getParameterTypes()[0];
                    ConvertOperator convertOperator = new ConvertOperator((Type)object, (Type)object);
                    convertOperator.addOperand(expression);
                    expression = convertOperator;
                }
                object = new StringAddOperator();
                ((Operator)object).addOperand(expression);
                ((Operator)object).addOperand(expression2);
                return object;
            }
        }
        return null;
    }

    public Expression simplifyString() {
        Expression expression;
        if (this.getMethodName().equals("toString") && !this.isStatic() && this.getClassType().equals(Type.tStringBuffer) && this.subExpressions.length == 1) {
            Expression expression2 = this.subExpressions[0].simplifyStringBuffer();
            if (expression2 != null) {
                return expression2;
            }
        } else if (this.getMethodName().equals("valueOf") && this.isStatic() && this.getClassType().equals(Type.tString) && this.subExpressions.length == 1) {
            if (this.subExpressions[0].getType().isOfType(Type.tString)) {
                return this.subExpressions[0];
            }
            StringAddOperator stringAddOperator = new StringAddOperator();
            stringAddOperator.addOperand(this.subExpressions[0]);
            stringAddOperator.addOperand(Expression.EMPTYSTRING);
        } else if (this.getMethodName().equals("concat") && !this.isStatic() && this.getClassType().equals(Type.tString)) {
            StringAddOperator stringAddOperator = new StringAddOperator();
            Expression expression3 = this.subExpressions[1].simplify();
            if (expression3 instanceof StringAddOperator) {
                Operator operator = (Operator)expression3;
                if (operator.subExpressions != null && operator.subExpressions[0] == Expression.EMPTYSTRING) {
                    expression3 = operator.subExpressions[1];
                }
            }
            ((Expression)stringAddOperator).addOperand(expression3);
            ((Expression)stringAddOperator).addOperand(this.subExpressions[0].simplify());
        } else if ((Options.options & 0x20) != 0 && this.isThis() && this.isStatic() && this.methodType.getParameterTypes().length == 1 && this.methodType.getParameterTypes()[0].equals(Type.tString) && this.methodType.getReturnType().equals(Type.tString) && (expression = this.subExpressions[0].simplifyString()) instanceof ConstOperator && (expression = this.deobfuscateString((ConstOperator)expression)) != null) {
            return expression;
        }
        return this;
    }

    public Expression simplifyAccess() {
        SyntheticAnalyzer syntheticAnalyzer;
        if (this.getMethodAnalyzer() != null && (syntheticAnalyzer = this.getMethodAnalyzer().getSynthetic()) != null) {
            int n = syntheticAnalyzer.getUnifyParam();
            Expression expression = null;
            switch (syntheticAnalyzer.getKind()) {
                case 2: {
                    expression = new GetFieldOperator(this.methodAnalyzer, false, syntheticAnalyzer.getReference());
                    break;
                }
                case 5: {
                    expression = new GetFieldOperator(this.methodAnalyzer, true, syntheticAnalyzer.getReference());
                    break;
                }
                case 3: 
                case 9: {
                    expression = new StoreInstruction(new PutFieldOperator(this.methodAnalyzer, false, syntheticAnalyzer.getReference()));
                    if (syntheticAnalyzer.getKind() != 9) break;
                    ((StoreInstruction)expression).makeNonVoid();
                    break;
                }
                case 6: 
                case 10: {
                    expression = new StoreInstruction(new PutFieldOperator(this.methodAnalyzer, true, syntheticAnalyzer.getReference()));
                    if (syntheticAnalyzer.getKind() != 10) break;
                    ((StoreInstruction)expression).makeNonVoid();
                    break;
                }
                case 4: {
                    expression = new InvokeOperator(this.methodAnalyzer, 4, syntheticAnalyzer.getReference());
                    break;
                }
                case 7: {
                    expression = new InvokeOperator(this.methodAnalyzer, 2, syntheticAnalyzer.getReference());
                    break;
                }
                case 8: {
                    if (!(this.subExpressions[n] instanceof ConstOperator) || ((ConstOperator)this.subExpressions[n]).getValue() != null) break;
                    expression = new InvokeOperator(this.methodAnalyzer, 3, syntheticAnalyzer.getReference());
                    break;
                }
            }
            if (expression != null) {
                if (this.subExpressions != null) {
                    int n2 = this.subExpressions.length;
                    while (n2-- > 0) {
                        if (n2 == n && syntheticAnalyzer.getKind() == 8) continue;
                        expression = ((Expression)expression).addOperand(this.subExpressions[n2]);
                        if (this.subExpressions[n2].getFreeOperandCount() > 0) break;
                    }
                }
                return expression;
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public boolean needsCast(int var1_1, Type[] var2_2) {
        if (this.methodFlag == 2) {
            var3_3 = this.classType;
        } else {
            if (var1_1 == 0) {
                if (var2_2[0] instanceof NullType) {
                    return true;
                }
                if (!(var2_2[0] instanceof ClassInterfacesType) || !(this.classType instanceof ClassInterfacesType)) {
                    return false;
                }
                var4_4 = ((ClassInterfacesType)this.classType).getClassInfo();
                var5_6 = ((ClassInterfacesType)var2_2[0]).getClassInfo();
                var6_8 = this.getMethodInfo();
                if (var6_8 == null) {
                    return false;
                }
                if (Modifier.isPrivate(var6_8.getModifiers())) {
                    return var5_6 != var4_4;
                }
                return (var6_8.getModifiers() & 5) == 0 && ((var7_10 = var4_4.getName().lastIndexOf(46)) != var5_6.getName().lastIndexOf(46) || var5_6.getName().startsWith(var4_4.getName().substring(0, var7_10 + 1)) == false);
            }
            var3_3 = var2_2[0];
        }
        if (!(var3_3 instanceof ClassInterfacesType)) {
            return false;
        }
        var4_5 = ((ClassInterfacesType)var3_3).getClassInfo();
        var5_7 = this.skippedArgs;
        var6_9 = this.methodType.getParameterTypes();
        if (!var6_9[var1_1 - var5_7].equals(var2_2[var1_1])) ** GOTO lbl40
        return false;
lbl-1000:
        // 1 sources

        {
            var7_11 = var4_5.getMethods();
            var8_12 = 0;
            while (var8_12 < var7_11.length) {
                block13: {
                    if (var7_11[var8_12].getName().equals(this.methodName) && (var9_13 = Type.tMethod(var7_11[var8_12].getType()).getParameterTypes()).length == var6_9.length && !var6_9[var1_1 - var5_7].isOfType(Type.tSubType(var9_13[var1_1 - var5_7]))) {
                        var10_14 = var5_7;
                        while (var10_14 < var2_2.length) {
                            if (var2_2[var10_14].isOfType(Type.tSubType(var9_13[var10_14 - var5_7]))) {
                                ++var10_14;
                                continue;
                            }
                            break block13;
                        }
                        return true;
                    }
                }
                ++var8_12;
            }
            var4_5 = var4_5.getSuperclass();
lbl40:
            // 2 sources

            ** while (var4_5 != null)
        }
lbl41:
        // 1 sources

        return false;
    }

    public Expression simplify() {
        Expression expression = this.simplifyAccess();
        if (expression != null) {
            return expression.simplify();
        }
        expression = this.simplifyString();
        if (expression != this) {
            return expression.simplify();
        }
        return super.simplify();
    }

    public void fillDeclarables(Collection collection) {
        Object object;
        ClassInfo classInfo = this.getClassInfo();
        InnerClassInfo innerClassInfo = this.getOuterClassInfo(classInfo);
        ClassAnalyzer classAnalyzer = this.methodAnalyzer.getClassAnalyzer(classInfo);
        if ((Options.options & 4) != 0 && innerClassInfo != null && innerClassInfo.outer == null && innerClassInfo.name != null && classAnalyzer != null && classAnalyzer.getParent() == this.methodAnalyzer) {
            classAnalyzer.fillDeclarables(collection);
            collection.add(classAnalyzer);
        }
        if (!this.isConstructor() || this.isStatic()) {
            super.fillDeclarables(collection);
            return;
        }
        int n = 1;
        int n2 = this.subExpressions.length;
        boolean bl = false;
        boolean bl2 = false;
        if ((Options.options & 4) != 0 && classAnalyzer != null && innerClassInfo != null && (innerClassInfo.outer == null || innerClassInfo.name == null)) {
            Object object2;
            object = classAnalyzer.getOuterValues();
            n += ((OuterValues)object).getCount();
            bl = ((OuterValues)object).isJikesAnonymousInner();
            bl2 = ((OuterValues)object).isImplicitOuterClass();
            int n3 = 1;
            while (n3 < n) {
                object2 = this.subExpressions[n3];
                if (object2 instanceof CheckNullOperator) {
                    CheckNullOperator checkNullOperator = (CheckNullOperator)object2;
                    object2 = checkNullOperator.subExpressions[0];
                }
                object2.fillDeclarables(collection);
                ++n3;
            }
            if (innerClassInfo.name == null) {
                ClassInfo classInfo2 = classInfo.getSuperclass();
                object2 = classInfo.getInterfaces();
                classInfo = ((ClassInfo[])object2).length == 1 && (classInfo2 == null || classInfo2 == ClassInfo.javaLangObject) ? object2[0] : (classInfo2 != null ? classInfo2 : ClassInfo.javaLangObject);
                innerClassInfo = this.getOuterClassInfo(classInfo);
            }
        }
        if ((Options.options & 2) != 0 && innerClassInfo != null && innerClassInfo.outer != null && innerClassInfo.name != null && !Modifier.isStatic(innerClassInfo.modifiers) && !bl2 && n < n2) {
            Object object3 = object = bl ? this.subExpressions[--n2] : this.subExpressions[n++];
            if (object instanceof CheckNullOperator) {
                CheckNullOperator checkNullOperator = (CheckNullOperator)object;
                object = checkNullOperator.subExpressions[0];
            }
            ((Expression)object).fillDeclarables(collection);
        }
        int n4 = n;
        while (n4 < n2) {
            this.subExpressions[n4].fillDeclarables(collection);
            ++n4;
        }
    }

    public void makeDeclaration(Set set) {
        super.makeDeclaration(set);
        if (this.isConstructor() && !this.isStatic() && (Options.options & 4) != 0) {
            ClassInfo classInfo = this.getClassInfo();
            InnerClassInfo innerClassInfo = this.getOuterClassInfo(classInfo);
            ClassAnalyzer classAnalyzer = this.methodAnalyzer.getClassAnalyzer(classInfo);
            if (classAnalyzer != null && innerClassInfo != null && innerClassInfo.name == null) {
                classAnalyzer.makeDeclaration(set);
            }
        }
    }

    public int getBreakPenalty() {
        return 5;
    }

    public void dumpExpression(TabbedPrintWriter tabbedPrintWriter) throws IOException {
        Object object;
        int n;
        int n2 = 1;
        int n3 = this.subExpressions.length;
        boolean bl = false;
        Object object2 = this.getClassInfo();
        ClassAnalyzer classAnalyzer = null;
        Type[] typeArray = new Type[this.subExpressions.length];
        int n4 = 0;
        while (n4 < this.subExpressions.length) {
            typeArray[n4] = this.subExpressions[n4].getType().getCanonic();
            ++n4;
        }
        tabbedPrintWriter.startOp(1, 0);
        switch (this.methodFlag) {
            case 3: {
                Object object3;
                Object object4;
                n4 = 0;
                boolean bl2 = false;
                n = 0;
                object = this.getOuterClassInfo((ClassInfo)object2);
                if (object != null && ((InnerClassInfo)object).name == null && (Options.options & 4) != 0) {
                    bl = true;
                }
                classAnalyzer = this.methodAnalyzer.getClassAnalyzer((ClassInfo)object2);
                if ((~Options.options & 0x204) == 0 && classAnalyzer != null && object != null && (((InnerClassInfo)object).outer == null || ((InnerClassInfo)object).name == null)) {
                    object4 = classAnalyzer.getOuterValues();
                    n2 += ((OuterValues)object4).getCount();
                    bl2 = ((OuterValues)object4).isJikesAnonymousInner();
                    n = ((OuterValues)object4).isImplicitOuterClass() ? 1 : 0;
                    if (((InnerClassInfo)object).name == null) {
                        object3 = ((ClassInfo)object2).getSuperclass();
                        ClassInfo[] classInfoArray = ((ClassInfo)object2).getInterfaces();
                        if (classInfoArray.length == 1 && (object3 == null || object3 == ClassInfo.javaLangObject)) {
                            object2 = classInfoArray[0];
                        } else {
                            if (classInfoArray.length > 0) {
                                tabbedPrintWriter.print("too many supers in ANONYMOUS ");
                            }
                            object2 = object3 != null ? object3 : ClassInfo.javaLangObject;
                        }
                        object = this.getOuterClassInfo((ClassInfo)object2);
                        if (bl2 && object != null && ((InnerClassInfo)object).outer == null && ((InnerClassInfo)object).name != null) {
                            Expression expression;
                            if ((expression = this.subExpressions[--n3]) instanceof CheckNullOperator) {
                                CheckNullOperator checkNullOperator = (CheckNullOperator)expression;
                                expression = checkNullOperator.subExpressions[0];
                            }
                            if (!(expression instanceof ThisOperator) || ((ThisOperator)expression).getClassInfo() != this.methodAnalyzer.getClazz()) {
                                tabbedPrintWriter.print("ILLEGAL ANON CONSTR");
                            }
                        }
                    }
                }
                if (object != null && ((InnerClassInfo)object).outer != null && ((InnerClassInfo)object).name != null && !Modifier.isStatic(((InnerClassInfo)object).modifiers) && (~Options.options & 0x202) == 0 && n == 0) {
                    if (n2 < n3) {
                        Object object5 = object4 = bl2 ? this.subExpressions[--n3] : this.subExpressions[n2++];
                        if (object4 instanceof CheckNullOperator) {
                            object3 = (CheckNullOperator)object4;
                            object4 = ((Operator)object3).subExpressions[0];
                        }
                        if (object4 instanceof ThisOperator) {
                            object3 = tabbedPrintWriter.getScope(((ThisOperator)object4).getClassInfo(), 1);
                            if (tabbedPrintWriter.conflicts(((InnerClassInfo)object).name, (Scope)object3, 1)) {
                                n4 = 1;
                                ((Expression)object4).dumpExpression(tabbedPrintWriter, 950);
                                tabbedPrintWriter.breakOp();
                                tabbedPrintWriter.print(".");
                            }
                        } else {
                            n4 = 1;
                            if (((Expression)object4).getType().getCanonic() instanceof NullType) {
                                tabbedPrintWriter.print("(");
                                tabbedPrintWriter.startOp(0, 1);
                                tabbedPrintWriter.print("(");
                                tabbedPrintWriter.printType(Type.tClass(ClassInfo.forName(((InnerClassInfo)object).outer)));
                                tabbedPrintWriter.print(") ");
                                tabbedPrintWriter.breakOp();
                                ((Expression)object4).dumpExpression(tabbedPrintWriter, 700);
                                tabbedPrintWriter.endOp();
                                tabbedPrintWriter.print(")");
                            } else {
                                ((Expression)object4).dumpExpression(tabbedPrintWriter, 950);
                            }
                            tabbedPrintWriter.breakOp();
                            tabbedPrintWriter.print(".");
                        }
                    } else {
                        tabbedPrintWriter.print("MISSING OUTEREXPR ");
                    }
                }
                if (this.subExpressions[0] instanceof NewOperator && typeArray[0].equals(this.classType)) {
                    tabbedPrintWriter.print("new ");
                    if (n4 != 0) {
                        tabbedPrintWriter.print(((InnerClassInfo)object).name);
                        break;
                    }
                    tabbedPrintWriter.printType(Type.tClass((ClassInfo)object2));
                    break;
                }
                if (this.subExpressions[0] instanceof ThisOperator && ((ThisOperator)this.subExpressions[0]).getClassInfo() == this.methodAnalyzer.getClazz()) {
                    if (this.isThis()) {
                        tabbedPrintWriter.print("this");
                        break;
                    }
                    tabbedPrintWriter.print("super");
                    break;
                }
                tabbedPrintWriter.print("(");
                tabbedPrintWriter.startOp(0, 0);
                tabbedPrintWriter.print("(UNCONSTRUCTED)");
                tabbedPrintWriter.breakOp();
                this.subExpressions[0].dumpExpression(tabbedPrintWriter, 700);
                tabbedPrintWriter.endOp();
                tabbedPrintWriter.print(")");
                tabbedPrintWriter.breakOp();
                tabbedPrintWriter.print(".");
                tabbedPrintWriter.printType(Type.tClass((ClassInfo)object2));
                break;
            }
            case 1: {
                if (this.isSuperOrThis() && this.subExpressions[0] instanceof ThisOperator && ((ThisOperator)this.subExpressions[0]).getClassInfo() == this.methodAnalyzer.getClazz()) {
                    if (!this.isThis()) {
                        tabbedPrintWriter.print("super");
                        ClassInfo classInfo = this.getClassInfo().getSuperclass();
                        typeArray[0] = classInfo == null ? Type.tObject : Type.tClass(classInfo);
                        tabbedPrintWriter.breakOp();
                        tabbedPrintWriter.print(".");
                    }
                } else if (this.isThis()) {
                    if (this.needsCast(0, typeArray)) {
                        tabbedPrintWriter.print("(");
                        tabbedPrintWriter.startOp(0, 1);
                        tabbedPrintWriter.print("(");
                        tabbedPrintWriter.printType(this.classType);
                        tabbedPrintWriter.print(") ");
                        tabbedPrintWriter.breakOp();
                        this.subExpressions[0].dumpExpression(tabbedPrintWriter, 700);
                        tabbedPrintWriter.endOp();
                        tabbedPrintWriter.print(")");
                        typeArray[0] = this.classType;
                    } else {
                        this.subExpressions[0].dumpExpression(tabbedPrintWriter, 950);
                    }
                    tabbedPrintWriter.breakOp();
                    tabbedPrintWriter.print(".");
                } else {
                    tabbedPrintWriter.print("(");
                    tabbedPrintWriter.startOp(0, 0);
                    tabbedPrintWriter.print("(NON VIRTUAL ");
                    tabbedPrintWriter.printType(this.classType);
                    tabbedPrintWriter.print(") ");
                    tabbedPrintWriter.breakOp();
                    this.subExpressions[0].dumpExpression(tabbedPrintWriter, 700);
                    tabbedPrintWriter.endOp();
                    tabbedPrintWriter.print(")");
                    tabbedPrintWriter.breakOp();
                    tabbedPrintWriter.print(".");
                }
                tabbedPrintWriter.print(this.methodName);
                break;
            }
            case 4: {
                if (typeArray[0].equals(this.classType)) {
                    this.subExpressions[0].dumpExpression(tabbedPrintWriter, 950);
                } else {
                    tabbedPrintWriter.print("(");
                    tabbedPrintWriter.startOp(0, 0);
                    tabbedPrintWriter.print("(");
                    tabbedPrintWriter.printType(this.classType);
                    tabbedPrintWriter.print(") ");
                    tabbedPrintWriter.breakOp();
                    typeArray[0] = this.classType;
                    this.subExpressions[0].dumpExpression(tabbedPrintWriter, 700);
                    tabbedPrintWriter.endOp();
                    tabbedPrintWriter.print(")");
                }
                tabbedPrintWriter.breakOp();
                tabbedPrintWriter.print(".");
                tabbedPrintWriter.print(this.methodName);
                break;
            }
            case 2: {
                n2 = 0;
                Scope scope = tabbedPrintWriter.getScope(this.getClassInfo(), 1);
                if (scope == null || tabbedPrintWriter.conflicts(this.methodName, scope, 2)) {
                    tabbedPrintWriter.printType(this.classType);
                    tabbedPrintWriter.breakOp();
                    tabbedPrintWriter.print(".");
                }
                tabbedPrintWriter.print(this.methodName);
                break;
            }
            case 0: {
                if (this.subExpressions[0] instanceof ThisOperator) {
                    ThisOperator thisOperator = (ThisOperator)this.subExpressions[0];
                    Scope scope = tabbedPrintWriter.getScope(thisOperator.getClassInfo(), 1);
                    if (tabbedPrintWriter.conflicts(this.methodName, scope, 2) || this.getMethodAnalyzer() == null && (!this.isThis() || tabbedPrintWriter.conflicts(this.methodName, null, 12))) {
                        thisOperator.dumpExpression(tabbedPrintWriter, 950);
                        tabbedPrintWriter.breakOp();
                        tabbedPrintWriter.print(".");
                    }
                } else {
                    if (this.needsCast(0, typeArray)) {
                        tabbedPrintWriter.print("(");
                        tabbedPrintWriter.startOp(0, 1);
                        tabbedPrintWriter.print("(");
                        tabbedPrintWriter.printType(this.classType);
                        tabbedPrintWriter.print(") ");
                        tabbedPrintWriter.breakOp();
                        this.subExpressions[0].dumpExpression(tabbedPrintWriter, 700);
                        tabbedPrintWriter.endOp();
                        tabbedPrintWriter.print(")");
                        typeArray[0] = this.classType;
                    } else {
                        this.subExpressions[0].dumpExpression(tabbedPrintWriter, 950);
                    }
                    tabbedPrintWriter.breakOp();
                    tabbedPrintWriter.print(".");
                }
                tabbedPrintWriter.print(this.methodName);
            }
        }
        tabbedPrintWriter.endOp();
        tabbedPrintWriter.breakOp();
        if ((Options.outputStyle & 0x40) != 0) {
            tabbedPrintWriter.print(" ");
        }
        tabbedPrintWriter.print("(");
        tabbedPrintWriter.startOp(0, 0);
        boolean bl3 = true;
        int n5 = this.skippedArgs;
        while (n2 < n3) {
            if (!bl3) {
                tabbedPrintWriter.print(", ");
                tabbedPrintWriter.breakOp();
            } else {
                bl3 = false;
            }
            n = 0;
            if (this.needsCast(n2, typeArray)) {
                object = this.methodType.getParameterTypes()[n2 - n5];
                tabbedPrintWriter.startOp(2, 1);
                tabbedPrintWriter.print("(");
                tabbedPrintWriter.printType((Type)object);
                tabbedPrintWriter.print(") ");
                tabbedPrintWriter.breakOp();
                typeArray[n2] = object;
                n = 700;
            }
            this.subExpressions[n2++].dumpExpression(tabbedPrintWriter, n);
            if (n != 700) continue;
            tabbedPrintWriter.endOp();
        }
        tabbedPrintWriter.endOp();
        tabbedPrintWriter.print(")");
        if (bl) {
            Object object6 = tabbedPrintWriter.saveOps();
            tabbedPrintWriter.openBraceClass();
            tabbedPrintWriter.tab();
            classAnalyzer.dumpBlock(tabbedPrintWriter);
            tabbedPrintWriter.untab();
            tabbedPrintWriter.closeBraceClass();
            tabbedPrintWriter.restoreOps(object6);
        }
    }

    public boolean opEquals(Operator operator) {
        if (operator instanceof InvokeOperator) {
            InvokeOperator invokeOperator = (InvokeOperator)operator;
            return this.classType.equals(invokeOperator.classType) && this.methodName.equals(invokeOperator.methodName) && this.methodType.equals(invokeOperator.methodType) && this.methodFlag == invokeOperator.methodFlag;
        }
        return false;
    }

    public InvokeOperator(MethodAnalyzer methodAnalyzer, int n, Reference reference) {
        super(Type.tUnknown, 0);
        this.ref = reference;
        this.methodType = Type.tMethod(reference.getType());
        this.methodName = reference.getName();
        this.classType = Type.tType(reference.getClazz());
        this.hints = null;
        Map map = (Map)hintTypes.get(this.methodName + "." + this.methodType);
        if (map != null) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!this.classType.isOfType(((Type)entry.getKey()).getSubType())) continue;
                this.hints = (Type[])entry.getValue();
                break;
            }
        }
        this.type = this.hints != null && this.hints[0] != null ? this.hints[0] : this.methodType.getReturnType();
        this.methodAnalyzer = methodAnalyzer;
        this.methodFlag = n;
        if (n == 2) {
            methodAnalyzer.useType(this.classType);
        }
        this.skippedArgs = n == 2 ? 0 : 1;
        this.initOperands(this.skippedArgs + this.methodType.getParameterTypes().length);
        this.checkAnonymousClasses();
    }

    static {
        IntegerType integerType = new IntegerType(2, 4);
        Type[] typeArray = new Type[]{integerType};
        Type[] typeArray2 = new Type[]{null, integerType};
        Type[] typeArray3 = new Type[]{null, integerType, null};
        SimpleMap simpleMap = new SimpleMap(Collections.singleton(new SimpleMap.SimpleEntry(Type.tString, typeArray2)));
        SimpleMap simpleMap2 = new SimpleMap(Collections.singleton(new SimpleMap.SimpleEntry(Type.tString, typeArray3)));
        hintTypes.put("indexOf.(I)I", simpleMap);
        hintTypes.put("lastIndexOf.(I)I", simpleMap);
        hintTypes.put("indexOf.(II)I", simpleMap2);
        hintTypes.put("lastIndexOf.(II)I", simpleMap2);
        hintTypes.put("write.(I)V", new SimpleMap(Collections.singleton(new SimpleMap.SimpleEntry(Type.tClass("java.io.Writer"), typeArray2))));
        hintTypes.put("read.()I", new SimpleMap(Collections.singleton(new SimpleMap.SimpleEntry(Type.tClass("java.io.Reader"), typeArray))));
        hintTypes.put("unread.(I)V", new SimpleMap(Collections.singleton(new SimpleMap.SimpleEntry(Type.tClass("java.io.PushbackReader"), typeArray2))));
    }

    class Environment
    extends SimpleRuntimeEnvironment {
        Interpreter interpreter;
        String classSig;

        public Object invokeMethod(Reference reference, boolean bl, Object object, Object[] objectArray) throws InterpreterException, InvocationTargetException {
            if (object == null && reference.getClazz().equals(this.classSig)) {
                String string = reference.getClazz();
                BytecodeInfo bytecodeInfo = ClassInfo.forName(string = string.substring(1, reference.getClazz().length() - 1).replace('/', '.')).findMethod(reference.getName(), reference.getType()).getBytecode();
                if (bytecodeInfo != null) {
                    return this.interpreter.interpretMethod(bytecodeInfo, null, objectArray);
                }
                throw new InterpreterException("Can't interpret static native method: " + reference);
            }
            return super.invokeMethod(reference, bl, object, objectArray);
        }

        public Environment(String string) {
            this.classSig = string.intern();
        }
    }
}

