/*
 * Decompiled with CFR 0.152.
 */
package jode.decompiler;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import jode.GlobalOptions;
import jode.bytecode.ClassInfo;
import jode.bytecode.SearchPath;
import jode.decompiler.ClassAnalyzer;
import jode.decompiler.ImportHandler;
import jode.decompiler.Options;
import jode.decompiler.ProgressListener;
import jode.decompiler.TabbedPrintWriter;

public class Decompiler {
    public static final char altPathSeparatorChar = ',';
    private static final String[] optionStrings = new String[]{"lvt", "inner", "anonymous", "push", "pretty", "decrypt", "onetime", "immediate", "verify", "contrafo"};
    private SearchPath searchPath = null;
    private int importPackageLimit = Integer.MAX_VALUE;
    private int importClassLimit = 1;

    public void setClassPath(String string) {
        this.searchPath = new SearchPath(string);
    }

    public void setClassPath(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
        int n = 1;
        while (n < stringArray.length) {
            stringBuffer.append(',').append(stringArray[n]);
            ++n;
        }
        this.searchPath = new SearchPath(stringBuffer.toString());
    }

    public void setOption(String string, String string2) {
        if (string.equals("style")) {
            if (string2.equals("gnu")) {
                Options.outputStyle = 66;
            } else if (string2.equals("sun")) {
                Options.outputStyle = 20;
            } else if (string2.equals("pascal")) {
                Options.outputStyle = 36;
            } else {
                throw new IllegalArgumentException("Invalid style " + string2);
            }
            return;
        }
        if (string.equals("import")) {
            int n;
            int n2 = string2.indexOf(44);
            int n3 = Integer.parseInt(string2.substring(0, n2));
            if (n3 == 0) {
                n3 = Integer.MAX_VALUE;
            }
            if ((n = Integer.parseInt(string2.substring(n2 + 1))) == 0) {
                n = Integer.MAX_VALUE;
            }
            if (n < 0 || n3 < 0) {
                throw new IllegalArgumentException("Option import doesn't allow negative parameters");
            }
            this.importPackageLimit = n3;
            this.importClassLimit = n;
            return;
        }
        if (string.equals("verbose")) {
            GlobalOptions.verboseLevel = Integer.parseInt(string2);
            return;
        }
        int n = 0;
        while (n < optionStrings.length) {
            if (string.equals(optionStrings[n])) {
                if (string2.equals("0") || string2.equals("off") || string2.equals("no")) {
                    Options.options &= ~(1 << n);
                } else if (string2.equals("1") || string2.equals("on") || string2.equals("yes")) {
                    Options.options |= 1 << n;
                } else {
                    throw new IllegalArgumentException("Illegal value for " + string);
                }
                return;
            }
            ++n;
        }
        throw new IllegalArgumentException("Illegal option: " + string);
    }

    public void setErr(PrintWriter printWriter) {
        GlobalOptions.err = printWriter;
    }

    public void decompile(String string, Writer writer, ProgressListener progressListener) throws IOException {
        Object object;
        if (this.searchPath == null) {
            object = System.getProperty("java.class.path").replace(File.pathSeparatorChar, ',');
            this.searchPath = new SearchPath((String)object);
        }
        ClassInfo.setClassPath(this.searchPath);
        object = ClassInfo.forName(string);
        ImportHandler importHandler = new ImportHandler(this.importPackageLimit, this.importClassLimit);
        TabbedPrintWriter tabbedPrintWriter = new TabbedPrintWriter(writer, importHandler, false);
        ClassAnalyzer classAnalyzer = new ClassAnalyzer(null, (ClassInfo)object, importHandler);
        classAnalyzer.dumpJavaFile(tabbedPrintWriter, progressListener);
        writer.flush();
    }
}

