/*
 * Decompiled with CFR 0.152.
 */
package com.cycling74.max;

import com.cycling74.io.ErrorStream;
import com.cycling74.io.PostStream;
import com.cycling74.max.Atom;
import com.cycling74.max.AttributeInfo;
import com.cycling74.max.DataTypes;
import com.cycling74.max.MXJClassLoader;
import com.cycling74.max.MXJDecompiler;
import com.cycling74.max.MaxBox;
import com.cycling74.max.MaxContext;
import com.cycling74.max.MaxPatcher;
import com.cycling74.max.MaxRuntimeException;
import com.cycling74.max.MaxSystem;
import com.cycling74.mxjedit.MXJEditor;
import com.cycling74.util.ArrayUtilities;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.SwingUtilities;

public abstract class MaxObject {
    private static final String HELPMESSAGE = "help!";
    private static final Class ATOM_ARRAY_CLASS = new Atom[0].getClass();
    private static final Class BOOL_ARRAY_CLASS = new boolean[0].getClass();
    private static final Class BYTE_ARRAY_CLASS = new byte[0].getClass();
    private static final Class CHAR_ARRAY_CLASS = new char[0].getClass();
    private static final Class SHORT_ARRAY_CLASS = new short[0].getClass();
    private static final Class INT_ARRAY_CLASS = new int[0].getClass();
    private static final Class LONG_ARRAY_CLASS = new long[0].getClass();
    private static final Class FLOAT_ARRAY_CLASS = new float[0].getClass();
    private static final Class DOUBLE_ARRAY_CLASS = new double[0].getClass();
    private static final Class STRING_ARRAY_CLASS = new String[0].getClass();
    private static final Class OBJECT_ARRAY_CLASS = new Object[0].getClass();
    private static final Class[] GIMME_PARAM_TYPE = new Class[]{ATOM_ARRAY_CLASS};
    private static final Class[] ANYTHING_PARAM_TYPES = new Class[]{new String().getClass(), ATOM_ARRAY_CLASS};
    private static final String ANYTHING_METHOD_NAME = "anything";
    private static final String GIMME_STRING = "__GIMME__";
    private static final Class STRING_CLASS = new String().getClass();
    private static final PostStream sPostStream = PostStream.getPostStream();
    private static final ErrorStream sErrorStream = ErrorStream.getErrorStream();
    private MXJEditor _source_editor = null;
    private Object _flash_watch = null;
    private Object WATCHME = new Object();
    public static final int[] NO_INLETS;
    public static final int[] NO_OUTLETS;
    public static final String[] EMPTY_STRING_ARRAY;
    private long mPeer = 0L;
    private String mName = null;
    private int[] mInlets = NO_INLETS;
    private int[] mOutlets = NO_OUTLETS;
    private String[] mInletAssist = EMPTY_STRING_ARRAY;
    private String[] mOutletAssist = EMPTY_STRING_ARRAY;
    private boolean mCreateInfoOutlet = true;
    private Vector _attributes = new Vector();
    private MaxPatcher _parent_patcher = null;
    private MaxBox _max_box = null;
    private boolean defaultInt = true;
    private boolean defaultFloat = true;
    private boolean defaultAtomList = true;
    private boolean defaultFloatList = true;
    private boolean defaultIntList = true;
    private boolean defaultAnything = true;
    private Object[] s_meth_desc = null;
    private Object[] s_const_desc = null;
    private HashMap _j_attribute_table = new HashMap(16);

    protected MaxObject() {
        this.setName(this.getClass().getName());
        MaxContext.register(this);
        this.determineIfInletMethodsExist();
        this.declareIO(1, 1);
    }

    private void mxjObjectWasDeleted() {
        MaxContext.unregister(this);
        this.notifyDeleted();
        this.mName = null;
        this.mInlets = null;
        this.mOutlets = null;
        this.mInletAssist = null;
        this.mOutletAssist = null;
        this._attributes = null;
        this._flash_watch = null;
        this.WATCHME = null;
        this._source_editor = null;
    }

    protected void notifyDeleted() {
    }

    public void setName(String name) {
        this.mName = name;
    }

    public String getName() {
        return this.mName;
    }

    public static MaxContext getContext() {
        return MaxContext.getSingleton();
    }

    public static void post(String message) {
        MaxSystem.post(message);
    }

    public static void error(String message) {
        MaxSystem.error(message);
    }

    public static void ouch(String message) {
        MaxSystem.ouch(message);
    }

    public static PostStream getPostStream() {
        return sPostStream;
    }

    public static void showException(Throwable t) {
        MaxObject.showException(null, t);
    }

    public static void showException(String message, Throwable t) {
        PostStream ps = MaxObject.getPostStream();
        if (message != null) {
            ps.println(message);
        }
        t.printStackTrace(ps);
        ps.flush();
    }

    public static ErrorStream getErrorStream() {
        return sErrorStream;
    }

    private static final native void doPost(byte[] var0);

    private static final native void doError(byte[] var0);

    private static final native void doOuch(byte[] var0);

    private final native long _get_parent_patcher();

    private final native long _get_max_box();

    public MaxPatcher getParentPatcher() {
        if (this._parent_patcher == null) {
            this._parent_patcher = new MaxPatcher(this._get_parent_patcher());
        }
        return this._parent_patcher;
    }

    public MaxBox getMaxBox() {
        if (this._max_box == null) {
            this._max_box = new MaxBox(this.getParentPatcher(), this._get_max_box());
        }
        return this._max_box;
    }

    protected void declareInlets(int[] types) {
        this.mInlets = ArrayUtilities.arrayCopy(types);
    }

    protected void declareOutlets(int[] types) {
        this.mOutlets = ArrayUtilities.arrayCopy(types);
    }

    protected void declareIO(int ins, int outs) {
        int i;
        int[] temp = new int[ins];
        for (i = 0; i < ins; ++i) {
            temp[i] = 15;
        }
        this.mInlets = ArrayUtilities.arrayCopy(temp);
        temp = new int[outs];
        for (i = 0; i < outs; ++i) {
            temp[i] = 15;
        }
        this.mOutlets = ArrayUtilities.arrayCopy(temp);
    }

    protected void declareTypedIO(String ins, String outs) {
        int i;
        int[] temp = new int[ins.length()];
        for (i = 0; i < ins.length(); ++i) {
            temp[i] = this.convertCharToType(ins.charAt(i));
        }
        this.mInlets = ArrayUtilities.arrayCopy(temp);
        temp = new int[outs.length()];
        for (i = 0; i < outs.length(); ++i) {
            temp[i] = this.convertCharToType(outs.charAt(i));
        }
        this.mOutlets = ArrayUtilities.arrayCopy(temp);
    }

    private int convertCharToType(char c) {
        int i = 15;
        switch (c) {
            case 'F': 
            case 'f': {
                i = 2;
                break;
            }
            case 'I': 
            case 'i': {
                i = 1;
                break;
            }
            case 'M': 
            case 'm': {
                i = 8;
                break;
            }
            case 'L': 
            case 'l': {
                i = 4;
            }
        }
        return i;
    }

    protected void setInletAssist(String[] messages) {
        this.mInletAssist = messages;
    }

    protected void setInletAssist(int index, String message) {
        if (this.mInletAssist.length < index + 1) {
            String[] temp = new String[index + 1];
            System.arraycopy(this.mInletAssist, 0, temp, 0, this.mInletAssist.length);
            temp[index] = message;
            this.mInletAssist = temp;
        } else {
            this.mInletAssist[index] = message;
        }
    }

    protected void setOutletAssist(String[] messages) {
        this.mOutletAssist = messages;
    }

    protected void setOutletAssist(int index, String message) {
        if (this.mOutletAssist.length < index + 1) {
            String[] temp = new String[index + 1];
            System.arraycopy(this.mOutletAssist, 0, temp, 0, this.mOutletAssist.length);
            temp[index] = message;
            this.mOutletAssist = temp;
        } else {
            this.mOutletAssist[index] = message;
        }
    }

    private int[] getOutlets() {
        return this.mOutlets;
    }

    private int[] getInlets() {
        return this.mInlets;
    }

    protected void createInfoOutlet(boolean b) {
        this.mCreateInfoOutlet = b;
    }

    public int getInfoIdx() {
        if (this.mCreateInfoOutlet) {
            return this.mOutlets.length;
        }
        return -1;
    }

    public int getNumInlets() {
        return this.mInlets.length;
    }

    public int getInletType(int idx) {
        return this.mInlets[idx];
    }

    public int getNumOutlets() {
        return this.mOutlets.length;
    }

    public int getOutletType(int idx) {
        return this.mOutlets[idx];
    }

    public String getInletAssist(int inletIdx) {
        if (inletIdx < this.mInletAssist.length) {
            return this.mInletAssist[inletIdx];
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append(" inlet ");
        sb.append(inletIdx);
        sb.append(": type is ");
        if (inletIdx > this.getNumInlets()) {
            sb.append("OUT OF RANGE");
        } else {
            sb.append(DataTypes.toString(this.getInletType(inletIdx)));
        }
        return sb.toString();
    }

    private void determineIfInletMethodsExist() {
        Method[] m = this.getAllMethodsButMaxObject(this);
        for (int i = 0; i < m.length; ++i) {
            String cname;
            Class<?>[] c;
            String name = m[i].getName();
            if (name.equals("inlet")) {
                c = m[i].getParameterTypes();
                if (c.length != 1) continue;
                cname = c[0].getName();
                if (cname.equals("int")) {
                    this.defaultInt = false;
                    continue;
                }
                if (!cname.equals("float")) continue;
                this.defaultFloat = false;
                continue;
            }
            if (name.equals("list")) {
                c = m[i].getParameterTypes();
                if (c.length == 1) {
                    cname = c[0].getName();
                    if (cname.equals("[F")) {
                        this.defaultFloatList = false;
                    } else if (cname.equals("[I")) {
                        this.defaultIntList = false;
                    } else if (cname.equals("[Lcom.cycling74.max.Atom;")) {
                        this.defaultAtomList = false;
                    }
                }
                this.defaultAtomList = false;
                continue;
            }
            if (!name.equals(ANYTHING_METHOD_NAME)) continue;
            this.defaultAnything = false;
        }
    }

    protected void bang() {
        MaxObject.post(this.getClass().getName() + " doesn't understand bang");
    }

    protected void inlet(int value) {
        if (!this.defaultFloat) {
            this.inlet((float)value);
            return;
        }
        if (!this.defaultAtomList) {
            this.list(new Atom[]{Atom.newAtom(value)});
            return;
        }
        this.anything("int", new Atom[]{Atom.newAtom(value)});
    }

    protected void inlet(float value) {
        if (!this.defaultInt) {
            this.inlet((int)value);
            return;
        }
        if (!this.defaultAtomList) {
            this.list(new Atom[]{Atom.newAtom(value)});
            return;
        }
        this.anything("float", new Atom[]{Atom.newAtom(value)});
    }

    protected void list(Atom[] atomArray) {
        if (!this.defaultAnything) {
            this.anything("list", atomArray);
            return;
        }
        if (atomArray[0].getType() == 1 && !this.defaultInt) {
            this.inlet(atomArray[0].getInt());
            return;
        }
        if (atomArray[0].getType() == 2 && !this.defaultFloat) {
            this.inlet(atomArray[0].getFloat());
            return;
        }
        MaxObject.error(this.getClass().getName() + " doesn't understand list");
    }

    protected void list(float[] f) {
        this.list(Atom.newAtom(f));
    }

    protected void list(int[] i) {
        this.list(Atom.newAtom(i));
    }

    protected void anything(String message, Atom[] args) {
        if (message.equals("list")) {
            this.list(args);
            return;
        }
        MaxObject.error(this.getClass().getName() + " doesn't understand " + message);
    }

    public String getCodeSourcePath() {
        try {
            String ret;
            URL url = this.getClass().getProtectionDomain().getCodeSource().getLocation();
            String dirname = url.getFile();
            if (dirname.endsWith(".jar") || dirname.endsWith(".zip")) {
                if (new File(dirname).exists()) {
                    return dirname;
                }
                return null;
            }
            String name = this.getClass().getName();
            String native_fs_name = name.replace('.', File.separatorChar);
            if (dirname.charAt(dirname.length() - 1) != File.separatorChar) {
                dirname = dirname + String.valueOf(File.separatorChar);
            }
            if (new File(ret = dirname + native_fs_name + ".class").exists()) {
                return ret;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void postCodePath() {
        String loc = this.getCodeSourcePath();
        if (loc != null) {
            MaxObject.post("loc is : " + loc);
        }
    }

    public void viewsource() {
        String name = this.getClass().getName();
        String slashname = null;
        String native_fs_name = null;
        String dirname = null;
        slashname = name.replace('.', '/');
        native_fs_name = name.replace('.', File.separatorChar);
        URL url = this.getClass().getProtectionDomain().getCodeSource().getLocation();
        dirname = new File(url.getFile()).getAbsolutePath();
        if (dirname.charAt(dirname.length() - 1) != File.separatorChar) {
            dirname = dirname + String.valueOf(File.separatorChar);
        }
        String abspath = dirname + native_fs_name + ".java";
        if (url.toString().endsWith(".jar")) {
            try {
                this._viewsourcejar(slashname, URLDecoder.decode(url.getFile(), "UTF-8"));
            }
            catch (UnsupportedEncodingException esee) {
                System.err.println("(mxj) problem decoding jar URL. Unable to decompile.");
            }
            return;
        }
        final File f = new File(abspath);
        if (!f.exists()) {
            this._flash_watch = this.WATCHME;
            this._flash_me();
            System.out.println("(mxj) Unable to locate " + abspath + ". Decompiling with JODE");
            try {
                BufferedWriter bw = new BufferedWriter(new FileWriter(f));
                MXJDecompiler.getInstance().decompile(name, MaxSystem.getClassPath(), bw);
            }
            catch (IOException e) {
                f.delete();
                System.err.println("(mxj) Unable to decompile " + name);
                System.err.println("message: " + e.getMessage());
                this._flash_watch = null;
                return;
            }
            this._flash_watch = null;
        }
        if (this._source_editor != null) {
            this._flash_watch = this.WATCHME;
            this._flash_me();
            this._source_editor.setBufferFromFile(f);
            this._source_editor.setVisible(true);
            this._flash_watch = null;
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        MaxObject.this._flash_watch = MaxObject.this.WATCHME;
                        MaxObject.this._flash_me();
                        MaxObject.this._source_editor = new MXJEditor();
                        MaxObject.this._source_editor.setBufferFromFile(f);
                        MaxObject.this._source_editor.setVisible(true);
                        MaxObject.this._flash_watch = null;
                    }
                    catch (Exception e) {
                        MaxObject.this._flash_watch = null;
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    private void _viewsourcejar(String slashname, String jarfile) {
        try {
            JarFile jar = new JarFile(new File(jarfile));
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                int bytesRead;
                JarEntry entry = entries.nextElement();
                if (!entry.getName().equals(slashname + ".java")) continue;
                StringBuffer sb = new StringBuffer(1024);
                byte[] buffer = new byte[1024];
                InputStream entryStream = jar.getInputStream(entry);
                while ((bytesRead = entryStream.read(buffer)) != -1) {
                    sb.append(new String(buffer, 0, bytesRead));
                }
                final String s = sb.toString();
                final String dummyfilename = new String("!READONLY!:" + jar.getName() + "!/" + entry.getName());
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        MaxObject.this._flash_watch = MaxObject.this.WATCHME;
                        MaxObject.this._flash_me();
                        File f = new File(dummyfilename);
                        MaxObject.this._source_editor = new MXJEditor();
                        MaxObject.this._source_editor.setBuffer(s);
                        MaxObject.this._source_editor.setCurrentFile(f);
                        MaxObject.this._source_editor.setEditable(false);
                        MaxObject.this._source_editor.setMode(1);
                        MaxObject.this._source_editor.setVisible(true);
                        MaxObject.this._flash_watch = null;
                    }
                });
                return;
            }
            StringWriter sw = new StringWriter(2048);
            this._flash_watch = this.WATCHME;
            this._flash_me();
            MXJDecompiler.getInstance().decompile(slashname.replaceAll("/", "."), MaxSystem.getClassPath(), sw);
            this._flash_watch = null;
            sw.flush();
            final String s = sw.toString();
            final String dummyfilename = new String("!READONLY!:" + jar.getName() + "!/" + slashname + ".java");
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MaxObject.this._flash_watch = MaxObject.this.WATCHME;
                    MaxObject.this._flash_me();
                    File f = new File(dummyfilename);
                    MaxObject.this._source_editor = new MXJEditor();
                    MaxObject.this._source_editor.setBuffer(s);
                    MaxObject.this._source_editor.setCurrentFile(f);
                    MaxObject.this._source_editor.setEditable(false);
                    MaxObject.this._source_editor.setMode(1);
                    MaxObject.this._source_editor.setVisible(true);
                    MaxObject.this._flash_watch = null;
                }
            });
        }
        catch (Exception e) {
            this._flash_watch = null;
            System.err.println("error viewing source from jarfile " + jarfile);
            e.printStackTrace();
        }
    }

    private void _flash_me() {
    }

    protected native int getInlet();

    public String getOutletAssist(int outletIdx) {
        if (outletIdx < this.mOutletAssist.length) {
            return this.mOutletAssist[outletIdx];
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append(" outlet ");
        sb.append(outletIdx);
        sb.append(": type is ");
        if (outletIdx > this.getNumOutlets()) {
            sb.append("OUT OF RANGE");
        } else {
            sb.append(DataTypes.toString(this.getOutletType(outletIdx)));
        }
        return sb.toString();
    }

    public final boolean outletBang(int outletIdx) {
        return this.doOutletBang(outletIdx);
    }

    public final boolean outlet(int outletIdx, int value) {
        return this.doOutlet(outletIdx, value);
    }

    public final boolean outlet(int outletIdx, byte value) {
        return this.outlet(outletIdx, (int)value);
    }

    public final boolean outlet(int outletIdx, short value) {
        return this.outlet(outletIdx, (int)value);
    }

    public final boolean outlet(int outletIdx, long value) {
        return this.outlet(outletIdx, (int)value);
    }

    public final boolean outlet(int outletIdx, float value) {
        return this.doOutlet(outletIdx, value);
    }

    public final boolean outlet(int outletIdx, double value) {
        return this.outlet(outletIdx, (float)value);
    }

    public final boolean outlet(int outletIdx, String message) {
        return this.outlet(outletIdx, message, Atom.emptyArray);
    }

    public final boolean outlet(int outletIdx, char c) {
        return this.outlet(outletIdx, String.valueOf(c), Atom.emptyArray);
    }

    public final boolean outlet(int outletIdx, boolean value) {
        return this.outlet(outletIdx, Atom.newAtom(value));
    }

    public final boolean outlet(int outletIdx, String message, Atom[] args) {
        if (message == null) {
            throw new NullPointerException("message cannot be null");
        }
        if (args == null) {
            throw new NullPointerException("args argument cannot be null");
        }
        if (ArrayUtilities.containsNull(args)) {
            throw new NullPointerException("args array cannot contain null");
        }
        return this.doOutlet(outletIdx, message, args);
    }

    public final boolean outlet(int outletIdx, Atom value) {
        if (value.isInt()) {
            return this.outlet(outletIdx, value.getInt());
        }
        if (value.isFloat()) {
            return this.outlet(outletIdx, value.getFloat());
        }
        return this.outlet(outletIdx, value.getString());
    }

    public final boolean outlet(int outletIdx, Atom[] array) {
        if (array == null || array.length == 0) {
            return false;
        }
        if (ArrayUtilities.containsNull(array)) {
            throw new NullPointerException("value array cannot contain null");
        }
        if (array.length == 1) {
            return this.outlet(outletIdx, array[0]);
        }
        if (array[0].isString()) {
            String message = array[0].getString();
            return this.doOutlet(outletIdx, message, Atom.removeFirst(array));
        }
        return this.doOutlet(outletIdx, array);
    }

    public final boolean outlet(int outletIdx, int[] value) {
        return this.doOutlet(outletIdx, value);
    }

    public final boolean outlet(int outletIdx, byte[] value) {
        return this.outlet(outletIdx, Atom.newAtom(value));
    }

    public final boolean outlet(int outletIdx, short[] value) {
        return this.outlet(outletIdx, Atom.newAtom(value));
    }

    public final boolean outlet(int outletIdx, long[] value) {
        return this.outlet(outletIdx, Atom.newAtom(value));
    }

    public final boolean outlet(int outletIdx, float[] value) {
        return this.doOutlet(outletIdx, value);
    }

    public final boolean outlet(int outletIdx, double[] value) {
        return this.outlet(outletIdx, Atom.newAtom(value));
    }

    public final boolean outlet(int outletIdx, String[] value) {
        return this.outlet(outletIdx, Atom.newAtom(value));
    }

    public final boolean outlet(int outletIdx, char[] value) {
        return this.outlet(outletIdx, Atom.newAtom(value));
    }

    public final boolean outlet(int outletIdx, boolean[] array) {
        return this.outlet(outletIdx, Atom.newAtom(array));
    }

    public final boolean outlet(int outletIdx, String msg, int value) {
        return this.doOutlet(outletIdx, msg, new Atom[]{Atom.newAtom(value)});
    }

    public final boolean outlet(int outletIdx, String msg, byte value) {
        return this.doOutlet(outletIdx, msg, new Atom[]{Atom.newAtom((int)value)});
    }

    public final boolean outlet(int outletIdx, String msg, short value) {
        return this.doOutlet(outletIdx, msg, new Atom[]{Atom.newAtom((int)value)});
    }

    public final boolean outlet(int outletIdx, String msg, long value) {
        return this.doOutlet(outletIdx, msg, new Atom[]{Atom.newAtom((int)value)});
    }

    public final boolean outlet(int outletIdx, String msg, float value) {
        return this.doOutlet(outletIdx, msg, new Atom[]{Atom.newAtom(value)});
    }

    public final boolean outlet(int outletIdx, String msg, double value) {
        return this.doOutlet(outletIdx, msg, new Atom[]{Atom.newAtom((float)value)});
    }

    public final boolean outlet(int outletIdx, String msg, String value) {
        return this.doOutlet(outletIdx, msg, new Atom[]{Atom.newAtom(value)});
    }

    public final boolean outlet(int outletIdx, String msg, char c) {
        return this.doOutlet(outletIdx, msg, new Atom[]{Atom.newAtom(String.valueOf(c))});
    }

    public final boolean outlet(int outletIdx, String msg, boolean value) {
        return this.doOutlet(outletIdx, msg, new Atom[]{Atom.newAtom(value)});
    }

    public final boolean outlet(int outletIdx, String msg, Atom value) {
        return this.doOutlet(outletIdx, msg, new Atom[]{value});
    }

    public final boolean outlet(int outletIdx, String msg, int[] value) {
        return this.doOutlet(outletIdx, msg, value);
    }

    public final boolean outlet(int outletIdx, String msg, byte[] value) {
        return this.doOutlet(outletIdx, msg, Atom.newAtom(value));
    }

    public final boolean outlet(int outletIdx, String msg, short[] value) {
        return this.doOutlet(outletIdx, msg, Atom.newAtom(value));
    }

    public final boolean outlet(int outletIdx, String msg, long[] value) {
        return this.doOutlet(outletIdx, msg, Atom.newAtom(value));
    }

    public final boolean outlet(int outletIdx, String msg, float[] value) {
        return this.doOutlet(outletIdx, msg, value);
    }

    public final boolean outlet(int outletIdx, String msg, double[] value) {
        return this.doOutlet(outletIdx, msg, Atom.newAtom(value));
    }

    public final boolean outlet(int outletIdx, String msg, String[] value) {
        return this.doOutlet(outletIdx, msg, Atom.newAtom(value));
    }

    public final boolean outlet(int outletIdx, String msg, char[] value) {
        return this.doOutlet(outletIdx, msg, Atom.newAtom(value));
    }

    public final boolean outlet(int outletIdx, String msg, boolean[] array) {
        return this.doOutlet(outletIdx, msg, Atom.newAtom(array));
    }

    private native boolean doOutletBang(int var1);

    private final native boolean doOutlet(int var1, int var2);

    private final native boolean doOutlet(int var1, float var2);

    private final native boolean doOutlet(int var1, String var2, Atom[] var3);

    private final native boolean doOutlet(int var1, Atom[] var2);

    private final native boolean doOutlet(int var1, int[] var2);

    private final native boolean doOutlet(int var1, float[] var2);

    private final native boolean doOutlet(int var1, String var2, int[] var3);

    private final native boolean doOutlet(int var1, String var2, float[] var3);

    public final boolean outletBangHigh(int outletIdx) {
        return this.doOutletBangHigh(outletIdx);
    }

    public final boolean outletHigh(int outletIdx, int value) {
        return this.doOutletHigh(outletIdx, value);
    }

    public final boolean outletHigh(int outletIdx, float value) {
        return this.doOutletHigh(outletIdx, value);
    }

    public final boolean outletHigh(int outletIdx, double value) {
        return this.doOutletHigh(outletIdx, (float)value);
    }

    public final boolean outletHigh(int outletIdx, String message) {
        return this.outletHigh(outletIdx, message, Atom.emptyArray);
    }

    public final boolean outletHigh(int outletIdx, String message, Atom[] args) {
        if (message == null) {
            throw new NullPointerException("message cannot be null");
        }
        if (args == null) {
            throw new NullPointerException("args argument cannot be null");
        }
        if (ArrayUtilities.containsNull(args)) {
            throw new NullPointerException("args array cannot contain null");
        }
        return this.doOutletHigh(outletIdx, message, args);
    }

    public final boolean outletHigh(int outletIdx, String message, int[] values) {
        return this.doOutletHigh(outletIdx, message, values);
    }

    public final boolean outletHigh(int outletIdx, String message, float[] values) {
        return this.doOutletHigh(outletIdx, message, values);
    }

    public final boolean outletHigh(int outletIdx, Atom[] value) {
        if (value == null) {
            throw new NullPointerException("value cannot be null");
        }
        if (ArrayUtilities.containsNull(value)) {
            throw new NullPointerException("value array cannot contain null");
        }
        return this.doOutletHigh(outletIdx, value);
    }

    public final boolean outletHigh(int outletIdx, int[] values) {
        return this.doOutletHigh(outletIdx, values);
    }

    public final boolean outletHigh(int outletIdx, float[] values) {
        return this.doOutletHigh(outletIdx, values);
    }

    private native boolean doOutletBangHigh(int var1);

    private final native boolean doOutletHigh(int var1, int var2);

    private final native boolean doOutletHigh(int var1, float var2);

    private final native boolean doOutletHigh(int var1, String var2, Atom[] var3);

    private final native boolean doOutletHigh(int var1, Atom[] var2);

    private final native boolean doOutletHigh(int var1, int[] var2);

    private final native boolean doOutletHigh(int var1, float[] var2);

    private final native boolean doOutletHigh(int var1, String var2, int[] var3);

    private final native boolean doOutletHigh(int var1, String var2, float[] var3);

    private long getPeer() {
        return this.mPeer;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append("[");
        if (this.mName != null) {
            sb.append("name: '");
            sb.append(this.mName);
            sb.append("'; ");
        }
        sb.append(this.mInlets.length);
        sb.append(" in; ");
        sb.append(this.mOutlets.length);
        sb.append(" out]");
        return sb.toString();
    }

    protected void save() {
    }

    protected void loadbang() {
    }

    protected void dblclick() {
    }

    protected void embedMessage(String msg, Atom[] args) {
        if (msg.length() > 0) {
            this.doEmbedMessage(msg, args);
        }
    }

    private native void doEmbedMessage(String var1, Atom[] var2);

    private Method[] _get_all_methods(Object o) {
        Class<?> c = o.getClass();
        Method[] methods = c.getDeclaredMethods();
        c = c.getSuperclass();
        while (c.getName() != "java.lang.Object") {
            Method[] tempa = c.getDeclaredMethods();
            Method[] tempb = new Method[methods.length + tempa.length];
            System.arraycopy(methods, 0, tempb, 0, methods.length);
            System.arraycopy(tempa, 0, tempb, methods.length, tempa.length);
            methods = tempb;
            c = c.getSuperclass();
        }
        return methods;
    }

    private Constructor[] _get_all_constructors(Object o) {
        Class<?> c = o.getClass();
        Constructor[] constructors = c.getDeclaredConstructors();
        return constructors;
    }

    private Method[] getAllMethodsButMaxObject(Object o) {
        Class<?> c = o.getClass();
        Method[] methods = c.getDeclaredMethods();
        c = c.getSuperclass();
        while (c.getName() != "com.cycling74.max.MaxObject") {
            Method[] tempa = c.getDeclaredMethods();
            Method[] tempb = new Method[methods.length + tempa.length];
            System.arraycopy(methods, 0, tempb, 0, methods.length);
            System.arraycopy(tempa, 0, tempb, methods.length, tempa.length);
            methods = tempb;
            c = c.getSuperclass();
        }
        return methods;
    }

    private Field[] _get_all_fields(Object o) {
        Class<?> c = this.getClass();
        Field[] fields = c.getDeclaredFields();
        c = c.getSuperclass();
        while (c.getName() != "com.cycling74.max.MaxObject") {
            Field[] tempa = c.getDeclaredFields();
            Field[] tempb = new Field[fields.length + tempa.length];
            System.arraycopy(fields, 0, tempb, 0, fields.length);
            System.arraycopy(tempa, 0, tempb, fields.length, tempa.length);
            fields = tempb;
            c = c.getSuperclass();
        }
        return fields;
    }

    protected void declareAttribute(String name) {
        this.declareAttribute(name, null, null, true, true);
    }

    protected void declareReadOnlyAttribute(String name) {
        this.declareAttribute(name, null, null, true, false);
    }

    protected void declareAttribute(String name, String getter, String setter) {
        this.declareAttribute(name, getter, setter, true, true);
    }

    protected void declareReadOnlyAttribute(String name, String getter) {
        this.declareAttribute(name, getter, null, true, false);
    }

    private void declareAttribute(String name, String getter, String setter, boolean gettable, boolean settable) {
        AttributeInfo a = new AttributeInfo();
        a.name = name;
        a.settable = false;
        a.gettable = false;
        a.isvirtual = 1;
        a.j_f_type = "virtual";
        a.m_f_type = "virtual";
        Field f = null;
        Field[] fields = this._get_all_fields(this);
        for (int i = 0; i < fields.length; ++i) {
            f = fields[i];
            if (!f.getName().equals(a.name)) continue;
            a.j_f_type = "object";
            a.isvirtual = 2;
            if (!this._is_valid_primative_attr(f)) continue;
            Method getterM = null;
            Method setterM = null;
            Object[] nfo = this._get_attr_info(f);
            a.m_f_type = (String)nfo[0];
            a.j_f_type = (String)nfo[1];
            a.isvirtual = 0;
            a.settable = settable;
            a.gettable = gettable;
            if (setter != null && (setterM = this._is_valid_attr_setter(setter)) != null) {
                a.setter = setter;
                Object[] sigs = this._build_sigs(setterM);
                a.setter_sig = (String)sigs[1];
                a.setter_jptypes = (String)sigs[3];
            }
            if (getter != null && (getterM = this._is_valid_attr_getter(getter)) != null) {
                Class<?> rt = getterM.getReturnType();
                a.getter = getter;
                if (rt.equals(Integer.TYPE)) {
                    a.getter_sig = "()I";
                } else if (rt.equals(Long.TYPE)) {
                    a.getter_sig = "()J";
                } else if (rt.equals(Short.TYPE)) {
                    a.getter_sig = "()S";
                } else if (rt.equals(Byte.TYPE)) {
                    a.getter_sig = "()B";
                } else if (rt.equals(Float.TYPE)) {
                    a.getter_sig = "()F";
                } else if (rt.equals(Double.TYPE)) {
                    a.getter_sig = "()D";
                } else if (rt.equals(Boolean.TYPE)) {
                    a.getter_sig = "()Z";
                } else if (rt.equals(Character.TYPE)) {
                    a.getter_sig = "()C";
                } else if (rt.equals(STRING_CLASS)) {
                    a.getter_sig = "()Ljava/lang/String;";
                } else if (rt.equals(ATOM_ARRAY_CLASS)) {
                    a.getter_sig = "()[Lcom/cycling74/max/Atom;";
                } else if (rt.equals(BOOL_ARRAY_CLASS)) {
                    a.getter_sig = "()[Z";
                } else if (rt.equals(BYTE_ARRAY_CLASS)) {
                    a.getter_sig = "()[B";
                } else if (rt.equals(CHAR_ARRAY_CLASS)) {
                    a.getter_sig = "()[C";
                } else if (rt.equals(SHORT_ARRAY_CLASS)) {
                    a.getter_sig = "()[S";
                } else if (rt.equals(INT_ARRAY_CLASS)) {
                    a.getter_sig = "()[I";
                } else if (rt.equals(LONG_ARRAY_CLASS)) {
                    a.getter_sig = "()[J";
                } else if (rt.equals(FLOAT_ARRAY_CLASS)) {
                    a.getter_sig = "()[F";
                } else if (rt.equals(DOUBLE_ARRAY_CLASS)) {
                    a.getter_sig = "()[D";
                } else if (rt.equals(STRING_ARRAY_CLASS)) {
                    a.getter_sig = "()[Ljava/lang/String;";
                }
            }
            this._make_java_callable_attribute(a.name, a, getterM, setterM, f);
            this._attributes.addElement(a);
            return;
        }
        Method getterM = null;
        Method setterM = null;
        if (setter == null) {
            a.settable = false;
        } else {
            setterM = this._is_valid_attr_setter(setter);
            if (setterM != null) {
                a.settable = true;
                a.setter = setter;
                Object[] sigs = this._build_sigs(setterM);
                a.setter_sig = (String)sigs[1];
                a.setter_jptypes = (String)sigs[3];
            } else {
                System.out.println("warning: ignoring virtual attribute " + a.name + " setter. It is a not valid.");
            }
        }
        if (getter == null) {
            a.gettable = false;
        } else {
            getterM = this._is_valid_attr_getter(getter);
            if (getterM != null) {
                a.getter = getter;
                a.gettable = gettable;
                Class<?> rt = getterM.getReturnType();
                if (rt.equals(Integer.TYPE)) {
                    a.getter_sig = "()I";
                } else if (rt.equals(Long.TYPE)) {
                    a.getter_sig = "()J";
                } else if (rt.equals(Short.TYPE)) {
                    a.getter_sig = "()S";
                } else if (rt.equals(Byte.TYPE)) {
                    a.getter_sig = "()B";
                } else if (rt.equals(Float.TYPE)) {
                    a.getter_sig = "()F";
                } else if (rt.equals(Double.TYPE)) {
                    a.getter_sig = "()D";
                } else if (rt.equals(Boolean.TYPE)) {
                    a.getter_sig = "()Z";
                } else if (rt.equals(Character.TYPE)) {
                    a.getter_sig = "()C";
                } else if (rt.equals(STRING_CLASS)) {
                    a.getter_sig = "()Ljava/lang/String;";
                } else if (rt.equals(ATOM_ARRAY_CLASS)) {
                    a.getter_sig = "()[Lcom/cycling74/max/Atom;";
                } else if (rt.equals(BOOL_ARRAY_CLASS)) {
                    a.getter_sig = "()[Z";
                } else if (rt.equals(BYTE_ARRAY_CLASS)) {
                    a.getter_sig = "()[B";
                } else if (rt.equals(CHAR_ARRAY_CLASS)) {
                    a.getter_sig = "()[C";
                } else if (rt.equals(SHORT_ARRAY_CLASS)) {
                    a.getter_sig = "()[S";
                } else if (rt.equals(INT_ARRAY_CLASS)) {
                    a.getter_sig = "()[I";
                } else if (rt.equals(LONG_ARRAY_CLASS)) {
                    a.getter_sig = "()[J";
                } else if (rt.equals(FLOAT_ARRAY_CLASS)) {
                    a.getter_sig = "()[F";
                } else if (rt.equals(DOUBLE_ARRAY_CLASS)) {
                    a.getter_sig = "()[D";
                } else if (rt.equals(STRING_ARRAY_CLASS)) {
                    a.getter_sig = "()[Ljava/lang/String;";
                }
            } else {
                System.out.println("warning: ignoring virtual attribute " + a.name + " getter. It is a not valid.");
            }
        }
        if (!a.gettable && !a.settable) {
            System.out.println("warning: ignoring object attribute " + a.name + " alltogether. No getter or setter defined.");
            return;
        }
        this._make_java_callable_attribute(a.name, a, getterM, setterM, null);
        this._attributes.addElement(a);
    }

    private native void _register_message(String var1, int var2, String var3, String var4, String var5);

    private native void _register_attribute(AttributeInfo var1);

    private void _init_mxj_message_table() {
        Object[] sigs;
        int i;
        if (this.s_meth_desc == null || this.s_const_desc == null) {
            this._init_mxj_message_table_low();
        }
        for (i = 0; i < this.s_meth_desc.length; ++i) {
            sigs = (Object[])this.s_meth_desc[i];
            this._register_message((String)sigs[0], (Integer)sigs[4], (String)sigs[1], (String)sigs[2], (String)sigs[3]);
        }
        for (i = 0; i < this.s_const_desc.length; ++i) {
            sigs = (Object[])this.s_const_desc[i];
            this._register_message((String)sigs[0], (Integer)sigs[4], (String)sigs[1], (String)sigs[2], (String)sigs[3]);
        }
    }

    private void _init_mxj_message_table_low() {
        int i;
        Method[] meths = this._get_all_methods(this);
        Constructor[] consts = this._get_all_constructors(this);
        int cnt = 0;
        Object[] tmp = new Object[meths.length];
        for (i = 0; i < meths.length; ++i) {
            Method m = meths[i];
            if (!this._is_mxj_callable_method(m)) continue;
            tmp[cnt] = this._build_sigs(m);
            ++cnt;
        }
        this.s_meth_desc = new Object[cnt];
        for (i = 0; i < cnt; ++i) {
            this.s_meth_desc[i] = tmp[i];
        }
        cnt = 0;
        tmp = new Object[consts.length];
        for (i = 0; i < consts.length; ++i) {
            Constructor c = consts[i];
            if (!this._is_mxj_callable_constructor(c)) continue;
            tmp[cnt] = this._build_sigs(c, true);
            ++cnt;
        }
        this.s_const_desc = new Object[cnt];
        for (i = 0; i < cnt; ++i) {
            this.s_const_desc[i] = tmp[i];
        }
    }

    private void _init_mxj_attr_table() {
        for (int i = 0; i < this._attributes.size(); ++i) {
            AttributeInfo ai = (AttributeInfo)this._attributes.elementAt(i);
            this._register_attribute(ai);
        }
    }

    private Object[] _build_sigs(Object m) {
        return this._build_sigs(m, false);
    }

    private Object[] _build_sigs(Object m, boolean isconstructor) {
        int i;
        String name;
        Class<?>[] params;
        StringBuffer java_sig = new StringBuffer("(");
        StringBuffer mxj_ptypes = new StringBuffer();
        StringBuffer java_ptypes = new StringBuffer();
        if (!isconstructor) {
            params = ((Method)m).getParameterTypes();
            name = ((Method)m).getName();
        } else {
            params = ((Constructor)m).getParameterTypes();
            name = "<init>";
        }
        for (i = 0; i < params.length; ++i) {
            if (params[i].equals(Integer.TYPE)) {
                java_sig.append('I');
                mxj_ptypes.append('I');
                java_ptypes.append('I');
                continue;
            }
            if (params[i].equals(Long.TYPE)) {
                java_sig.append('J');
                mxj_ptypes.append('I');
                java_ptypes.append('J');
                continue;
            }
            if (params[i].equals(Short.TYPE)) {
                java_sig.append('S');
                mxj_ptypes.append('I');
                java_ptypes.append('S');
                continue;
            }
            if (params[i].equals(Byte.TYPE)) {
                java_sig.append('B');
                mxj_ptypes.append('I');
                java_ptypes.append('B');
                continue;
            }
            if (params[i].equals(Float.TYPE)) {
                java_sig.append('F');
                mxj_ptypes.append('F');
                java_ptypes.append('F');
                continue;
            }
            if (params[i].equals(Double.TYPE)) {
                java_sig.append('D');
                mxj_ptypes.append('F');
                java_ptypes.append('D');
                continue;
            }
            if (params[i].equals(Boolean.TYPE)) {
                java_sig.append('Z');
                mxj_ptypes.append('I');
                java_ptypes.append('Z');
                continue;
            }
            if (params[i].equals(Character.TYPE)) {
                java_sig.append('C');
                mxj_ptypes.append('I');
                java_ptypes.append('C');
                continue;
            }
            if (params[i].equals(STRING_CLASS)) {
                java_sig.append("Ljava/lang/String;");
                mxj_ptypes.append('s');
                java_ptypes.append('s');
                continue;
            }
            if (params[i].equals(ATOM_ARRAY_CLASS)) {
                java_sig.append("[Lcom/cycling74/max/Atom;");
                mxj_ptypes.append('G');
                java_ptypes.append('G');
                continue;
            }
            if (params[i].equals(BOOL_ARRAY_CLASS)) {
                java_sig.append("[Z");
                mxj_ptypes.append("[I");
                java_ptypes.append("[Z");
                continue;
            }
            if (params[i].equals(BYTE_ARRAY_CLASS)) {
                java_sig.append("[B");
                mxj_ptypes.append("[I");
                java_ptypes.append("[B");
                continue;
            }
            if (params[i].equals(CHAR_ARRAY_CLASS)) {
                java_sig.append("[C");
                mxj_ptypes.append("[I");
                java_ptypes.append("[C");
                continue;
            }
            if (params[i].equals(SHORT_ARRAY_CLASS)) {
                java_sig.append("[S");
                mxj_ptypes.append("[I");
                java_ptypes.append("[S");
                continue;
            }
            if (params[i].equals(INT_ARRAY_CLASS)) {
                java_sig.append("[I");
                mxj_ptypes.append("[I");
                java_ptypes.append("[I");
                continue;
            }
            if (params[i].equals(LONG_ARRAY_CLASS)) {
                java_sig.append("[J");
                mxj_ptypes.append("[I");
                java_ptypes.append("[J");
                continue;
            }
            if (params[i].equals(FLOAT_ARRAY_CLASS)) {
                java_sig.append("[F");
                mxj_ptypes.append("[F");
                java_ptypes.append("[F");
                continue;
            }
            if (params[i].equals(DOUBLE_ARRAY_CLASS)) {
                java_sig.append("[D");
                mxj_ptypes.append("[F");
                java_ptypes.append("[D");
                continue;
            }
            if (!params[i].equals(STRING_ARRAY_CLASS)) continue;
            java_sig.append("[Ljava/lang/String;");
            mxj_ptypes.append("[s");
            java_ptypes.append("[s");
        }
        if (params.length == 0) {
            mxj_ptypes.append('V');
            java_ptypes.append('V');
        }
        java_sig.append(")V");
        return new Object[]{name, java_sig.toString(), mxj_ptypes.toString(), java_ptypes.toString(), new Integer(i), m};
    }

    private Method _is_valid_attr_setter(String methodname) {
        Method[] methods = this._get_all_methods(this);
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (!methods[i].getName().equals(methodname) || !this._is_attr_callable_set_method(methods[i])) continue;
            return m;
        }
        return null;
    }

    private Method _is_valid_attr_getter(String methodname) {
        Method[] methods = this._get_all_methods(this);
        for (int i = 0; i < methods.length; ++i) {
            Class<?> rt;
            Method m = methods[i];
            if (!m.getName().equals(methodname) || m.getParameterTypes().length != 0 || Modifier.isStatic(m.getModifiers()) || !(rt = m.getReturnType()).equals(Integer.TYPE) && !rt.equals(Float.TYPE) && !rt.equals(STRING_CLASS) && !rt.equals(Short.TYPE) && !rt.equals(Long.TYPE) && !rt.equals(Character.TYPE) && !rt.equals(Byte.TYPE) && !rt.equals(Double.TYPE) && !rt.equals(Long.TYPE) && !rt.equals(Boolean.TYPE) && !rt.equals(ATOM_ARRAY_CLASS) && !rt.equals(BOOL_ARRAY_CLASS) && !rt.equals(BYTE_ARRAY_CLASS) && !rt.equals(CHAR_ARRAY_CLASS) && !rt.equals(SHORT_ARRAY_CLASS) && !rt.equals(INT_ARRAY_CLASS) && !rt.equals(LONG_ARRAY_CLASS) && !rt.equals(FLOAT_ARRAY_CLASS) && !rt.equals(DOUBLE_ARRAY_CLASS) && !rt.equals(STRING_ARRAY_CLASS)) continue;
            return m;
        }
        return null;
    }

    private boolean _is_attr_callable_set_method(Method m) {
        int modifiers = m.getModifiers();
        if (!Modifier.isStatic(modifiers) && m.getReturnType().equals(Void.TYPE)) {
            Class<?>[] params = m.getParameterTypes();
            for (int i = 0; i < params.length; ++i) {
                if (params[i].equals(Integer.TYPE) || params[i].equals(Float.TYPE) || params[i].equals(STRING_CLASS) || params[i].equals(Short.TYPE) || params[i].equals(Long.TYPE) || params[i].equals(Character.TYPE) || params[i].equals(Byte.TYPE) || params[i].equals(Double.TYPE) || params[i].equals(Long.TYPE) || params[i].equals(Boolean.TYPE)) continue;
                if (i == 0 && params[i].equals(ATOM_ARRAY_CLASS)) {
                    return true;
                }
                if (i == 0 && params[i].equals(BOOL_ARRAY_CLASS)) {
                    return true;
                }
                if (i == 0 && params[i].equals(BYTE_ARRAY_CLASS)) {
                    return true;
                }
                if (i == 0 && params[i].equals(CHAR_ARRAY_CLASS)) {
                    return true;
                }
                if (i == 0 && params[i].equals(SHORT_ARRAY_CLASS)) {
                    return true;
                }
                if (i == 0 && params[i].equals(INT_ARRAY_CLASS)) {
                    return true;
                }
                if (i == 0 && params[i].equals(LONG_ARRAY_CLASS)) {
                    return true;
                }
                if (i == 0 && params[i].equals(FLOAT_ARRAY_CLASS)) {
                    return true;
                }
                if (i == 0 && params[i].equals(DOUBLE_ARRAY_CLASS)) {
                    return true;
                }
                return i == 0 && params[i].equals(STRING_ARRAY_CLASS);
            }
            return true;
        }
        return false;
    }

    private boolean _is_mxj_callable_method(Method m) {
        int modifiers = m.getModifiers();
        if (Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers) && m.getReturnType().equals(Void.TYPE)) {
            Class<?>[] params = m.getParameterTypes();
            for (int i = 0; i < params.length; ++i) {
                if (params[i].equals(Integer.TYPE) || params[i].equals(Float.TYPE) || params[i].equals(STRING_CLASS) || params[i].equals(Short.TYPE) || params[i].equals(Long.TYPE) || params[i].equals(Character.TYPE) || params[i].equals(Byte.TYPE) || params[i].equals(Double.TYPE) || params[i].equals(Long.TYPE) || params[i].equals(Boolean.TYPE)) continue;
                if (i == 0 && params[i].equals(ATOM_ARRAY_CLASS)) {
                    return true;
                }
                if (i == 0 && params[i].equals(BOOL_ARRAY_CLASS)) {
                    return true;
                }
                if (i == 0 && params[i].equals(BYTE_ARRAY_CLASS)) {
                    return true;
                }
                if (i == 0 && params[i].equals(CHAR_ARRAY_CLASS)) {
                    return true;
                }
                if (i == 0 && params[i].equals(SHORT_ARRAY_CLASS)) {
                    return true;
                }
                if (i == 0 && params[i].equals(INT_ARRAY_CLASS)) {
                    return true;
                }
                if (i == 0 && params[i].equals(LONG_ARRAY_CLASS)) {
                    return true;
                }
                if (i == 0 && params[i].equals(FLOAT_ARRAY_CLASS)) {
                    return true;
                }
                if (i == 0 && params[i].equals(DOUBLE_ARRAY_CLASS)) {
                    return true;
                }
                return i == 0 && params[i].equals(STRING_ARRAY_CLASS);
            }
            return true;
        }
        return false;
    }

    private boolean _is_mxj_callable_constructor(Constructor m) {
        int modifiers = m.getModifiers();
        Class<?>[] params = m.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            if (params[i].equals(Integer.TYPE) || params[i].equals(Float.TYPE) || params[i].equals(STRING_CLASS) || params[i].equals(Short.TYPE) || params[i].equals(Long.TYPE) || params[i].equals(Character.TYPE) || params[i].equals(Byte.TYPE) || params[i].equals(Double.TYPE) || params[i].equals(Long.TYPE) || params[i].equals(Boolean.TYPE)) continue;
            if (i == 0 && params[i].equals(ATOM_ARRAY_CLASS)) {
                return true;
            }
            if (i == 0 && params[i].equals(BOOL_ARRAY_CLASS)) {
                return true;
            }
            if (i == 0 && params[i].equals(BYTE_ARRAY_CLASS)) {
                return true;
            }
            if (i == 0 && params[i].equals(CHAR_ARRAY_CLASS)) {
                return true;
            }
            if (i == 0 && params[i].equals(SHORT_ARRAY_CLASS)) {
                return true;
            }
            if (i == 0 && params[i].equals(INT_ARRAY_CLASS)) {
                return true;
            }
            if (i == 0 && params[i].equals(LONG_ARRAY_CLASS)) {
                return true;
            }
            if (i == 0 && params[i].equals(FLOAT_ARRAY_CLASS)) {
                return true;
            }
            if (i == 0 && params[i].equals(DOUBLE_ARRAY_CLASS)) {
                return true;
            }
            return i == 0 && params[i].equals(STRING_ARRAY_CLASS);
        }
        return true;
    }

    private Object[] _get_attr_info(Field f) {
        Class<?> type = f.getType();
        String m_t = null;
        String j_t = null;
        Object[] ret = new Object[2];
        if (type.equals(Integer.TYPE)) {
            m_t = "I";
            j_t = "I";
        } else if (type.equals(Long.TYPE)) {
            m_t = "I";
            j_t = "J";
        } else if (type.equals(Short.TYPE)) {
            m_t = "I";
            j_t = "S";
        } else if (type.equals(Byte.TYPE)) {
            m_t = "I";
            j_t = "B";
        } else if (type.equals(Float.TYPE)) {
            m_t = "F";
            j_t = "F";
        } else if (type.equals(Double.TYPE)) {
            m_t = "F";
            j_t = "D";
        } else if (type.equals(Boolean.TYPE)) {
            m_t = "I";
            j_t = "Z";
        } else if (type.equals(Character.TYPE)) {
            m_t = "I";
            j_t = "C";
        } else if (type.equals(STRING_CLASS)) {
            m_t = "s";
            j_t = "s";
        } else if (type.equals(INT_ARRAY_CLASS)) {
            m_t = "[I";
            j_t = "[I";
        } else if (type.equals(LONG_ARRAY_CLASS)) {
            m_t = "[I";
            j_t = "[J";
        } else if (type.equals(SHORT_ARRAY_CLASS)) {
            m_t = "[I";
            j_t = "[S";
        } else if (type.equals(BYTE_ARRAY_CLASS)) {
            m_t = "[I";
            j_t = "[B";
        } else if (type.equals(FLOAT_ARRAY_CLASS)) {
            m_t = "[F";
            j_t = "[F";
        } else if (type.equals(DOUBLE_ARRAY_CLASS)) {
            m_t = "[F";
            j_t = "[D";
        } else if (type.equals(BOOL_ARRAY_CLASS)) {
            m_t = "[I";
            j_t = "[Z";
        } else if (type.equals(CHAR_ARRAY_CLASS)) {
            m_t = "[I";
            j_t = "[C";
        } else if (type.equals(STRING_ARRAY_CLASS)) {
            m_t = "[s";
            j_t = "[s";
        }
        ret[0] = m_t;
        ret[1] = j_t;
        return ret;
    }

    private boolean _is_valid_primative_attr(Field f) {
        int modifiers = f.getModifiers();
        if (!Modifier.isStatic(modifiers) && !Modifier.isFinal(modifiers)) {
            Class<?> type = f.getType();
            return type.equals(Integer.TYPE) || type.equals(Float.TYPE) || type.equals(STRING_CLASS) || type.equals(Short.TYPE) || type.equals(Long.TYPE) || type.equals(Character.TYPE) || type.equals(Byte.TYPE) || type.equals(Double.TYPE) || type.equals(Long.TYPE) || type.equals(Boolean.TYPE) || type.equals(BOOL_ARRAY_CLASS) || type.equals(BYTE_ARRAY_CLASS) || type.equals(CHAR_ARRAY_CLASS) || type.equals(SHORT_ARRAY_CLASS) || type.equals(INT_ARRAY_CLASS) || type.equals(LONG_ARRAY_CLASS) || type.equals(FLOAT_ARRAY_CLASS) || type.equals(DOUBLE_ARRAY_CLASS) || type.equals(STRING_ARRAY_CLASS);
        }
        return false;
    }

    private void _make_java_callable_attribute(String name, AttributeInfo ai, Method getter, Method setter, Field f) {
        if (getter != null) {
            getter.setAccessible(true);
        }
        if (setter != null) {
            setter.setAccessible(true);
        }
        if (f != null) {
            f.setAccessible(true);
        }
        this._j_attribute_table.put(name, new AttributeEntry(ai, getter, setter, f));
    }

    public Object getAttr(String name) {
        AttributeEntry ae = (AttributeEntry)this._j_attribute_table.get(name);
        if (ae == null) {
            throw new MaxRuntimeException("attribute " + name + " does not exist as an attribute.");
        }
        if (ae.ai.gettable) {
            Object val = null;
            if (ae.getterM == null) {
                try {
                    val = ae.f.get(this);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                return val;
            }
            try {
                val = ae.getterM.invoke((Object)this, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return val;
        }
        return null;
    }

    public void setAttr(String name, Object val) {
        AttributeEntry ae = (AttributeEntry)this._j_attribute_table.get(name);
        if (ae == null) {
            throw new MaxRuntimeException("attribute " + name + " does not exist as an attribute.");
        }
        if (ae.ai.settable) {
            if (ae.setterM == null) {
                try {
                    ae.f.set(this, val);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            } else {
                Object[] args = null;
                args = val.getClass().equals(OBJECT_ARRAY_CLASS) ? (Object[])val : new Object[]{val};
                try {
                    ae.setterM.invoke((Object)this, args);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            MaxObject.error("(mxj) " + name + " is not a settable attribute.");
        }
    }

    public void setAttr(String name, Object[] args) {
        this.setAttr(name, (Object)args);
    }

    public boolean getAttrBool(String name) {
        Object val = null;
        val = this.getAttr(name);
        return (Boolean)val;
    }

    public boolean[] getAttrBoolArray(String name) {
        return (boolean[])this.getAttr(name);
    }

    public float getAttrByte(String name) {
        Object val = null;
        val = this.getAttr(name);
        return ((Byte)val).byteValue();
    }

    public byte[] getAttrByteArray(String name) {
        return (byte[])this.getAttr(name);
    }

    public char getAttrChar(String name) {
        Object val = null;
        val = this.getAttr(name);
        return ((Character)val).charValue();
    }

    public char[] getAttrCharArray(String name) {
        return (char[])this.getAttr(name);
    }

    public short getAttrShort(String name) {
        Object val = null;
        val = this.getAttr(name);
        return (Short)val;
    }

    public short[] getAttrShortArray(String name) {
        return (short[])this.getAttr(name);
    }

    public int getAttrInt(String name) {
        Object val = null;
        val = this.getAttr(name);
        return (Integer)val;
    }

    public int[] getAttrIntArray(String name) {
        return (int[])this.getAttr(name);
    }

    public long getLongAttr(String name) {
        Object val = null;
        val = this.getAttr(name);
        return (Long)val;
    }

    public long[] getAttrLongArray(String name) {
        return (long[])this.getAttr(name);
    }

    public float getAttrFloat(String name) {
        Object val = null;
        val = this.getAttr(name);
        return ((Float)val).floatValue();
    }

    public float[] getAttrFloatArray(String name) {
        return (float[])this.getAttr(name);
    }

    public double getAttrDouble(String name) {
        Object val = null;
        val = this.getAttr(name);
        return (Double)val;
    }

    public double[] getAttrDoubleArray(String name) {
        return (double[])this.getAttr(name);
    }

    public String getAttrString(String name) {
        Object val = null;
        val = this.getAttr(name);
        return (String)val;
    }

    public String[] getAttrStringArray(String name) {
        return (String[])this.getAttr(name);
    }

    public Atom[] getAttrAtomArray(String name) {
        return (Atom[])this.getAttr(name);
    }

    public void setAttr(String name, boolean val) {
        this.setAttr(name, new Boolean(val));
    }

    public void setAttr(String name, boolean[] val) {
        this.setAttr(name, (Object)val);
    }

    public void setAttr(String name, byte val) {
        this.setAttr(name, new Byte(val));
    }

    public void setAttr(String name, byte[] val) {
        this.setAttr(name, (Object)val);
    }

    public void setAttr(String name, char val) {
        this.setAttr(name, new Character(val));
    }

    public void setAttr(String name, char[] val) {
        this.setAttr(name, (Object)val);
    }

    public void setAttr(String name, short val) {
        this.setAttr(name, new Short(val));
    }

    public void setAttr(String name, short[] val) {
        this.setAttr(name, (Object)val);
    }

    public void setAttr(String name, int val) {
        this.setAttr(name, new Integer(val));
    }

    public void setAttr(String name, int[] val) {
        this.setAttr(name, (Object)val);
    }

    public void setAttr(String name, long val) {
        this.setAttr(name, new Long(val));
    }

    public void setAttr(String name, long[] val) {
        this.setAttr(name, (Object)val);
    }

    public void setAttr(String name, float val) {
        this.setAttr(name, new Float(val));
    }

    public void setAttr(String name, float[] val) {
        this.setAttr(name, (Object)val);
    }

    public void setAttr(String name, double val) {
        this.setAttr(name, new Double(val));
    }

    public void setAttr(String name, double[] val) {
        this.setAttr(name, (Object)val);
    }

    public void setAttr(String name, String val) {
        this.setAttr(name, new String(val));
    }

    public void setAttr(String name, String[] val) {
        this.setAttr(name, (Object)val);
    }

    public void setAttr(String name, Atom[] val) {
        this.setAttr(name, (Object)val);
    }

    public AttributeInfo[] getAttributeInfo() {
        AttributeInfo[] ret = new AttributeInfo[this._attributes.size()];
        for (int i = 0; i < this._attributes.size(); ++i) {
            ret[i] = (AttributeInfo)this._attributes.elementAt(i);
        }
        return ret;
    }

    protected static void bail(String errormsg) {
        MaxObject.error(errormsg);
        throw new MaxRuntimeException();
    }

    private void _post_message_helpers() {
        String method_suffix = "Helper";
        Method[] meths = this.getClass().getMethods();
        MaxObject.post("--" + this.getClass().getName() + " responds to:");
        for (int i = 0; i < meths.length; ++i) {
            if (!Arrays.equals(meths[i].getParameterTypes(), GIMME_PARAM_TYPE) || !this._is_mxj_callable_method(meths[i])) continue;
            try {
                Method m = this.getClass().getMethod(meths[i].getName() + method_suffix, null);
                String help_mess = (String)m.invoke((Object)this, null);
                MaxObject.post("\t" + meths[i].getName() + ":  " + help_mess);
                continue;
            }
            catch (NoSuchMethodException nsme) {
                MaxObject.post("\t" + meths[i].getName() + ":");
                continue;
            }
            catch (IllegalAccessException iae) {
                MaxObject.showException("Illegal access to " + meths[i].getName() + method_suffix, iae);
                continue;
            }
            catch (IllegalArgumentException iare) {
                MaxObject.showException("Illegal argument", iare);
                continue;
            }
            catch (InvocationTargetException ite) {
                MaxObject.showException(ite);
            }
        }
        MaxObject.post("--");
    }

    public void gc() {
        System.gc();
    }

    public void zap() {
        MXJClassLoader cl = MXJClassLoader.getInstance();
        if (cl != null) {
            cl.zap();
        }
    }

    static {
        System.setErr(ErrorStream.getErrorStream());
        System.setOut(PostStream.getPostStream());
        NO_INLETS = new int[0];
        NO_OUTLETS = new int[0];
        EMPTY_STRING_ARRAY = new String[0];
    }

    class AttributeEntry {
        AttributeInfo ai;
        Method getterM;
        Method setterM;
        Field f;

        AttributeEntry(AttributeInfo attinfo, Method getter, Method setter, Field field) {
            this.ai = attinfo;
            this.f = field;
            this.getterM = getter;
            this.setterM = setter;
        }
    }
}

