/*
 * Decompiled with CFR 0.152.
 */
package jode.flow;

import java.io.IOException;
import jode.AssertError;
import jode.decompiler.TabbedPrintWriter;
import jode.expr.Expression;
import jode.flow.CombineIfGotoExpressions;
import jode.flow.CreateIfThenElseOperator;
import jode.flow.EmptyBlock;
import jode.flow.InstructionContainer;
import jode.flow.Jump;
import jode.flow.StructuredBlock;
import jode.flow.VariableStack;

public class ConditionalBlock
extends InstructionContainer {
    VariableStack stack;
    EmptyBlock trueBlock;

    public void checkConsistent() {
        super.checkConsistent();
        if (this.trueBlock.jump == null || !(this.trueBlock instanceof EmptyBlock)) {
            throw new AssertError("Inconsistency");
        }
    }

    public StructuredBlock[] getSubBlocks() {
        return new StructuredBlock[]{this.trueBlock};
    }

    public boolean replaceSubBlock(StructuredBlock structuredBlock, StructuredBlock structuredBlock2) {
        throw new AssertError("replaceSubBlock on ConditionalBlock");
    }

    public VariableStack mapStackToLocal(VariableStack variableStack) {
        VariableStack variableStack2;
        int n = this.instr.getFreeOperandCount();
        if (n > 0) {
            this.stack = variableStack.peek(n);
            variableStack2 = variableStack.pop(n);
        } else {
            variableStack2 = variableStack;
        }
        this.trueBlock.jump.stackMap = variableStack2;
        if (this.jump != null) {
            this.jump.stackMap = variableStack2;
            return null;
        }
        return variableStack2;
    }

    public void removePush() {
        if (this.stack != null) {
            this.instr = this.stack.mergeIntoExpression(this.instr);
        }
        this.trueBlock.removePush();
    }

    public void dumpInstruction(TabbedPrintWriter tabbedPrintWriter) throws IOException {
        tabbedPrintWriter.print("IF (");
        this.instr.dumpExpression(0, tabbedPrintWriter);
        tabbedPrintWriter.println(")");
        tabbedPrintWriter.tab();
        this.trueBlock.dumpSource(tabbedPrintWriter);
        tabbedPrintWriter.untab();
    }

    public boolean doTransformations() {
        StructuredBlock structuredBlock = this.flowBlock.lastModified;
        return super.doTransformations() || CombineIfGotoExpressions.transform(this, structuredBlock) || CreateIfThenElseOperator.createFunny(this, structuredBlock);
    }

    public ConditionalBlock(Expression expression, Jump jump, Jump jump2) {
        super(expression, jump2);
        this.trueBlock = new EmptyBlock(jump);
        this.trueBlock.outer = this;
    }

    public ConditionalBlock(Expression expression) {
        super(expression);
        this.trueBlock = new EmptyBlock();
        this.trueBlock.outer = this;
    }
}

