/*
 * Decompiled with CFR 0.152.
 */
package jode.flow;

import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import jode.AssertError;
import jode.GlobalOptions;
import jode.decompiler.LocalInfo;
import jode.expr.Expression;
import jode.expr.LocalLoadOperator;
import jode.expr.LocalStoreOperator;
import jode.expr.MonitorExitOperator;
import jode.expr.NopOperator;
import jode.expr.Operator;
import jode.expr.StoreInstruction;
import jode.flow.BreakBlock;
import jode.flow.CatchBlock;
import jode.flow.DescriptionBlock;
import jode.flow.EmptyBlock;
import jode.flow.FinallyBlock;
import jode.flow.FlowBlock;
import jode.flow.InstructionBlock;
import jode.flow.JsrBlock;
import jode.flow.Jump;
import jode.flow.LoopBlock;
import jode.flow.RetBlock;
import jode.flow.ReturnBlock;
import jode.flow.SequentialBlock;
import jode.flow.SpecialBlock;
import jode.flow.StructuredBlock;
import jode.flow.SynchronizedBlock;
import jode.flow.ThrowBlock;
import jode.flow.TryBlock;
import jode.type.Type;

public class TransformExceptionHandlers {
    SortedSet handlers = new TreeSet();

    public void addHandler(FlowBlock flowBlock, int n, FlowBlock flowBlock2, Type type) {
        this.handlers.add(new Handler(flowBlock, n, flowBlock2, type));
    }

    static void mergeTryCatch(FlowBlock flowBlock, FlowBlock flowBlock2) {
        if ((GlobalOptions.debuggingFlags & 0x20) != 0) {
            GlobalOptions.err.println("mergeTryCatch(" + flowBlock.getAddr() + ", " + flowBlock2.getAddr() + ")");
        }
        flowBlock.updateInOutCatch(flowBlock2);
        flowBlock.mergeSuccessors(flowBlock2);
        flowBlock.mergeAddr(flowBlock2);
    }

    static void analyzeCatchBlock(Type type, FlowBlock flowBlock, FlowBlock flowBlock2) {
        TransformExceptionHandlers.mergeTryCatch(flowBlock, flowBlock2);
        CatchBlock catchBlock = new CatchBlock(type);
        ((TryBlock)flowBlock.block).addCatchBlock(catchBlock);
        catchBlock.setCatchBlock(flowBlock2.block);
    }

    boolean transformSubRoutine(StructuredBlock structuredBlock) {
        Object object;
        StructuredBlock structuredBlock2 = structuredBlock;
        if (structuredBlock2 instanceof SequentialBlock) {
            structuredBlock2 = structuredBlock.getSubBlocks()[0];
        }
        LocalInfo localInfo = null;
        if (structuredBlock2 instanceof SpecialBlock) {
            object = (SpecialBlock)structuredBlock2;
            if (((SpecialBlock)object).type != SpecialBlock.POP || ((SpecialBlock)object).count != 1) {
                return false;
            }
        } else if (structuredBlock2 instanceof InstructionBlock) {
            object = ((InstructionBlock)structuredBlock2).getInstruction();
            if (object instanceof StoreInstruction && ((StoreInstruction)object).getLValue() instanceof LocalStoreOperator) {
                LocalStoreOperator localStoreOperator = (LocalStoreOperator)((StoreInstruction)object).getLValue();
                localInfo = localStoreOperator.getLocalInfo();
                object = ((StoreInstruction)object).getSubExpressions()[1];
            }
            if (!(object instanceof NopOperator)) {
                return false;
            }
        } else {
            return false;
        }
        structuredBlock2.removeBlock();
        while (structuredBlock instanceof SequentialBlock) {
            structuredBlock = structuredBlock.getSubBlocks()[1];
        }
        if (structuredBlock instanceof RetBlock && ((RetBlock)structuredBlock).local.equals(localInfo)) {
            structuredBlock.removeBlock();
        }
        return true;
    }

    private void removeReturnLocal(ReturnBlock returnBlock) {
        StructuredBlock structuredBlock = TransformExceptionHandlers.getPredecessor(returnBlock);
        if (!(structuredBlock instanceof InstructionBlock)) {
            return;
        }
        Expression expression = ((InstructionBlock)structuredBlock).getInstruction();
        if (!(expression instanceof StoreInstruction)) {
            return;
        }
        Expression expression2 = returnBlock.getInstruction();
        if (!(expression2 instanceof LocalLoadOperator) || !((StoreInstruction)expression).lvalueMatches((LocalLoadOperator)expression2)) {
            return;
        }
        Expression expression3 = ((StoreInstruction)expression).getSubExpressions()[1];
        returnBlock.setInstruction(expression3);
        returnBlock.replace(returnBlock.outer);
    }

    private void removeJSR(FlowBlock flowBlock, FlowBlock flowBlock2) {
        Jump jump = flowBlock.removeJumps(flowBlock2);
        while (jump != null) {
            StructuredBlock structuredBlock;
            StructuredBlock structuredBlock2 = jump.prev;
            structuredBlock2.removeJump();
            if (structuredBlock2 instanceof EmptyBlock && structuredBlock2.outer instanceof JsrBlock && ((JsrBlock)structuredBlock2.outer).isGood()) {
                structuredBlock = structuredBlock2.outer.getNextBlock();
                structuredBlock2.outer.removeBlock();
                if (structuredBlock instanceof ReturnBlock) {
                    this.removeReturnLocal((ReturnBlock)structuredBlock);
                }
            } else {
                structuredBlock = new DescriptionBlock("ERROR: invalid jump to finally block!");
                structuredBlock2.appendBlock(structuredBlock);
            }
            jump = jump.next;
        }
    }

    private static StructuredBlock getPredecessor(StructuredBlock structuredBlock) {
        if (structuredBlock.outer instanceof SequentialBlock) {
            SequentialBlock sequentialBlock = (SequentialBlock)structuredBlock.outer;
            if (sequentialBlock.subBlocks[1] == structuredBlock) {
                return sequentialBlock.subBlocks[0];
            }
            if (sequentialBlock.outer instanceof SequentialBlock) {
                return sequentialBlock.outer.getSubBlocks()[0];
            }
        }
        return null;
    }

    private static int getMonitorExitSlot(StructuredBlock structuredBlock) {
        MonitorExitOperator monitorExitOperator;
        Expression expression;
        if (structuredBlock instanceof InstructionBlock && (expression = ((InstructionBlock)structuredBlock).getInstruction()) instanceof MonitorExitOperator && (monitorExitOperator = (MonitorExitOperator)expression).getFreeOperandCount() == 0 && monitorExitOperator.getSubExpressions()[0] instanceof LocalLoadOperator) {
            return ((LocalLoadOperator)monitorExitOperator.getSubExpressions()[0]).getLocalInfo().getSlot();
        }
        return -1;
    }

    private boolean isMonitorExitSubRoutine(FlowBlock flowBlock, LocalInfo localInfo) {
        return this.transformSubRoutine(flowBlock.block) && TransformExceptionHandlers.getMonitorExitSlot(flowBlock.block) == localInfo.getSlot();
    }

    private static StructuredBlock skipFinExitChain(StructuredBlock structuredBlock) {
        StructuredBlock structuredBlock2 = structuredBlock instanceof ReturnBlock ? TransformExceptionHandlers.getPredecessor(structuredBlock) : structuredBlock;
        StructuredBlock structuredBlock3 = null;
        while (structuredBlock2 instanceof JsrBlock || TransformExceptionHandlers.getMonitorExitSlot(structuredBlock2) >= 0) {
            structuredBlock3 = structuredBlock2;
            structuredBlock2 = TransformExceptionHandlers.getPredecessor(structuredBlock2);
        }
        return structuredBlock3;
    }

    /*
     * Unable to fully structure code
     */
    private void checkAndRemoveJSR(FlowBlock var1_1, FlowBlock var2_2, int var3_3, int var4_4) {
        var5_5 = var1_1.getSuccessors().iterator();
        block0: while (var5_5.hasNext()) {
            var6_6 = (FlowBlock)var5_5.next();
            if (var6_6 == var2_2) continue;
            var7_7 = true;
            var8_8 = var1_1.getJumps(var6_6);
            while (var8_8 != null) {
                block10: {
                    var9_9 = var8_8.prev;
                    if (var9_9 instanceof ThrowBlock || var9_9 instanceof EmptyBlock && var9_9.outer instanceof JsrBlock) break block10;
                    var10_10 = TransformExceptionHandlers.skipFinExitChain(var9_9);
                    if (!(var10_10 instanceof JsrBlock)) ** GOTO lbl-1000
                    var11_11 = (JsrBlock)var10_10;
                    var12_12 = var11_11.innerBlock;
                    if (var12_12 instanceof EmptyBlock && var12_12.jump != null && var12_12.jump.destination == var2_2) {
                        var11_11.setGood(true);
                    } else lbl-1000:
                    // 2 sources

                    {
                        if (var10_10 == null && var7_7 && var8_8.destination.predecessors.size() == 1 && var8_8.destination.getAddr() >= var3_3 && var8_8.destination.getNextAddr() <= var4_4) {
                            var8_8.destination.analyze(var3_3, var4_4);
                            var11_11 = var8_8.destination.block;
                            if (var11_11 instanceof SequentialBlock) {
                                var11_11 = var11_11.getSubBlocks()[0];
                            }
                            if (var11_11 instanceof JsrBlock && var11_11.getSubBlocks()[0] instanceof EmptyBlock && var11_11.getSubBlocks()[0].jump.destination == var2_2) {
                                var12_12 = var11_11.getSubBlocks()[0];
                                var8_8.destination.removeSuccessor(var12_12.jump);
                                var12_12.removeJump();
                                var11_11.removeBlock();
                                continue block0;
                            }
                        }
                        var11_11 = new DescriptionBlock("ERROR: no jsr to finally");
                        if (var10_10 != null) {
                            var10_10.prependBlock(var11_11);
                        } else {
                            var9_9.appendBlock(var11_11);
                            var11_11.moveJump(var9_9.jump);
                        }
                    }
                }
                var8_8 = var8_8.next;
                var7_7 = false;
            }
        }
        if (var1_1.getSuccessors().contains(var2_2)) {
            this.removeJSR(var1_1, var2_2);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void checkAndRemoveMonitorExit(FlowBlock var1_1, LocalInfo var2_2, int var3_3, int var4_4) {
        var5_5 = null;
        var6_6 = var1_1.getSuccessors().iterator();
        block0: while (var6_6.hasNext()) {
            var7_7 = true;
            var8_8 = (FlowBlock)var6_6.next();
            var9_9 = var1_1.getJumps(var8_8);
            while (var9_9 != null) {
                block16: {
                    block18: {
                        block17: {
                            var10_10 = var9_9.prev;
                            if (var10_10 instanceof ThrowBlock || var10_10 instanceof EmptyBlock && var10_10.outer instanceof JsrBlock) break block16;
                            var11_11 = TransformExceptionHandlers.skipFinExitChain(var10_10);
                            if (!(var11_11 instanceof JsrBlock)) break block17;
                            var12_12 = (JsrBlock)var11_11;
                            var13_13 = var12_12.innerBlock;
                            if (!(var13_13 instanceof EmptyBlock) || var13_13.jump == null) break block18;
                            var14_14 = var13_13.jump.destination;
                            if (var5_5 == null && var14_14.getAddr() >= var3_3 && var14_14.getNextAddr() <= var4_4) {
                                var14_14.analyze(var3_3, var4_4);
                                if (this.isMonitorExitSubRoutine(var14_14, var2_2)) {
                                    var5_5 = var14_14;
                                }
                            }
                            if (var14_14 != var5_5) break block18;
                            var12_12.setGood(true);
                            break block16;
                        }
                        if (TransformExceptionHandlers.getMonitorExitSlot(var11_11) == var2_2.getSlot()) {
                            var11_11.removeBlock();
                            if (var10_10 instanceof ReturnBlock) {
                                this.removeReturnLocal((ReturnBlock)var10_10);
                                ** GOTO lbl59
                            } else {
                                ** GOTO lbl31
                            }
                        }
                        break block18;
lbl31:
                        // 2 sources

                        break block16;
                    }
                    if (var11_11 == null && var7_7 && var8_8.predecessors.size() == 1 && var8_8.getAddr() >= var3_3 && var8_8.getNextAddr() <= var4_4) {
                        var8_8.analyze(var3_3, var4_4);
                        var12_12 = var8_8.block;
                        if (var12_12 instanceof SequentialBlock) {
                            var12_12 = var12_12.getSubBlocks()[0];
                        }
                        if (var12_12 instanceof JsrBlock && var12_12.getSubBlocks()[0] instanceof EmptyBlock) {
                            var13_13 = var12_12.getSubBlocks()[0];
                            var14_14 = var13_13.jump.destination;
                            if (var5_5 == null && var14_14.getAddr() >= var3_3 && var14_14.getNextAddr() <= var4_4) {
                                var14_14.analyze(var3_3, var4_4);
                                if (this.isMonitorExitSubRoutine(var14_14, var2_2)) {
                                    var5_5 = var14_14;
                                }
                            }
                            if (var5_5 == var14_14) {
                                var8_8.removeSuccessor(var13_13.jump);
                                var13_13.removeJump();
                                var12_12.removeBlock();
                                continue block0;
                            }
                        }
                        if (TransformExceptionHandlers.getMonitorExitSlot(var12_12) == var2_2.getSlot()) {
                            var12_12.removeBlock();
                            continue block0;
                        }
                    }
                    var12_12 = new DescriptionBlock("ERROR: no monitorexit");
                    var10_10.appendBlock(var12_12);
                    var12_12.moveJump(var9_9);
                }
                var9_9 = var9_9.next;
                var7_7 = false;
            }
        }
        if (var5_5 != null) {
            if (var1_1.getSuccessors().contains(var5_5)) {
                this.removeJSR(var1_1, var5_5);
            }
            if (var5_5.predecessors.size() == 0) {
                var1_1.mergeAddr(var5_5);
            }
        }
    }

    private StoreInstruction getExceptionStore(StructuredBlock structuredBlock) {
        if (!(structuredBlock instanceof SequentialBlock) || !(structuredBlock.getSubBlocks()[0] instanceof InstructionBlock)) {
            return null;
        }
        Expression expression = ((InstructionBlock)structuredBlock.getSubBlocks()[0]).getInstruction();
        if (!(expression instanceof StoreInstruction)) {
            return null;
        }
        StoreInstruction storeInstruction = (StoreInstruction)expression;
        if (!(storeInstruction.getLValue() instanceof LocalStoreOperator) || !(storeInstruction.getSubExpressions()[1] instanceof NopOperator)) {
            return null;
        }
        return storeInstruction;
    }

    private boolean analyzeSynchronized(FlowBlock flowBlock, FlowBlock flowBlock2, int n) {
        StructuredBlock structuredBlock = flowBlock2.block;
        StoreInstruction storeInstruction = this.getExceptionStore(structuredBlock);
        if (storeInstruction != null) {
            structuredBlock = structuredBlock.getSubBlocks()[1];
        }
        if (!(structuredBlock instanceof SequentialBlock) || !(structuredBlock.getSubBlocks()[0] instanceof InstructionBlock)) {
            return false;
        }
        Expression expression = ((InstructionBlock)structuredBlock.getSubBlocks()[0]).getInstruction();
        if (!(expression instanceof MonitorExitOperator && expression.getFreeOperandCount() == 0 && ((MonitorExitOperator)expression).getSubExpressions()[0] instanceof LocalLoadOperator && structuredBlock.getSubBlocks()[1] instanceof ThrowBlock)) {
            return false;
        }
        Expression expression2 = ((ThrowBlock)structuredBlock.getSubBlocks()[1]).getInstruction();
        if (storeInstruction != null ? !(expression2 instanceof Operator) || !storeInstruction.lvalueMatches((Operator)expression2) : !(expression2 instanceof NopOperator)) {
            return false;
        }
        flowBlock2.removeSuccessor(structuredBlock.getSubBlocks()[1].jump);
        TransformExceptionHandlers.mergeTryCatch(flowBlock, flowBlock2);
        MonitorExitOperator monitorExitOperator = (MonitorExitOperator)((InstructionBlock)structuredBlock.getSubBlocks()[0]).instr;
        LocalInfo localInfo = ((LocalLoadOperator)monitorExitOperator.getSubExpressions()[0]).getLocalInfo();
        if ((GlobalOptions.debuggingFlags & 0x20) != 0) {
            GlobalOptions.err.println("analyzeSynchronized(" + flowBlock.getAddr() + "," + flowBlock.getNextAddr() + "," + n + ")");
        }
        this.checkAndRemoveMonitorExit(flowBlock, localInfo, flowBlock.getNextAddr(), n);
        SynchronizedBlock synchronizedBlock = new SynchronizedBlock(localInfo);
        TryBlock tryBlock = (TryBlock)flowBlock.block;
        synchronizedBlock.replace(tryBlock);
        synchronizedBlock.moveJump(tryBlock.jump);
        synchronizedBlock.setBodyBlock(tryBlock.subBlocks.length == 1 ? tryBlock.subBlocks[0] : tryBlock);
        flowBlock.lastModified = synchronizedBlock;
        return true;
    }

    private void mergeFinallyBlock(FlowBlock flowBlock, FlowBlock flowBlock2, StructuredBlock structuredBlock) {
        StructuredBlock structuredBlock2;
        StructuredBlock structuredBlock3 = (TryBlock)flowBlock.block;
        if (structuredBlock3.getSubBlocks()[0] instanceof TryBlock) {
            structuredBlock2 = (TryBlock)structuredBlock3.getSubBlocks()[0];
            ((TryBlock)structuredBlock2).gen = structuredBlock3.gen;
            structuredBlock2.replace(structuredBlock3);
            structuredBlock3 = structuredBlock2;
            flowBlock.lastModified = structuredBlock3;
            flowBlock.block = structuredBlock3;
        }
        TransformExceptionHandlers.mergeTryCatch(flowBlock, flowBlock2);
        structuredBlock2 = new FinallyBlock();
        ((FinallyBlock)structuredBlock2).setCatchBlock(structuredBlock);
        structuredBlock3.addCatchBlock(structuredBlock2);
    }

    private boolean analyzeFinally(FlowBlock flowBlock, FlowBlock flowBlock2, int n) {
        StructuredBlock structuredBlock;
        StructuredBlock structuredBlock2 = flowBlock2.block;
        StoreInstruction storeInstruction = this.getExceptionStore(structuredBlock2);
        if (storeInstruction == null) {
            return false;
        }
        if (!((structuredBlock2 = structuredBlock2.getSubBlocks()[1]) instanceof SequentialBlock)) {
            return false;
        }
        StructuredBlock structuredBlock3 = null;
        if (structuredBlock2.getSubBlocks()[0] instanceof LoopBlock) {
            structuredBlock = (LoopBlock)structuredBlock2.getSubBlocks()[0];
            if (structuredBlock.type == 1 && structuredBlock.cond == LoopBlock.FALSE && structuredBlock.bodyBlock instanceof SequentialBlock && this.transformSubRoutine(structuredBlock2.getSubBlocks()[1])) {
                structuredBlock3 = structuredBlock2.getSubBlocks()[1];
                structuredBlock2 = (SequentialBlock)structuredBlock.bodyBlock;
            }
        }
        if (!(structuredBlock2 instanceof SequentialBlock && structuredBlock2.getSubBlocks()[0] instanceof JsrBlock && structuredBlock2.getSubBlocks()[1] instanceof ThrowBlock)) {
            return false;
        }
        structuredBlock = (JsrBlock)structuredBlock2.getSubBlocks()[0];
        ThrowBlock throwBlock = (ThrowBlock)structuredBlock2.getSubBlocks()[1];
        if (!(throwBlock.getInstruction() instanceof Operator) || !storeInstruction.lvalueMatches((Operator)throwBlock.getInstruction())) {
            return false;
        }
        if (structuredBlock3 != null) {
            if (!(((JsrBlock)structuredBlock).innerBlock instanceof BreakBlock)) {
                return false;
            }
            structuredBlock2 = structuredBlock3;
            Object var9_9 = null;
            flowBlock2.removeSuccessor(throwBlock.jump);
        } else {
            if (!(((JsrBlock)structuredBlock).innerBlock instanceof EmptyBlock)) {
                return false;
            }
            structuredBlock3 = ((JsrBlock)structuredBlock).innerBlock;
            FlowBlock flowBlock3 = structuredBlock3.jump.destination;
            flowBlock2.removeSuccessor(throwBlock.jump);
            this.checkAndRemoveJSR(flowBlock, flowBlock3, flowBlock.getNextAddr(), n);
            while (flowBlock3.analyze(flowBlock.getNextAddr(), n)) {
            }
            if (flowBlock3.predecessors.size() == 1) {
                flowBlock2.removeSuccessor(structuredBlock3.jump);
                flowBlock3.mergeAddr(flowBlock2);
                flowBlock2 = flowBlock3;
                if (!this.transformSubRoutine(flowBlock3.block)) {
                    structuredBlock3 = flowBlock3.block;
                    DescriptionBlock descriptionBlock = new DescriptionBlock("ERROR: Missing return address handling");
                    StructuredBlock structuredBlock4 = flowBlock3.block;
                    descriptionBlock.replace(structuredBlock3);
                    descriptionBlock.appendBlock(structuredBlock3);
                }
                structuredBlock3 = flowBlock3.block;
            }
        }
        this.mergeFinallyBlock(flowBlock, flowBlock2, structuredBlock3);
        return true;
    }

    private boolean analyzeSpecialFinally(FlowBlock flowBlock, FlowBlock flowBlock2, int n) {
        Object object;
        FlowBlock flowBlock3;
        StructuredBlock structuredBlock;
        StructuredBlock structuredBlock2 = flowBlock2.block;
        StructuredBlock structuredBlock3 = structuredBlock = structuredBlock2 instanceof SequentialBlock ? structuredBlock2.getSubBlocks()[0] : structuredBlock2;
        if (!(structuredBlock instanceof SpecialBlock) || ((SpecialBlock)structuredBlock).type != SpecialBlock.POP || ((SpecialBlock)structuredBlock).count != 1) {
            return false;
        }
        flowBlock.lastModified = flowBlock.block.getSubBlocks()[0];
        if (structuredBlock2 instanceof SequentialBlock) {
            structuredBlock2 = structuredBlock2.getSubBlocks()[1];
            flowBlock3 = null;
        } else {
            structuredBlock2 = new EmptyBlock();
            structuredBlock2.moveJump(structuredBlock.jump);
            flowBlock3 = structuredBlock2.jump.destination;
            if (flowBlock.getSuccessors().contains(flowBlock3)) {
                object = flowBlock.removeJumps(flowBlock3);
                object = flowBlock.resolveSomeJumps((Jump)object, flowBlock3);
                flowBlock.resolveRemaining((Jump)object);
            }
        }
        object = flowBlock.getSuccessors();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Jump jump;
            FlowBlock flowBlock4 = (FlowBlock)iterator.next();
            if (flowBlock4 != FlowBlock.END_OF_METHOD && flowBlock4.block instanceof EmptyBlock && flowBlock4.block.jump.destination == flowBlock3) {
                jump = flowBlock.removeJumps(flowBlock4);
                jump = flowBlock.resolveSomeJumps(jump, flowBlock3);
                flowBlock.resolveRemaining(jump);
                if (flowBlock4.predecessors.size() != 0) continue;
                flowBlock4.removeJumps(flowBlock3);
                flowBlock.mergeAddr(flowBlock4);
                continue;
            }
            jump = flowBlock.getJumps(flowBlock4);
            while (jump != null) {
                if (!(jump.prev instanceof ThrowBlock)) {
                    DescriptionBlock descriptionBlock = new DescriptionBlock("ERROR: doesn't go through finally block!");
                    if (jump.prev instanceof ReturnBlock) {
                        descriptionBlock.replace(jump.prev);
                        descriptionBlock.appendBlock(jump.prev);
                    } else {
                        jump.prev.appendBlock(descriptionBlock);
                        descriptionBlock.moveJump(jump);
                    }
                }
                jump = jump.next;
            }
        }
        this.mergeFinallyBlock(flowBlock, flowBlock2, structuredBlock2);
        flowBlock.lastModified = structuredBlock2;
        return true;
    }

    void checkTryCatchOrder() {
        Handler handler = null;
        Iterator iterator = this.handlers.iterator();
        while (iterator.hasNext()) {
            Handler handler2 = (Handler)iterator.next();
            int n = handler2.start.getAddr();
            int n2 = handler2.endAddr;
            int n3 = handler2.handler.getAddr();
            if (n >= n2 || n3 < n2) {
                throw new AssertError("ExceptionHandler order failed: not " + n + " < " + n2 + " <= " + n3);
            }
            if (handler != null && (handler.start.getAddr() != n || handler.endAddr != n2) && n2 > handler.start.getAddr() && n2 < handler.endAddr) {
                throw new AssertError("Exception handlers ranges are intersecting: [" + handler.start.getAddr() + ", " + handler.endAddr + "] and [" + n + ", " + n2 + "].");
            }
            handler = handler2;
        }
    }

    public void analyze() {
        this.checkTryCatchOrder();
        Iterator iterator = this.handlers.iterator();
        Handler handler = null;
        Handler handler2 = iterator.hasNext() ? (Handler)iterator.next() : null;
        while (handler2 != null) {
            Object object;
            Object object2;
            boolean bl;
            Object object3;
            Handler handler3 = handler;
            handler = handler2;
            handler2 = iterator.hasNext() ? (Handler)iterator.next() : null;
            int n = Integer.MAX_VALUE;
            if (handler2 != null && handler2.endAddr > handler.endAddr) {
                n = handler2.endAddr;
            }
            FlowBlock flowBlock = handler.start;
            flowBlock.checkConsistent();
            if (handler3 == null || handler.type == null || handler3.start.getAddr() != handler.start.getAddr() || handler3.endAddr != handler.endAddr) {
                if ((GlobalOptions.debuggingFlags & 0x20) != 0) {
                    GlobalOptions.err.println("analyzeTry(" + handler.start.getAddr() + ", " + handler.endAddr + ")");
                }
                while (flowBlock.analyze(flowBlock.getAddr(), handler.endAddr)) {
                }
                object3 = new TryBlock(flowBlock);
            } else if (!(flowBlock.block instanceof TryBlock)) {
                throw new AssertError("no TryBlock");
            }
            object3 = handler.handler;
            boolean bl2 = bl = ((FlowBlock)object3).predecessors.size() != 0;
            if (!bl && handler2 != null) {
                object2 = this.handlers.tailSet(handler2).iterator();
                while (object2.hasNext()) {
                    object = (Handler)object2.next();
                    if (((Handler)object).handler != object3) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                object2 = new EmptyBlock(new Jump((FlowBlock)object3));
                object = new FlowBlock(((FlowBlock)object3).method, ((FlowBlock)object3).getAddr());
                ((FlowBlock)object).appendBlock((StructuredBlock)object2, 0);
                ((FlowBlock)object3).prevByAddr.nextByAddr = object;
                ((FlowBlock)object).prevByAddr = ((FlowBlock)object3).prevByAddr;
                ((FlowBlock)object).nextByAddr = object3;
                ((FlowBlock)object3).prevByAddr = object;
                object3 = object;
            } else {
                if ((GlobalOptions.debuggingFlags & 0x20) != 0) {
                    GlobalOptions.err.println("analyzeCatch(" + ((FlowBlock)object3).getAddr() + ", " + n + ")");
                }
                while (((FlowBlock)object3).analyze(((FlowBlock)object3).getAddr(), n)) {
                }
            }
            if (handler.type != null) {
                TransformExceptionHandlers.analyzeCatchBlock(handler.type, flowBlock, (FlowBlock)object3);
            } else if (!(this.analyzeSynchronized(flowBlock, (FlowBlock)object3, n) || this.analyzeFinally(flowBlock, (FlowBlock)object3, n) || this.analyzeSpecialFinally(flowBlock, (FlowBlock)object3, n))) {
                TransformExceptionHandlers.analyzeCatchBlock(Type.tObject, flowBlock, (FlowBlock)object3);
            }
            flowBlock.checkConsistent();
            if ((GlobalOptions.debuggingFlags & 0x20) == 0) continue;
            GlobalOptions.err.println("analyzeTryCatch(" + flowBlock.getAddr() + ", " + flowBlock.getNextAddr() + ") done.");
        }
    }

    static class Handler
    implements Comparable {
        FlowBlock start;
        int endAddr;
        FlowBlock handler;
        Type type;

        public int compareTo(Object object) {
            Handler handler = (Handler)object;
            if (this.start.getAddr() != handler.start.getAddr()) {
                return handler.start.getAddr() - this.start.getAddr();
            }
            if (this.endAddr != handler.endAddr) {
                return this.endAddr - handler.endAddr;
            }
            if (this.handler.getAddr() != handler.handler.getAddr()) {
                return this.handler.getAddr() - handler.handler.getAddr();
            }
            if (this.type == handler.type) {
                return 0;
            }
            if (this.type == null) {
                return -1;
            }
            if (handler.type == null) {
                return 1;
            }
            return this.type.getTypeSignature().compareTo(handler.type.getTypeSignature());
        }

        public Handler(FlowBlock flowBlock, int n, FlowBlock flowBlock2, Type type) {
            this.start = flowBlock;
            this.endAddr = n;
            this.handler = flowBlock2;
            this.type = type;
        }
    }
}

