/*
 * Decompiled with CFR 0.152.
 */
package com.cycling74.util;

import com.cycling74.util.Async;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.net.URL;

public class ImageUtilities {
    private static int sID = 0;
    private static final Component sComponent = new Component(){};
    private static final MediaTracker sTracker = new MediaTracker(sComponent);

    private ImageUtilities() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean waitForImage(Image image) {
        int id;
        Component component = sComponent;
        synchronized (component) {
            id = sID++;
        }
        sTracker.addImage(image, id);
        try {
            sTracker.waitForID(id);
        }
        catch (InterruptedException ie) {
            return false;
        }
        return !sTracker.isErrorID(id);
    }

    public static BufferedImage makeBufferedImage(Image image) {
        return ImageUtilities.makeBufferedImage(image, 1);
    }

    public static BufferedImage makeBufferedImage(Image image, int imageType) {
        if (!ImageUtilities.waitForImage(image)) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), imageType);
        Graphics2D g2 = bufferedImage.createGraphics();
        g2.drawImage(image, null, null);
        return bufferedImage;
    }

    public static Image blockingLoad(URL url) {
        Image image = Toolkit.getDefaultToolkit().getImage(url);
        if (!ImageUtilities.waitForImage(image)) {
            return null;
        }
        return image;
    }

    public static void setVisible(final Component comp, final boolean vis) {
        Async.quick(new Runnable(){

            public void run() {
                comp.setVisible(vis);
            }
        });
    }
}

