/*
 * Decompiled with CFR 0.152.
 */
package jode.flow;

import java.lang.reflect.Modifier;
import jode.GlobalOptions;
import jode.bytecode.ClassInfo;
import jode.bytecode.InnerClassInfo;
import jode.bytecode.MethodInfo;
import jode.decompiler.ClassAnalyzer;
import jode.decompiler.FieldAnalyzer;
import jode.decompiler.MethodAnalyzer;
import jode.decompiler.Options;
import jode.decompiler.OuterValueListener;
import jode.decompiler.OuterValues;
import jode.expr.Expression;
import jode.expr.FieldOperator;
import jode.expr.IIncOperator;
import jode.expr.InvokeOperator;
import jode.expr.LocalLoadOperator;
import jode.expr.LocalStoreOperator;
import jode.expr.LocalVarOperator;
import jode.expr.Operator;
import jode.expr.PutFieldOperator;
import jode.expr.StoreInstruction;
import jode.expr.ThisOperator;
import jode.flow.FlowBlock;
import jode.flow.InstructionBlock;
import jode.flow.SequentialBlock;
import jode.flow.StructuredBlock;
import jode.type.MethodType;
import jode.type.Type;

public class TransformConstructors {
    ClassAnalyzer clazzAnalyzer;
    boolean isStatic;
    MethodAnalyzer[] cons;
    int type0Count;
    int type01Count;
    OuterValues outerValues;

    private int getConstructorType(StructuredBlock structuredBlock) {
        InstructionBlock instructionBlock;
        if (structuredBlock instanceof InstructionBlock) {
            instructionBlock = (InstructionBlock)structuredBlock;
        } else if (structuredBlock instanceof SequentialBlock && structuredBlock.getSubBlocks()[0] instanceof InstructionBlock) {
            instructionBlock = (InstructionBlock)structuredBlock.getSubBlocks()[0];
        } else {
            return 0;
        }
        Expression expression = instructionBlock.getInstruction().simplify();
        if (!(expression instanceof InvokeOperator) || expression.getFreeOperandCount() != 0) {
            return 0;
        }
        InvokeOperator invokeOperator = (InvokeOperator)expression;
        if (!invokeOperator.isConstructor() || !invokeOperator.isSuperOrThis()) {
            return 0;
        }
        Expression expression2 = invokeOperator.getSubExpressions()[0];
        if (!TransformConstructors.isThis(expression2, this.clazzAnalyzer.getClazz())) {
            return 0;
        }
        if (invokeOperator.isThis()) {
            return 2;
        }
        return 1;
    }

    public void lookForConstructorCall() {
        this.type01Count = this.cons.length;
        int n = 0;
        while (n < this.type01Count) {
            int n2;
            MethodAnalyzer methodAnalyzer = this.cons[n];
            FlowBlock flowBlock = this.cons[n].getMethodHeader();
            if (flowBlock == null || !flowBlock.hasNoJumps()) {
                return;
            }
            StructuredBlock structuredBlock = this.cons[n].getMethodHeader().block;
            int n3 = n2 = this.isStatic ? 0 : this.getConstructorType(structuredBlock);
            if ((GlobalOptions.debuggingFlags & 0x200) != 0) {
                GlobalOptions.err.println("constr " + n + ": type" + n2 + " " + structuredBlock);
            }
            switch (n2) {
                case 0: {
                    this.cons[n] = this.cons[this.type0Count];
                    this.cons[this.type0Count++] = methodAnalyzer;
                }
                case 1: {
                    ++n;
                    break;
                }
                case 2: {
                    this.cons[n] = this.cons[--this.type01Count];
                    this.cons[this.type01Count] = methodAnalyzer;
                    break;
                }
            }
        }
    }

    public static boolean isThis(Expression expression, ClassInfo classInfo) {
        return expression instanceof ThisOperator && ((ThisOperator)expression).getClassInfo() == classInfo;
    }

    private void checkAnonymousConstructor() {
        LocalLoadOperator localLoadOperator;
        Object object;
        LocalLoadOperator localLoadOperator2;
        StructuredBlock structuredBlock;
        if (this.isStatic || this.cons.length != 1 || this.type01Count - this.type0Count != 1 || this.clazzAnalyzer.getName() != null) {
            return;
        }
        if ((GlobalOptions.debuggingFlags & 0x200) != 0) {
            GlobalOptions.err.println("checkAnonymousConstructor of " + this.clazzAnalyzer.getClazz());
        }
        if ((structuredBlock = this.cons[0].getMethodHeader().block) instanceof SequentialBlock) {
            structuredBlock = structuredBlock.getSubBlocks()[0];
        }
        InstructionBlock instructionBlock = (InstructionBlock)structuredBlock;
        Expression expression = instructionBlock.getInstruction().simplify();
        InvokeOperator invokeOperator = (InvokeOperator)expression;
        Expression[] expressionArray = invokeOperator.getSubExpressions();
        int n = 1;
        while (n < expressionArray.length) {
            if (!(expressionArray[n] instanceof LocalLoadOperator)) {
                return;
            }
            ++n;
        }
        Type[] typeArray = this.cons[0].getType().getParameterTypes();
        boolean bl = false;
        int n2 = typeArray.length;
        int n3 = 1;
        int n4 = 0;
        while (n4 < typeArray.length - 1) {
            n3 += typeArray[n4].stackSize();
            ++n4;
        }
        n4 = 1;
        if (expressionArray.length > 2 && (localLoadOperator2 = (LocalLoadOperator)expressionArray[1]).getLocalInfo().getSlot() == n3) {
            bl = true;
            ++n4;
            n3 -= typeArray[--n2 - 1].stackSize();
        }
        int n5 = expressionArray.length - 1;
        while (n5 >= n4) {
            object = (LocalLoadOperator)expressionArray[n5];
            if ((GlobalOptions.debuggingFlags & 0x200) != 0) {
                GlobalOptions.err.println("  pos " + n5 + ": " + n3 + "," + ((LocalVarOperator)object).getLocalInfo().getSlot() + "; " + n2);
            }
            if (((LocalVarOperator)object).getLocalInfo().getSlot() != n3) {
                n3 += typeArray[n2 - 1].stackSize();
                break;
            }
            --n5;
            if (--n2 == 0) break;
            n3 -= typeArray[n2 - 1].stackSize();
        }
        object = invokeOperator.getClassAnalyzer();
        OuterValues outerValues = null;
        if (object != null && ((ClassAnalyzer)object).getParent() instanceof MethodAnalyzer) {
            outerValues = ((ClassAnalyzer)object).getOuterValues();
        }
        int n6 = n5 - n4 + 1;
        if ((GlobalOptions.debuggingFlags & 0x200) != 0) {
            GlobalOptions.err.println("  super outer: " + outerValues);
        }
        while (n5 >= n4) {
            localLoadOperator = (LocalLoadOperator)expressionArray[n5];
            if (localLoadOperator.getLocalInfo().getSlot() >= n3) {
                if ((GlobalOptions.debuggingFlags & 0x200) != 0) {
                    GlobalOptions.err.println("  Illegal slot at " + n5 + ":" + localLoadOperator.getLocalInfo().getSlot());
                }
                return;
            }
            --n5;
        }
        if (n6 == 1 && ((ClassAnalyzer)object).getParent() instanceof ClassAnalyzer && this.outerValues.getValueBySlot((localLoadOperator = (LocalLoadOperator)expressionArray[n4]).getLocalInfo().getSlot()) instanceof ThisOperator) {
            n6 = 0;
            this.outerValues.setImplicitOuterClass(true);
        }
        if (n6 > 0) {
            if (outerValues == null || outerValues.getCount() < n6) {
                if ((GlobalOptions.debuggingFlags & 0x200) != 0) {
                    GlobalOptions.err.println("  super outer doesn't match: " + n6);
                }
                return;
            }
            outerValues.setMinCount(n6);
        }
        this.outerValues.setMinCount(n2);
        if (outerValues != null) {
            int n7 = n2 - n6;
            this.outerValues.setCount(outerValues.getCount() + n7);
            TransformConstructors transformConstructors = this;
            if (transformConstructors == null) {
                throw null;
            }
            outerValues.addOuterValueListener(new OuterValueListener(transformConstructors, n7){
                private final /* synthetic */ TransformConstructors this$0;
                private final /* synthetic */ int val$ovdiff;

                public void shrinkingOuterValues(OuterValues outerValues, int n) {
                    this.this$0.outerValues.setCount(n + this.val$ovdiff);
                }
                {
                    this.val$ovdiff = n;
                    this.this$0 = transformConstructors;
                    this.constructor$0(transformConstructors);
                }

                private final void constructor$0(TransformConstructors transformConstructors) {
                }
            });
        } else {
            this.outerValues.setCount(n2);
        }
        if (bl) {
            this.outerValues.setJikesAnonymousInner(true);
        }
        if ((GlobalOptions.debuggingFlags & 0x200) != 0) {
            GlobalOptions.err.println("  succeeded: " + this.outerValues);
        }
        this.cons[0].setAnonymousConstructor(true);
        instructionBlock.removeBlock();
        ++this.type0Count;
    }

    private boolean checkJikesSuper(Expression expression) {
        if (expression instanceof LocalStoreOperator || expression instanceof IIncOperator) {
            return false;
        }
        if (expression instanceof Operator) {
            Expression[] expressionArray = ((Operator)expression).getSubExpressions();
            int n = 0;
            while (n < expressionArray.length) {
                if (!this.checkJikesSuper(expressionArray[n])) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    private Expression renameJikesSuper(Expression expression, MethodAnalyzer methodAnalyzer, int n, int n2) {
        if (expression instanceof LocalLoadOperator) {
            LocalLoadOperator localLoadOperator = (LocalLoadOperator)expression;
            int n3 = localLoadOperator.getLocalInfo().getSlot();
            if (n3 >= n && n3 < n2) {
                return this.outerValues.getValueBySlot(n3);
            }
            Type[] typeArray = methodAnalyzer.getType().getParameterTypes();
            if (n3 >= n2) {
                n3 -= n2 - n;
            }
            int n4 = 0;
            while (n3 > 1 && n4 < typeArray.length) {
                n3 -= typeArray[n4].stackSize();
                ++n4;
            }
            localLoadOperator.setLocalInfo(methodAnalyzer.getParamInfo(1 + n4));
            localLoadOperator.setMethodAnalyzer(methodAnalyzer);
            return localLoadOperator;
        }
        if (expression instanceof Operator) {
            Expression[] expressionArray = ((Operator)expression).getSubExpressions();
            int n5 = 0;
            while (n5 < expressionArray.length) {
                Expression expression2 = this.renameJikesSuper(expressionArray[n5], methodAnalyzer, n, n2);
                if (expression2 != expressionArray[n5]) {
                    ((Operator)expression).setSubExpressions(n5, expression2);
                }
                ++n5;
            }
        }
        return expression;
    }

    public void checkJikesContinuation() {
        if ((GlobalOptions.debuggingFlags & 0x200) != 0) {
            System.err.println("checkJikesContinuation: " + this.outerValues);
        }
        int n = 0;
        while (n < this.cons.length) {
            block24: {
                Expression[] expressionArray;
                InvokeOperator invokeOperator;
                Expression expression;
                if ((GlobalOptions.debuggingFlags & 0x200) != 0) {
                    GlobalOptions.err.println("constr " + n + " type" + (n < this.type0Count ? 0 : (n < this.type01Count ? 1 : 2)) + " : " + this.cons[n].getMethodHeader());
                }
                MethodAnalyzer methodAnalyzer = this.cons[n];
                MethodType methodType = methodAnalyzer.getType();
                StructuredBlock structuredBlock = methodAnalyzer.getMethodHeader().block;
                Object var5_5 = null;
                InstructionBlock instructionBlock = null;
                if (n >= this.type0Count) {
                    if (structuredBlock instanceof SequentialBlock && structuredBlock.getSubBlocks()[1] instanceof InstructionBlock) {
                        instructionBlock = (InstructionBlock)structuredBlock.getSubBlocks()[0];
                        structuredBlock = structuredBlock.getSubBlocks()[1];
                        expression = instructionBlock.getInstruction().simplify();
                        invokeOperator = (InvokeOperator)expression;
                        instructionBlock.setInstruction(invokeOperator);
                        expressionArray = invokeOperator.getSubExpressions();
                        int n2 = 1;
                        while (n2 < expressionArray.length) {
                            if (this.checkJikesSuper(expressionArray[n2])) {
                                ++n2;
                                continue;
                            }
                            break;
                        }
                    }
                } else if (structuredBlock instanceof InstructionBlock && (expression = ((InstructionBlock)structuredBlock).getInstruction().simplify()) instanceof InvokeOperator && (invokeOperator = (InvokeOperator)expression).isThis() && invokeOperator.getFreeOperandCount() == 0 && (expressionArray = invokeOperator.getMethodAnalyzer()) != null) {
                    MethodType methodType2 = expressionArray.getType();
                    Expression[] expressionArray2 = invokeOperator.getSubExpressions();
                    if (expressionArray.getName().startsWith("constructor$") && methodType2.getReturnType() == Type.tVoid && TransformConstructors.isThis(expressionArray2[0], this.clazzAnalyzer.getClazz())) {
                        int n3;
                        int n4 = 1;
                        while (n4 < expressionArray2.length) {
                            if (expressionArray2[n4] instanceof LocalLoadOperator) {
                                ++n4;
                                continue;
                            }
                            break block24;
                        }
                        Type[] typeArray = methodAnalyzer.getType().getParameterTypes();
                        int n5 = typeArray.length;
                        if (this.outerValues.isJikesAnonymousInner()) {
                            --n5;
                        }
                        int n6 = n5 - expressionArray2.length + 2;
                        int n7 = n6 - 1;
                        int n8 = 1;
                        int n9 = 1;
                        Expression expression2 = null;
                        if (n6 > 0 && expressionArray2.length > 1 && this.outerValues.getCount() > 0) {
                            if (((LocalLoadOperator)expressionArray2[n9]).getLocalInfo().getSlot() == 1) {
                                n7 = n6;
                                expression2 = this.outerValues.getValue(0);
                                ++n9;
                            } else {
                                --n6;
                            }
                            n3 = 0;
                            while (n3 < n6) {
                                n8 += typeArray[n3].stackSize();
                                ++n3;
                            }
                        }
                        if (n7 <= this.outerValues.getCount()) {
                            n3 = n8;
                            int n10 = n9;
                            int n11 = n3 - n10;
                            int n12 = n9;
                            while (n12 < expressionArray2.length) {
                                if (((LocalLoadOperator)expressionArray2[n12]).getLocalInfo().getSlot() == n8) {
                                    n8 += expressionArray2[n12].getType().stackSize();
                                    ++n12;
                                    continue;
                                }
                                break block24;
                            }
                            this.outerValues.setMinCount(n7);
                            this.outerValues.setCount(n6);
                            if (instructionBlock != null) {
                                Expression expression3 = this.renameJikesSuper(instructionBlock.getInstruction(), (MethodAnalyzer)expressionArray, n10, n3);
                                instructionBlock.removeBlock();
                                expressionArray.insertStructuredBlock(instructionBlock);
                            }
                            if (expression2 != null) {
                                expressionArray.getParamInfo(1).setExpression(expression2);
                                expressionArray.getMethodHeader().simplify();
                            }
                            if ((GlobalOptions.debuggingFlags & 0x200) != 0) {
                                GlobalOptions.err.println("  succeeded");
                            }
                            methodAnalyzer.setJikesConstructor(methodAnalyzer);
                            expressionArray.setJikesConstructor(methodAnalyzer);
                            expressionArray.setHasOuterValue(n10 == 2);
                            if (methodAnalyzer.isAnonymousConstructor()) {
                                expressionArray.setAnonymousConstructor(true);
                            }
                        }
                    }
                }
            }
            ++n;
        }
    }

    private Expression transformFieldInitializer(int n, Expression expression) {
        Object object;
        Object[] objectArray;
        Object object2;
        if (expression instanceof LocalVarOperator) {
            int n2;
            Expression expression2;
            if (!(expression instanceof LocalLoadOperator)) {
                if ((GlobalOptions.debuggingFlags & 0x200) != 0) {
                    GlobalOptions.err.println("illegal local op: " + expression);
                }
                return null;
            }
            if (this.outerValues != null && (Options.options & 0x200) != 0 && (expression2 = this.outerValues.getValueBySlot(n2 = ((LocalLoadOperator)expression).getLocalInfo().getSlot())) != null) {
                return expression2;
            }
            if ((GlobalOptions.debuggingFlags & 0x200) != 0) {
                GlobalOptions.err.println("not outerValue: " + expression + " " + this.outerValues);
            }
            return null;
        }
        if (expression instanceof FieldOperator) {
            if (expression instanceof PutFieldOperator) {
                return null;
            }
            object2 = (FieldOperator)expression;
            if (((FieldOperator)object2).getClassInfo() == this.clazzAnalyzer.getClazz() && this.clazzAnalyzer.getFieldIndex(((FieldOperator)object2).getFieldName(), ((FieldOperator)object2).getFieldType()) >= n) {
                return null;
            }
        }
        if (expression instanceof InvokeOperator) {
            object2 = ((InvokeOperator)expression).getMethodInfo();
            Object[] objectArray2 = objectArray = object2 == null ? null : ((MethodInfo)object2).getExceptions();
            if (objectArray != null) {
                ClassInfo classInfo = ClassInfo.forName("java.lang.RuntimeException");
                object = ClassInfo.forName("java.lang.Error");
                int n3 = 0;
                while (n3 < objectArray.length) {
                    ClassInfo classInfo2 = ClassInfo.forName((String)objectArray[n3]);
                    if (!classInfo.superClassOf(classInfo2) && !((ClassInfo)object).superClassOf(classInfo2)) {
                        return null;
                    }
                    ++n3;
                }
            }
        }
        if (expression instanceof Operator) {
            object2 = (Operator)expression;
            objectArray = ((Operator)object2).getSubExpressions();
            int n4 = 0;
            while (n4 < objectArray.length) {
                object = this.transformFieldInitializer(n, (Expression)objectArray[n4]);
                if (object == null) {
                    return null;
                }
                if (object != objectArray[n4]) {
                    ((Operator)object2).setSubExpressions(n4, (Expression)object);
                }
                ++n4;
            }
        }
        return expression;
    }

    public void removeSynthInitializers() {
        block14: {
            int n;
            if ((Options.options & 0x200) == 0 || this.isStatic || this.type01Count == 0) {
                return;
            }
            this.checkAnonymousConstructor();
            if ((GlobalOptions.debuggingFlags & 0x200) != 0) {
                GlobalOptions.err.println("removeSynthInitializers of " + this.clazzAnalyzer.getClazz());
            }
            StructuredBlock[] structuredBlockArray = new StructuredBlock[this.type01Count];
            int n2 = 0;
            while (n2 < this.type01Count) {
                structuredBlockArray[n2] = this.cons[n2].getMethodHeader().block;
                if (n2 >= this.type0Count) {
                    if (structuredBlockArray[n2] instanceof SequentialBlock) {
                        structuredBlockArray[n2] = structuredBlockArray[n2].getSubBlocks()[1];
                    } else {
                        return;
                    }
                }
                ++n2;
            }
            do {
                FieldAnalyzer fieldAnalyzer;
                int n3;
                PutFieldOperator putFieldOperator;
                StoreInstruction storeInstruction;
                Expression expression;
                StructuredBlock structuredBlock;
                StructuredBlock structuredBlock2 = structuredBlock = structuredBlockArray[0] instanceof SequentialBlock ? structuredBlockArray[0].getSubBlocks()[0] : structuredBlockArray[0];
                if (!(structuredBlock instanceof InstructionBlock) || !((expression = ((InstructionBlock)structuredBlock).getInstruction().simplify()) instanceof StoreInstruction) || expression.getFreeOperandCount() != 0 || !((storeInstruction = (StoreInstruction)expression).getLValue() instanceof PutFieldOperator) || (putFieldOperator = (PutFieldOperator)storeInstruction.getLValue()).isStatic() != this.isStatic || putFieldOperator.getClassInfo() != this.clazzAnalyzer.getClazz() || !TransformConstructors.isThis(putFieldOperator.getSubExpressions()[0], this.clazzAnalyzer.getClazz()) || (n3 = this.clazzAnalyzer.getFieldIndex(putFieldOperator.getFieldName(), putFieldOperator.getFieldType())) < 0 || !(fieldAnalyzer = this.clazzAnalyzer.getField(n3)).isSynthetic()) break block14;
                Expression expression2 = storeInstruction.getSubExpressions()[1];
                if ((expression2 = this.transformFieldInitializer(n3, expression2)) == null) break block14;
                n = 1;
                while (n < this.type01Count) {
                    StructuredBlock structuredBlock3 = structuredBlock = structuredBlockArray[n] instanceof SequentialBlock ? structuredBlockArray[n].getSubBlocks()[0] : structuredBlockArray[n];
                    if (!(structuredBlock instanceof InstructionBlock) || !((InstructionBlock)structuredBlock).getInstruction().simplify().equals(expression)) {
                        if ((GlobalOptions.debuggingFlags & 0x200) == 0) break block14;
                        GlobalOptions.err.println("  constr 0 and " + n + " differ: " + expression + "<-/->" + structuredBlock);
                        break block14;
                    }
                    ++n;
                }
                if ((GlobalOptions.debuggingFlags & 0x200) != 0) {
                    GlobalOptions.err.println("  field " + putFieldOperator.getFieldName() + " = " + expression2);
                }
                if (!fieldAnalyzer.setInitializer(expression2)) {
                    if ((GlobalOptions.debuggingFlags & 0x200) == 0) break block14;
                    GlobalOptions.err.println("    setField failed");
                    break block14;
                }
                n = 0;
                int n4 = 0;
                while (n4 < this.type01Count) {
                    if (structuredBlockArray[n4] instanceof SequentialBlock) {
                        StructuredBlock structuredBlock4 = structuredBlockArray[n4].getSubBlocks()[1];
                        structuredBlock4.replace(structuredBlockArray[n4]);
                        structuredBlockArray[n4] = structuredBlock4;
                    } else {
                        structuredBlockArray[n4].removeBlock();
                        structuredBlockArray[n4] = null;
                        n = 1;
                    }
                    ++n4;
                }
            } while (n == 0);
            if ((GlobalOptions.debuggingFlags & 0x200) == 0) break block14;
            GlobalOptions.err.println("one constr is over");
        }
    }

    public int transformOneField(int n, StructuredBlock structuredBlock) {
        if (!(structuredBlock instanceof InstructionBlock)) {
            return -1;
        }
        Expression expression = ((InstructionBlock)structuredBlock).getInstruction().simplify();
        if (!(expression instanceof StoreInstruction) || expression.getFreeOperandCount() != 0) {
            return -1;
        }
        StoreInstruction storeInstruction = (StoreInstruction)expression;
        if (!(storeInstruction.getLValue() instanceof PutFieldOperator)) {
            return -1;
        }
        PutFieldOperator putFieldOperator = (PutFieldOperator)storeInstruction.getLValue();
        if (putFieldOperator.isStatic() != this.isStatic || putFieldOperator.getClassInfo() != this.clazzAnalyzer.getClazz()) {
            return -1;
        }
        if (!this.isStatic && !TransformConstructors.isThis(putFieldOperator.getSubExpressions()[0], this.clazzAnalyzer.getClazz())) {
            if ((GlobalOptions.debuggingFlags & 0x200) != 0) {
                GlobalOptions.err.println("  not this: " + expression);
            }
            return -1;
        }
        int n2 = this.clazzAnalyzer.getFieldIndex(putFieldOperator.getFieldName(), putFieldOperator.getFieldType());
        if (n2 <= n) {
            return -1;
        }
        Expression expression2 = storeInstruction.getSubExpressions()[1];
        if ((expression2 = this.transformFieldInitializer(n2, expression2)) == null) {
            return -1;
        }
        if ((GlobalOptions.debuggingFlags & 0x200) != 0) {
            GlobalOptions.err.println("  field " + putFieldOperator.getFieldName() + " = " + expression2);
        }
        if (n2 <= n || !this.clazzAnalyzer.getField(n2).setInitializer(expression2)) {
            if ((GlobalOptions.debuggingFlags & 0x200) != 0) {
                GlobalOptions.err.println("set field failed");
            }
            return -1;
        }
        return n2;
    }

    public void transformBlockInitializer(StructuredBlock structuredBlock) {
        Object var2_2 = null;
        Object var3_3 = null;
        int n = -1;
        while (structuredBlock instanceof SequentialBlock) {
            StructuredBlock structuredBlock2 = structuredBlock.getSubBlocks()[0];
            int n2 = this.transformOneField(n, structuredBlock2);
            if (n2 < 0) {
                this.clazzAnalyzer.addBlockInitializer(n + 1, structuredBlock2);
            } else {
                n = n2;
            }
            structuredBlock = structuredBlock.getSubBlocks()[1];
        }
        if (this.transformOneField(n, structuredBlock) < 0) {
            this.clazzAnalyzer.addBlockInitializer(n + 1, structuredBlock);
        }
    }

    public boolean checkBlockInitializer(InvokeOperator invokeOperator) {
        if (!invokeOperator.isThis() || invokeOperator.getFreeOperandCount() != 0) {
            return false;
        }
        MethodAnalyzer methodAnalyzer = invokeOperator.getMethodAnalyzer();
        if (methodAnalyzer == null) {
            return false;
        }
        FlowBlock flowBlock = methodAnalyzer.getMethodHeader();
        MethodType methodType = methodAnalyzer.getType();
        if (!methodAnalyzer.getName().startsWith("block$") || methodType.getParameterTypes().length != 0 || methodType.getReturnType() != Type.tVoid) {
            return false;
        }
        if (flowBlock == null || !flowBlock.hasNoJumps()) {
            return false;
        }
        if (!TransformConstructors.isThis(invokeOperator.getSubExpressions()[0], this.clazzAnalyzer.getClazz())) {
            return false;
        }
        methodAnalyzer.setJikesBlockInitializer(true);
        this.transformBlockInitializer(flowBlock.block);
        return true;
    }

    private void removeDefaultSuper() {
        if ((GlobalOptions.debuggingFlags & 0x200) != 0) {
            GlobalOptions.err.println("removeDefaultSuper of " + this.clazzAnalyzer.getClazz());
        }
        int n = this.type0Count;
        while (n < this.type01Count) {
            block10: {
                InstructionBlock instructionBlock;
                MethodAnalyzer methodAnalyzer;
                block9: {
                    int n2;
                    InvokeOperator invokeOperator;
                    block8: {
                        methodAnalyzer = this.cons[n];
                        FlowBlock flowBlock = this.cons[n].getMethodHeader();
                        StructuredBlock structuredBlock = flowBlock.block;
                        if ((GlobalOptions.debuggingFlags & 0x200) != 0) {
                            GlobalOptions.err.println("constr " + n + ": " + structuredBlock);
                        }
                        instructionBlock = structuredBlock instanceof InstructionBlock ? (InstructionBlock)structuredBlock : (InstructionBlock)structuredBlock.getSubBlocks()[0];
                        invokeOperator = (InvokeOperator)instructionBlock.getInstruction().simplify();
                        ClassInfo classInfo = invokeOperator.getClassInfo();
                        InnerClassInfo[] innerClassInfoArray = classInfo.getOuterClasses();
                        n2 = invokeOperator.getSubExpressions().length - 1;
                        if ((Options.options & 2) == 0 || innerClassInfoArray == null || innerClassInfoArray[0].outer == null || innerClassInfoArray[0].name == null || Modifier.isStatic(innerClassInfoArray[0].modifiers)) break block8;
                        if (n2 == 1 && invokeOperator.getSubExpressions()[1] instanceof ThisOperator) break block9;
                        break block10;
                    }
                    ClassAnalyzer classAnalyzer = invokeOperator.getClassAnalyzer();
                    OuterValues outerValues = null;
                    if (classAnalyzer != null) {
                        outerValues = classAnalyzer.getOuterValues();
                    }
                    if (n2 > 0 && (outerValues == null || n2 > outerValues.getCount())) break block10;
                }
                instructionBlock.removeBlock();
                if (n > this.type0Count) {
                    this.cons[n] = this.cons[this.type0Count];
                    this.cons[this.type0Count] = methodAnalyzer;
                }
                ++this.type0Count;
            }
            ++n;
        }
    }

    private void removeInitializers() {
        block18: {
            boolean bl;
            Object object;
            if (this.type01Count == 0) {
                return;
            }
            if ((GlobalOptions.debuggingFlags & 0x200) != 0) {
                GlobalOptions.err.println("removeInitializers");
            }
            StructuredBlock[] structuredBlockArray = new StructuredBlock[this.type01Count];
            int n = 0;
            while (n < this.type01Count) {
                object = this.cons[n].getMethodHeader();
                structuredBlockArray[n] = ((FlowBlock)object).block;
                if (n >= this.type0Count) {
                    if (structuredBlockArray[n] instanceof SequentialBlock) {
                        structuredBlockArray[n] = structuredBlockArray[n].getSubBlocks()[1];
                    } else {
                        structuredBlockArray[n] = null;
                        return;
                    }
                }
                ++n;
            }
            n = -1;
            do {
                Object object2 = object = structuredBlockArray[0] instanceof SequentialBlock ? structuredBlockArray[0].getSubBlocks()[0] : structuredBlockArray[0];
                if ((GlobalOptions.debuggingFlags & 0x200) != 0) {
                    GlobalOptions.err.println("Instruction: " + object);
                }
                if (!(object instanceof InstructionBlock)) break block18;
                Expression expression = ((InstructionBlock)object).getInstruction().simplify();
                int n2 = 1;
                while (n2 < this.type01Count) {
                    Object object3 = object = structuredBlockArray[n2] instanceof SequentialBlock ? structuredBlockArray[n2].getSubBlocks()[0] : structuredBlockArray[n2];
                    if (!(object instanceof InstructionBlock) || !((InstructionBlock)object).getInstruction().simplify().equals(expression)) {
                        if ((GlobalOptions.debuggingFlags & 0x200) == 0) break block18;
                        GlobalOptions.err.println("constr " + n2 + " differs: " + object);
                        break block18;
                    }
                    ++n2;
                }
                if (expression instanceof InvokeOperator && this.checkBlockInitializer((InvokeOperator)expression)) {
                    n2 = 0;
                    while (n2 < this.type01Count) {
                        if (structuredBlockArray[n2] instanceof SequentialBlock) {
                            StructuredBlock structuredBlock = structuredBlockArray[n2].getSubBlocks()[1];
                            structuredBlock.replace(structuredBlockArray[n2]);
                            structuredBlockArray[n2] = structuredBlock;
                        } else {
                            structuredBlockArray[n2].removeBlock();
                            structuredBlockArray[n2] = null;
                        }
                        ++n2;
                    }
                    break block18;
                }
                n2 = this.transformOneField(n, (StructuredBlock)object);
                if (n2 < 0) break block18;
                n = n2;
                bl = false;
                int n3 = 0;
                while (n3 < this.type01Count) {
                    if (structuredBlockArray[n3] instanceof SequentialBlock) {
                        StructuredBlock structuredBlock = structuredBlockArray[n3].getSubBlocks()[1];
                        structuredBlock.replace(structuredBlockArray[n3]);
                        structuredBlockArray[n3] = structuredBlock;
                    } else {
                        structuredBlockArray[n3].removeBlock();
                        structuredBlockArray[n3] = null;
                        bl = true;
                    }
                    ++n3;
                }
            } while (!bl);
            if ((GlobalOptions.debuggingFlags & 0x200) != 0) {
                GlobalOptions.err.println("one constr is over");
            }
        }
    }

    public void transform() {
        if ((Options.options & 0x200) == 0 || this.cons.length == 0) {
            return;
        }
        this.removeDefaultSuper();
        this.removeInitializers();
        this.checkJikesContinuation();
        if (this.outerValues != null) {
            int n = 0;
            while (n < this.cons.length) {
                int n2 = 0;
                while (n2 < this.outerValues.getCount()) {
                    this.cons[n].getParamInfo(n2 + 1).setExpression(this.outerValues.getValue(n2));
                    ++n2;
                }
                this.cons[n].getMethodHeader().simplify();
                ++n;
            }
        }
    }

    public TransformConstructors(ClassAnalyzer classAnalyzer, boolean bl, MethodAnalyzer[] methodAnalyzerArray) {
        this.clazzAnalyzer = classAnalyzer;
        this.isStatic = bl;
        this.cons = methodAnalyzerArray;
        if (!bl) {
            this.outerValues = classAnalyzer.getOuterValues();
        }
        this.lookForConstructorCall();
    }
}

