/*
 * Decompiled with CFR 0.152.
 */
package jode.flow;

import java.io.IOException;
import java.util.Set;
import jode.decompiler.LocalInfo;
import jode.decompiler.TabbedPrintWriter;
import jode.expr.Expression;
import jode.expr.LocalStoreOperator;
import jode.expr.StoreInstruction;
import jode.flow.InstructionContainer;
import jode.flow.Jump;
import jode.flow.VariableStack;
import jode.type.Type;

public class InstructionBlock
extends InstructionContainer {
    VariableStack stack;
    LocalInfo pushedLocal = null;
    boolean isDeclaration = false;

    public VariableStack mapStackToLocal(VariableStack variableStack) {
        VariableStack variableStack2;
        int n = this.instr.getFreeOperandCount();
        if (n > 0) {
            this.stack = variableStack.peek(n);
        }
        if (this.instr.getType() != Type.tVoid) {
            this.pushedLocal = new LocalInfo();
            this.pushedLocal.setType(this.instr.getType());
            variableStack2 = variableStack.poppush(n, this.pushedLocal);
        } else {
            variableStack2 = n > 0 ? variableStack.pop(n) : variableStack;
        }
        return super.mapStackToLocal(variableStack2);
    }

    public void removePush() {
        if (this.stack != null) {
            this.instr = this.stack.mergeIntoExpression(this.instr);
        }
        if (this.pushedLocal != null) {
            Expression expression;
            this.instr = expression = new StoreInstruction(new LocalStoreOperator(this.pushedLocal.getType(), this.pushedLocal)).addOperand(this.instr);
        }
        super.removePush();
    }

    public boolean needsBraces() {
        return this.isDeclaration || this.declare != null && !this.declare.isEmpty();
    }

    public void checkDeclaration(Set set) {
        StoreInstruction storeInstruction;
        LocalInfo localInfo;
        if (this.instr instanceof StoreInstruction && ((StoreInstruction)this.instr).getLValue() instanceof LocalStoreOperator && set.contains(localInfo = ((LocalStoreOperator)(storeInstruction = (StoreInstruction)this.instr).getLValue()).getLocalInfo())) {
            this.isDeclaration = true;
            set.remove(localInfo);
        }
    }

    public void makeDeclaration(Set set) {
        super.makeDeclaration(set);
        this.checkDeclaration(this.declare);
    }

    public void dumpInstruction(TabbedPrintWriter tabbedPrintWriter) throws IOException {
        if (this.isDeclaration) {
            StoreInstruction storeInstruction = (StoreInstruction)this.instr;
            LocalInfo localInfo = ((LocalStoreOperator)storeInstruction.getLValue()).getLocalInfo();
            tabbedPrintWriter.startOp(1, 0);
            localInfo.dumpDeclaration(tabbedPrintWriter);
            tabbedPrintWriter.breakOp();
            tabbedPrintWriter.print(" = ");
            storeInstruction.getSubExpressions()[1].makeInitializer(localInfo.getType());
            storeInstruction.getSubExpressions()[1].dumpExpression(2, tabbedPrintWriter);
            tabbedPrintWriter.endOp();
        } else {
            try {
                if (this.instr.getType() != Type.tVoid) {
                    tabbedPrintWriter.print("PUSH ");
                    this.instr.dumpExpression(2, tabbedPrintWriter);
                } else {
                    this.instr.dumpExpression(1, tabbedPrintWriter);
                }
            }
            catch (RuntimeException runtimeException) {
                tabbedPrintWriter.print("(RUNTIME ERROR IN EXPRESSION)");
            }
        }
        tabbedPrintWriter.println(";");
    }

    public InstructionBlock(Expression expression) {
        super(expression);
    }

    public InstructionBlock(Expression expression, Jump jump) {
        super(expression, jump);
    }
}

