/*
 * Decompiled with CFR 0.152.
 */
package jode.bytecode;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import jode.GlobalOptions;

public class SearchPath {
    public static final char altPathSeparatorChar = ',';
    URL[] bases;
    byte[][] urlzips;
    File[] dirs;
    ZipFile[] zips;
    String[] zipDirs;
    Hashtable[] zipEntries;

    private static void addEntry(Hashtable hashtable, String string) {
        Vector<String> vector;
        String string2 = "";
        int n = string.lastIndexOf("/");
        if (n != -1) {
            string2 = string.substring(0, n);
            string = string.substring(n + 1);
        }
        if ((vector = (Vector<String>)hashtable.get(string2)) == null) {
            vector = new Vector<String>();
            hashtable.put(string2, vector);
            if (string2 != "") {
                SearchPath.addEntry(hashtable, string2);
            }
        }
        vector.addElement(string);
    }

    private void fillZipEntries(int n) {
        Enumeration<? extends ZipEntry> enumeration = this.zips[n].entries();
        this.zipEntries[n] = new Hashtable();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            String string = zipEntry.getName();
            if (this.zipDirs[n] != null) {
                if (!string.startsWith(this.zipDirs[n])) continue;
                string = string.substring(this.zipDirs[n].length());
            }
            if (zipEntry.isDirectory() || !string.endsWith(".class")) continue;
            SearchPath.addEntry(this.zipEntries[n], string);
        }
    }

    private void readURLZip(int n, URLConnection uRLConnection) {
        InputStream inputStream;
        int n2 = uRLConnection.getContentLength();
        n2 = n2 <= 0 ? 10240 : ++n2;
        this.urlzips[n] = new byte[n2];
        try {
            inputStream = uRLConnection.getInputStream();
            int n3 = 0;
            while (true) {
                int n4;
                int n5 = Math.max(inputStream.available(), 1);
                if (n3 + inputStream.available() > this.urlzips[n].length) {
                    byte[] byArray = new byte[Math.max(2 * this.urlzips[n].length, n3 + inputStream.available())];
                    System.arraycopy(this.urlzips[n], 0, byArray, 0, n3);
                    this.urlzips[n] = byArray;
                }
                if ((n4 = inputStream.read(this.urlzips[n], n3, this.urlzips[n].length - n3)) == -1) break;
                n3 += n4;
            }
            if (n3 < this.urlzips[n].length) {
                byte[] byArray = new byte[n3];
                System.arraycopy(this.urlzips[n], 0, byArray, 0, n3);
                this.urlzips[n] = byArray;
            }
        }
        catch (IOException iOException) {
            GlobalOptions.err.println("IOException while reading remote zip file " + this.bases[n]);
            this.bases[n] = null;
            this.urlzips[n] = null;
            return;
        }
        try {
            ZipEntry zipEntry;
            inputStream = new ZipInputStream(new ByteArrayInputStream(this.urlzips[n]));
            this.zipEntries[n] = new Hashtable();
            while ((zipEntry = ((ZipInputStream)inputStream).getNextEntry()) != null) {
                String string = zipEntry.getName();
                if (this.zipDirs[n] != null) {
                    if (!string.startsWith(this.zipDirs[n])) continue;
                    string = string.substring(this.zipDirs[n].length());
                }
                if (!zipEntry.isDirectory() && string.endsWith(".class")) {
                    SearchPath.addEntry(this.zipEntries[n], string);
                }
                ((ZipInputStream)inputStream).closeEntry();
            }
            ((ZipInputStream)inputStream).close();
        }
        catch (IOException iOException) {
            GlobalOptions.err.println("Remote zip file " + this.bases[n] + " is corrupted.");
            this.bases[n] = null;
            this.urlzips[n] = null;
            this.zipEntries[n] = null;
            return;
        }
    }

    public boolean exists(String string) {
        String string2 = File.separatorChar != '/' ? string.replace('/', File.separatorChar) : string;
        int n = 0;
        while (n < this.dirs.length) {
            Object object;
            Object object2;
            if (this.zipEntries[n] != null) {
                Vector vector;
                if (this.zipEntries[n].get(string) != null) {
                    return true;
                }
                object2 = "";
                object = string;
                int n2 = string.lastIndexOf(47);
                if (n2 >= 0) {
                    object2 = string.substring(0, n2);
                    object = string.substring(n2 + 1);
                }
                if ((vector = (Vector)this.zipEntries[n].get(object2)) != null && vector.contains(object)) {
                    return true;
                }
            } else if (this.bases[n] != null) {
                try {
                    object2 = new URL(this.bases[n], string);
                    object = ((URL)object2).openConnection();
                    ((URLConnection)object).connect();
                    ((URLConnection)object).getInputStream().close();
                    return true;
                }
                catch (IOException iOException) {}
            } else if (this.dirs[n] != null) {
                if (this.zips[n] != null) {
                    object2 = this.zipDirs[n] != null ? this.zipDirs[n] + string : string;
                    object = this.zips[n].getEntry((String)object2);
                    if (object != null) {
                        return true;
                    }
                } else {
                    try {
                        object2 = new File(this.dirs[n], string2);
                        if (((File)object2).exists()) {
                            return true;
                        }
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                }
            }
            ++n;
        }
        return false;
    }

    public InputStream getFile(String string) throws IOException {
        String string2 = File.separatorChar != '/' ? string.replace('/', File.separatorChar) : string;
        int n = 0;
        while (n < this.dirs.length) {
            Object object;
            Object object2;
            if (this.urlzips[n] != null) {
                object2 = new ZipInputStream(new ByteArrayInputStream(this.urlzips[n]));
                String string3 = this.zipDirs[n] != null ? this.zipDirs[n] + string : string;
                while ((object = ((ZipInputStream)object2).getNextEntry()) != null) {
                    if (((ZipEntry)object).getName().equals(string3)) {
                        return object2;
                    }
                    ((ZipInputStream)object2).closeEntry();
                }
            } else if (this.bases[n] != null) {
                try {
                    object2 = new URL(this.bases[n], string);
                    object = ((URL)object2).openConnection();
                    ((URLConnection)object).setAllowUserInteraction(true);
                    return ((URLConnection)object).getInputStream();
                }
                catch (SecurityException securityException) {
                    GlobalOptions.err.println("Warning: SecurityException while accessing " + this.bases[n] + string);
                    securityException.printStackTrace(GlobalOptions.err);
                }
                catch (FileNotFoundException fileNotFoundException) {}
            } else if (this.dirs[n] != null) {
                if (this.zips[n] != null) {
                    object2 = this.zipDirs[n] != null ? this.zipDirs[n] + string : string;
                    object = this.zips[n].getEntry((String)object2);
                    if (object != null) {
                        return this.zips[n].getInputStream((ZipEntry)object);
                    }
                } else {
                    try {
                        object2 = new File(this.dirs[n], string2);
                        if (((File)object2).exists()) {
                            return new FileInputStream((File)object2);
                        }
                    }
                    catch (SecurityException securityException) {
                        GlobalOptions.err.println("Warning: SecurityException while accessing " + this.dirs[n] + string2);
                    }
                }
            }
            ++n;
        }
        throw new FileNotFoundException(string);
    }

    public boolean isDirectory(String string) {
        String string2 = File.separatorChar != '/' ? string.replace('/', File.separatorChar) : string;
        int n = 0;
        while (n < this.dirs.length) {
            if (this.dirs[n] != null) {
                if (this.zips[n] != null && this.zipEntries[n] == null) {
                    this.fillZipEntries(n);
                }
                if (this.zipEntries[n] != null) {
                    if (this.zipEntries[n].containsKey(string)) {
                        return true;
                    }
                } else {
                    try {
                        File file = new File(this.dirs[n], string2);
                        if (file.exists()) {
                            return file.isDirectory();
                        }
                    }
                    catch (SecurityException securityException) {
                        GlobalOptions.err.println("Warning: SecurityException while accessing " + this.dirs[n] + string2);
                    }
                }
            }
            ++n;
        }
        return false;
    }

    public Enumeration listFiles(String string) {
        SearchPath searchPath = this;
        if (searchPath == null) {
            throw null;
        }
        return new Enumeration(searchPath, string){
            int pathNr;
            Enumeration zipEnum;
            int fileNr;
            String localDirName;
            File currentDir;
            String[] files;
            String nextName;
            private final /* synthetic */ SearchPath this$0;
            private final /* synthetic */ String val$dirName;

            public String findNextFile() {
                while (true) {
                    Object object;
                    if (this.zipEnum != null) {
                        if (this.zipEnum.hasMoreElements()) {
                            return (String)this.zipEnum.nextElement();
                        }
                        this.zipEnum = null;
                    }
                    if (this.files != null) {
                        while (this.fileNr < this.files.length) {
                            File file;
                            if (((String)(object = this.files[this.fileNr++])).endsWith(".class")) {
                                return object;
                            }
                            if (((String)object).indexOf(".") != -1 || !(file = new File(this.currentDir, (String)object)).exists() || !file.isDirectory()) continue;
                            return object;
                        }
                        this.files = null;
                    }
                    if (this.pathNr == this.this$0.dirs.length) {
                        return null;
                    }
                    if (this.this$0.zips[this.pathNr] != null && this.this$0.zipEntries[this.pathNr] == null) {
                        SearchPath.access$0(this.this$0, this.pathNr);
                    }
                    if (this.this$0.zipEntries[this.pathNr] != null) {
                        object = (Vector)this.this$0.zipEntries[this.pathNr].get(this.val$dirName);
                        if (object != null) {
                            this.zipEnum = ((Vector)object).elements();
                        }
                    } else if (this.this$0.dirs[this.pathNr] != null) {
                        try {
                            object = new File(this.this$0.dirs[this.pathNr], this.localDirName);
                            if (((File)object).exists() && ((File)object).isDirectory()) {
                                this.currentDir = object;
                                this.files = ((File)object).list();
                                this.fileNr = 0;
                            }
                        }
                        catch (SecurityException securityException) {
                            GlobalOptions.err.println("Warning: SecurityException while accessing " + this.this$0.dirs[this.pathNr] + this.localDirName);
                        }
                    }
                    ++this.pathNr;
                }
            }

            public boolean hasMoreElements() {
                return this.nextName != null || (this.nextName = this.findNextFile()) != null;
            }

            public Object nextElement() {
                if (this.nextName == null) {
                    return this.findNextFile();
                }
                String string = this.nextName;
                this.nextName = null;
                return string;
            }
            {
                this.val$dirName = string;
                this.this$0 = searchPath;
                this.localDirName = File.separatorChar != '/' ? this.val$dirName.replace('/', File.separatorChar) : this.val$dirName;
                this.constructor$0(searchPath);
            }

            private final void constructor$0(SearchPath searchPath) {
            }
        };
    }

    static /* synthetic */ void access$0(SearchPath searchPath, int n) {
        searchPath.fillZipEntries(n);
    }

    /*
     * Unable to fully structure code
     */
    public SearchPath(String var1_1) {
        super();
        var2_2 = 1;
        var3_3 = var1_1.indexOf(File.pathSeparatorChar);
        while (var3_3 != -1) {
            var3_3 = var1_1.indexOf(File.pathSeparatorChar, var3_3 + 1);
            ++var2_2;
        }
        if (File.pathSeparatorChar != ',') {
            var3_3 = var1_1.indexOf(44);
            while (var3_3 != -1) {
                var3_3 = var1_1.indexOf(44, var3_3 + 1);
                ++var2_2;
            }
        }
        this.bases = new URL[var2_2];
        this.urlzips = new byte[var2_2][];
        this.dirs = new File[var2_2];
        this.zips = new ZipFile[var2_2];
        this.zipEntries = new Hashtable[var2_2];
        this.zipDirs = new String[var2_2];
        var3_3 = 0;
        var4_4 = 0;
        while (var4_4 < var1_1.length()) {
            var5_5 = var4_4;
            while (var5_5 < var1_1.length() && var1_1.charAt(var5_5) != File.pathSeparatorChar && var1_1.charAt(var5_5) != ',') {
                ++var5_5;
            }
            var6_6 = var4_4;
            ** GOTO lbl37
            while ((var7_8 = var1_1.charAt(var6_6)) >= 'A' && var7_8 <= 'Z' || var7_8 >= 'a' && var7_8 <= 'z' || var7_8 >= '0' && var7_8 <= '9' || "+-".indexOf(var7_8) != -1) {
                ++var6_6;
                while (var6_6 >= var5_5) {
                    ++var5_5;
                    ++var6_6;
                    while (var5_5 < var1_1.length() && var1_1.charAt(var5_5) != File.pathSeparatorChar && var1_1.charAt(var5_5) != ',') {
                        ++var5_5;
                    }
lbl37:
                    // 2 sources

                    if (var5_5 > var4_4 && var5_5 < var1_1.length() && var1_1.charAt(var5_5) == ':') continue;
                }
            }
            var7_7 = var1_1.substring(var4_4, var5_5);
            var4_4 = var5_5;
            var8_9 = false;
            if (!var7_7.startsWith("jar:")) ** GOTO lbl54
            var6_6 = 0;
            while ((var6_6 = var7_7.indexOf(33, var6_6)) != -1 && var6_6 != var7_7.length() - 1 && var7_7.charAt(var6_6 + 1) != '/') {
            }
            if (var6_6 == -1 || var6_6 == var7_7.length() - 1) {
                GlobalOptions.err.println("Warning: Illegal jar url " + var7_7 + ".");
            } else {
                this.zipDirs[var3_3] = var7_7.substring(var6_6 + 2);
                if (!this.zipDirs[var3_3].endsWith("/")) {
                    this.zipDirs[var3_3] = this.zipDirs[var3_3] + "/";
                }
                var7_7 = var7_7.substring(4, var6_6);
                var8_9 = true;
lbl54:
                // 2 sources

                if ((var6_6 = var7_7.indexOf(58)) != -1 && var6_6 < var7_7.length() - 2 && var7_7.charAt(var6_6 + 1) == '/' && var7_7.charAt(var6_6 + 2) == '/') {
                    try {
                        this.bases[var3_3] = new URL(var7_7);
                        try {
                            var9_10 = this.bases[var3_3].openConnection();
                            if (var8_9 || var7_7.endsWith(".zip") || var7_7.endsWith(".jar") || var9_10.getContentType().endsWith("/zip")) {
                                this.readURLZip(var3_3, var9_10);
                            }
                        }
                        catch (IOException var9_11) {
                        }
                        catch (SecurityException var9_12) {
                            GlobalOptions.err.println("Warning: Security exception while accessing " + this.bases[var3_3] + ".");
                        }
                    }
                    catch (MalformedURLException var9_13) {
                        this.bases[var3_3] = null;
                        this.dirs[var3_3] = null;
                    }
                } else {
                    try {
                        this.dirs[var3_3] = new File(var7_7);
                        if (var8_9 || !this.dirs[var3_3].isDirectory()) {
                            try {
                                this.zips[var3_3] = new ZipFile(this.dirs[var3_3]);
                            }
                            catch (IOException var9_14) {
                                this.dirs[var3_3] = null;
                            }
                        }
                    }
                    catch (SecurityException var9_15) {
                        GlobalOptions.err.println("Warning: SecurityException while accessing " + var7_7 + ".");
                        this.dirs[var3_3] = null;
                    }
                }
            }
            ++var4_4;
            ++var3_3;
        }
    }
}

