/*
 * Decompiled with CFR 0.152.
 */
package jode.bytecode;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Iterator;
import jode.GlobalOptions;
import jode.bytecode.BinaryInfo;
import jode.bytecode.ClassFormatException;
import jode.bytecode.ConstantPool;
import jode.bytecode.FieldInfo;
import jode.bytecode.GrowableConstantPool;
import jode.bytecode.InnerClassInfo;
import jode.bytecode.MethodInfo;
import jode.bytecode.SearchPath;
import jode.bytecode.TypeSignature;
import jode.util.UnifyHash;

public class ClassInfo
extends BinaryInfo {
    private static SearchPath classpath;
    private static final UnifyHash classes;
    public static final ClassInfo javaLangObject;
    private int status = 0;
    private boolean modified = false;
    private int modifiers = -1;
    private boolean deprecatedFlag;
    private String name;
    private ClassInfo superclass;
    private ClassInfo[] interfaces;
    private FieldInfo[] fields;
    private MethodInfo[] methods;
    private InnerClassInfo[] outerClasses;
    private InnerClassInfo[] innerClasses;
    private InnerClassInfo[] extraClasses;
    private String sourceFile;
    private static /* synthetic */ Class class$Ljava$lang$Object;

    public static void setClassPath(String string) {
        ClassInfo.setClassPath(new SearchPath(string));
    }

    public static void setClassPath(SearchPath searchPath) {
        if (classpath != searchPath) {
            classpath = searchPath;
            Iterator iterator = classes.iterator();
            while (iterator.hasNext()) {
                ClassInfo classInfo = (ClassInfo)iterator.next();
                classInfo.status = 0;
                classInfo.superclass = null;
                classInfo.fields = null;
                classInfo.interfaces = null;
                classInfo.methods = null;
                classInfo.removeAllAttributes();
            }
        }
    }

    public static boolean exists(String string) {
        return classpath.exists(string.replace('.', '/') + ".class");
    }

    public static boolean isPackage(String string) {
        return classpath.isDirectory(string.replace('.', '/'));
    }

    public static Enumeration getClassesAndPackages(String string) {
        Enumeration enumeration = classpath.listFiles(string.replace('.', '/'));
        return new Enumeration(enumeration){
            private final /* synthetic */ Enumeration val$enum;

            public boolean hasMoreElements() {
                return this.val$enum.hasMoreElements();
            }

            public Object nextElement() {
                String string = (String)this.val$enum.nextElement();
                if (!string.endsWith(".class")) {
                    return string;
                }
                return string.substring(0, string.length() - 6);
            }
            {
                this.val$enum = enumeration;
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        };
    }

    public static ClassInfo forName(String string) {
        ClassInfo classInfo;
        if (string == null || string.indexOf(59) != -1 || string.indexOf(91) != -1 || string.indexOf(47) != -1) {
            throw new IllegalArgumentException("Illegal class name: " + string);
        }
        int n = string.hashCode();
        Iterator iterator = classes.iterateHashCode(n);
        while (iterator.hasNext()) {
            classInfo = (ClassInfo)iterator.next();
            if (!classInfo.name.equals(string)) continue;
            return classInfo;
        }
        classInfo = new ClassInfo(string);
        classes.put(n, classInfo);
        return classInfo;
    }

    protected void readAttribute(String string, int n, ConstantPool constantPool, DataInputStream dataInputStream, int n2) throws IOException {
        if ((n2 & 0x10) != 0 && string.equals("SourceFile")) {
            if (n != 2) {
                throw new ClassFormatException("SourceFile attribute has wrong length");
            }
            this.sourceFile = constantPool.getUTF8(dataInputStream.readUnsignedShort());
        } else if ((n2 & 0x60) != 0 && string.equals("InnerClasses")) {
            int n3;
            int n4;
            int n5 = dataInputStream.readUnsignedShort();
            if (n != 2 + 8 * n5) {
                throw new ClassFormatException("InnerClasses attribute has wrong length");
            }
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            InnerClassInfo[] innerClassInfoArray = new InnerClassInfo[n5];
            int n9 = 0;
            while (n9 < n5) {
                n4 = dataInputStream.readUnsignedShort();
                n3 = dataInputStream.readUnsignedShort();
                int n10 = dataInputStream.readUnsignedShort();
                String string2 = constantPool.getClassName(n4);
                String string3 = n3 != 0 ? constantPool.getClassName(n3) : null;
                String string4 = n10 != 0 ? constantPool.getUTF8(n10) : null;
                int n11 = dataInputStream.readUnsignedShort();
                if (string4 != null && string4.length() == 0) {
                    string4 = null;
                }
                if (string3 != null && string4 != null && string2.length() > string3.length() + 2 + string4.length() && string2.startsWith(string3 + "$") && string2.endsWith("$" + string4) && Character.isDigit(string2.charAt(string3.length() + 1))) {
                    string3 = null;
                }
                InnerClassInfo innerClassInfo = new InnerClassInfo(string2, string3, string4, n11);
                if (string3 != null && string3.equals(this.getName()) && string4 != null) {
                    innerClassInfoArray[n6++] = innerClassInfo;
                } else {
                    innerClassInfoArray[n5 - ++n8] = innerClassInfo;
                }
                ++n9;
            }
            String string5 = this.getName();
            n4 = n5 - n8;
            while (n4 < n5 && string5 != null) {
                InnerClassInfo innerClassInfo = innerClassInfoArray[n4];
                if (innerClassInfo.inner.equals(string5)) {
                    ++n7;
                    --n8;
                    string5 = innerClassInfo.outer;
                }
                ++n4;
            }
            if (n6 > 0) {
                this.innerClasses = new InnerClassInfo[n6];
                System.arraycopy(innerClassInfoArray, 0, this.innerClasses, 0, n6);
            } else {
                this.innerClasses = null;
            }
            this.outerClasses = n7 > 0 ? new InnerClassInfo[n7] : null;
            this.extraClasses = n8 > 0 ? new InnerClassInfo[n8] : null;
            int n12 = 0;
            String string6 = this.getName();
            n3 = n5 - n8 - n7;
            while (n3 < n5) {
                InnerClassInfo innerClassInfo = innerClassInfoArray[n3];
                if (innerClassInfo.inner.equals(string6)) {
                    this.outerClasses[n12++] = innerClassInfo;
                    string6 = innerClassInfo.outer;
                } else {
                    this.extraClasses[--n8] = innerClassInfo;
                }
                ++n3;
            }
        } else if (string.equals("Deprecated")) {
            this.deprecatedFlag = true;
            if (n != 0) {
                throw new ClassFormatException("Deprecated attribute has wrong length");
            }
        } else {
            super.readAttribute(string, n, constantPool, dataInputStream, n2);
        }
    }

    public void read(DataInputStream dataInputStream, int n) throws IOException {
        int n2;
        n |= 0x61;
        n &= ~this.status;
        if (dataInputStream.readInt() != -889275714) {
            throw new ClassFormatException("Wrong magic");
        }
        int n3 = dataInputStream.readUnsignedShort();
        if ((n3 |= dataInputStream.readUnsignedShort() << 16) < 0x2D0000) {
            throw new ClassFormatException("Wrong class version");
        }
        ConstantPool constantPool = new ConstantPool();
        constantPool.read(dataInputStream);
        this.modifiers = dataInputStream.readUnsignedShort();
        Object object = constantPool.getClassName(dataInputStream.readUnsignedShort());
        if (!this.name.equals(object)) {
            throw new ClassFormatException("wrong name " + (String)object);
        }
        String string = constantPool.getClassName(dataInputStream.readUnsignedShort());
        this.superclass = string != null ? ClassInfo.forName(string) : null;
        int n4 = dataInputStream.readUnsignedShort();
        this.interfaces = new ClassInfo[n4];
        int n5 = 0;
        while (n5 < n4) {
            this.interfaces[n5] = ClassInfo.forName(constantPool.getClassName(dataInputStream.readUnsignedShort()));
            ++n5;
        }
        this.status |= 1;
        if ((n & 0x92) != 0) {
            int n6 = dataInputStream.readUnsignedShort();
            if ((this.status & 2) == 0) {
                this.fields = new FieldInfo[n6];
            }
            n2 = 0;
            while (n2 < n6) {
                if ((this.status & 2) == 0) {
                    this.fields[n2] = new FieldInfo(this);
                }
                this.fields[n2].read(constantPool, dataInputStream, n);
                ++n2;
            }
        } else {
            object = new byte[6];
            n2 = dataInputStream.readUnsignedShort();
            n4 = 0;
            while (n4 < n2) {
                dataInputStream.readFully((byte[])object);
                this.skipAttributes(dataInputStream);
                ++n4;
            }
        }
        if ((n & 0x94) != 0) {
            int n7 = dataInputStream.readUnsignedShort();
            if ((this.status & 4) == 0) {
                this.methods = new MethodInfo[n7];
            }
            n2 = 0;
            while (n2 < n7) {
                if ((this.status & 4) == 0) {
                    this.methods[n2] = new MethodInfo(this);
                }
                this.methods[n2].read(constantPool, dataInputStream, n);
                ++n2;
            }
        } else {
            byte[] byArray = new byte[6];
            n2 = dataInputStream.readUnsignedShort();
            n4 = 0;
            while (n4 < n2) {
                dataInputStream.readFully(byArray);
                this.skipAttributes(dataInputStream);
                ++n4;
            }
        }
        this.readAttributes(constantPool, dataInputStream, n);
        this.status |= n;
    }

    public void reserveSmallConstants(GrowableConstantPool growableConstantPool) {
        int n = 0;
        while (n < this.fields.length) {
            this.fields[n].reserveSmallConstants(growableConstantPool);
            ++n;
        }
        n = 0;
        while (n < this.methods.length) {
            this.methods[n].reserveSmallConstants(growableConstantPool);
            ++n;
        }
    }

    public void prepareWriting(GrowableConstantPool growableConstantPool) {
        growableConstantPool.putClassName(this.name);
        growableConstantPool.putClassName(this.superclass.getName());
        int n = 0;
        while (n < this.interfaces.length) {
            growableConstantPool.putClassName(this.interfaces[n].getName());
            ++n;
        }
        n = 0;
        while (n < this.fields.length) {
            this.fields[n].prepareWriting(growableConstantPool);
            ++n;
        }
        n = 0;
        while (n < this.methods.length) {
            this.methods[n].prepareWriting(growableConstantPool);
            ++n;
        }
        if (this.sourceFile != null) {
            growableConstantPool.putUTF8("SourceFile");
            growableConstantPool.putUTF8(this.sourceFile);
        }
        if (this.outerClasses != null || this.innerClasses != null || this.extraClasses != null) {
            growableConstantPool.putUTF8("InnerClasses");
            int n2 = n = this.outerClasses != null ? this.outerClasses.length : 0;
            while (n2-- > 0) {
                growableConstantPool.putClassName(this.outerClasses[n2].inner);
                if (this.outerClasses[n2].outer != null) {
                    growableConstantPool.putClassName(this.outerClasses[n2].outer);
                }
                if (this.outerClasses[n2].name == null) continue;
                growableConstantPool.putUTF8(this.outerClasses[n2].name);
            }
            n2 = this.innerClasses != null ? this.innerClasses.length : 0;
            int n3 = 0;
            while (n3 < n2) {
                growableConstantPool.putClassName(this.innerClasses[n3].inner);
                if (this.innerClasses[n3].outer != null) {
                    growableConstantPool.putClassName(this.innerClasses[n3].outer);
                }
                if (this.innerClasses[n3].name != null) {
                    growableConstantPool.putUTF8(this.innerClasses[n3].name);
                }
                ++n3;
            }
            n3 = this.extraClasses != null ? this.extraClasses.length : 0;
            int n4 = 0;
            while (n4 < n3) {
                growableConstantPool.putClassName(this.extraClasses[n4].inner);
                if (this.extraClasses[n4].outer != null) {
                    growableConstantPool.putClassName(this.extraClasses[n4].outer);
                }
                if (this.extraClasses[n4].name != null) {
                    growableConstantPool.putUTF8(this.extraClasses[n4].name);
                }
                ++n4;
            }
        }
        if (this.deprecatedFlag) {
            growableConstantPool.putUTF8("Deprecated");
        }
        this.prepareAttributes(growableConstantPool);
    }

    protected int getKnownAttributeCount() {
        int n = 0;
        if (this.sourceFile != null) {
            ++n;
        }
        if (this.innerClasses != null || this.outerClasses != null || this.extraClasses != null) {
            ++n;
        }
        return n;
    }

    public void writeKnownAttributes(GrowableConstantPool growableConstantPool, DataOutputStream dataOutputStream) throws IOException {
        if (this.sourceFile != null) {
            dataOutputStream.writeShort(growableConstantPool.putUTF8("SourceFile"));
            dataOutputStream.writeInt(2);
            dataOutputStream.writeShort(growableConstantPool.putUTF8(this.sourceFile));
        }
        if (this.outerClasses != null || this.innerClasses != null || this.extraClasses != null) {
            dataOutputStream.writeShort(growableConstantPool.putUTF8("InnerClasses"));
            int n = this.outerClasses != null ? this.outerClasses.length : 0;
            int n2 = this.innerClasses != null ? this.innerClasses.length : 0;
            int n3 = this.extraClasses != null ? this.extraClasses.length : 0;
            int n4 = n + n2 + n3;
            dataOutputStream.writeInt(2 + n4 * 8);
            dataOutputStream.writeShort(n4);
            int n5 = n;
            while (n5-- > 0) {
                dataOutputStream.writeShort(growableConstantPool.putClassName(this.outerClasses[n5].inner));
                dataOutputStream.writeShort(this.outerClasses[n5].outer != null ? growableConstantPool.putClassName(this.outerClasses[n5].outer) : 0);
                dataOutputStream.writeShort(this.outerClasses[n5].name != null ? growableConstantPool.putUTF8(this.outerClasses[n5].name) : 0);
                dataOutputStream.writeShort(this.outerClasses[n5].modifiers);
            }
            n5 = 0;
            while (n5 < n2) {
                dataOutputStream.writeShort(growableConstantPool.putClassName(this.innerClasses[n5].inner));
                dataOutputStream.writeShort(this.innerClasses[n5].outer != null ? growableConstantPool.putClassName(this.innerClasses[n5].outer) : 0);
                dataOutputStream.writeShort(this.innerClasses[n5].name != null ? growableConstantPool.putUTF8(this.innerClasses[n5].name) : 0);
                dataOutputStream.writeShort(this.innerClasses[n5].modifiers);
                ++n5;
            }
            n5 = 0;
            while (n5 < n3) {
                dataOutputStream.writeShort(growableConstantPool.putClassName(this.extraClasses[n5].inner));
                dataOutputStream.writeShort(this.extraClasses[n5].outer != null ? growableConstantPool.putClassName(this.extraClasses[n5].outer) : 0);
                dataOutputStream.writeShort(this.extraClasses[n5].name != null ? growableConstantPool.putUTF8(this.extraClasses[n5].name) : 0);
                dataOutputStream.writeShort(this.extraClasses[n5].modifiers);
                ++n5;
            }
        }
        if (this.deprecatedFlag) {
            dataOutputStream.writeShort(growableConstantPool.putUTF8("Deprecated"));
            dataOutputStream.writeInt(0);
        }
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        GrowableConstantPool growableConstantPool = new GrowableConstantPool();
        this.reserveSmallConstants(growableConstantPool);
        this.prepareWriting(growableConstantPool);
        dataOutputStream.writeInt(-889275714);
        dataOutputStream.writeShort(3);
        dataOutputStream.writeShort(45);
        growableConstantPool.write(dataOutputStream);
        dataOutputStream.writeShort(this.modifiers);
        dataOutputStream.writeShort(growableConstantPool.putClassName(this.name));
        dataOutputStream.writeShort(growableConstantPool.putClassName(this.superclass.getName()));
        dataOutputStream.writeShort(this.interfaces.length);
        int n = 0;
        while (n < this.interfaces.length) {
            dataOutputStream.writeShort(growableConstantPool.putClassName(this.interfaces[n].getName()));
            ++n;
        }
        dataOutputStream.writeShort(this.fields.length);
        n = 0;
        while (n < this.fields.length) {
            this.fields[n].write(growableConstantPool, dataOutputStream);
            ++n;
        }
        dataOutputStream.writeShort(this.methods.length);
        n = 0;
        while (n < this.methods.length) {
            this.methods[n].write(growableConstantPool, dataOutputStream);
            ++n;
        }
        this.writeAttributes(growableConstantPool, dataOutputStream);
    }

    public void loadInfoReflection(Class clazz, int n) throws SecurityException {
        String string;
        Class<?> clazz2;
        int n2;
        AnnotatedElement[] annotatedElementArray;
        if ((n & 1) != 0) {
            this.modifiers = clazz.getModifiers();
            this.superclass = clazz.getSuperclass() == null ? (clazz == (class$Ljava$lang$Object != null ? class$Ljava$lang$Object : (class$Ljava$lang$Object = ClassInfo.class$("java.lang.Object"))) ? null : javaLangObject) : ClassInfo.forName(clazz.getSuperclass().getName());
            annotatedElementArray = clazz.getInterfaces();
            this.interfaces = new ClassInfo[annotatedElementArray.length];
            n2 = 0;
            while (n2 < annotatedElementArray.length) {
                this.interfaces[n2] = ClassInfo.forName(((Class)annotatedElementArray[n2]).getName());
                ++n2;
            }
            this.status |= 1;
        }
        if ((n & 2) != 0 && this.fields == null) {
            try {
                annotatedElementArray = clazz.getDeclaredFields();
            }
            catch (SecurityException securityException) {
                annotatedElementArray = clazz.getFields();
                GlobalOptions.err.println("Could only get public fields of class " + this.name + ".");
            }
            this.fields = new FieldInfo[annotatedElementArray.length];
            n2 = annotatedElementArray.length;
            while (--n2 >= 0) {
                clazz2 = TypeSignature.getSignature(((Field)annotatedElementArray[n2]).getType());
                this.fields[n2] = new FieldInfo(this, ((Field)annotatedElementArray[n2]).getName(), (String)((Object)clazz2), ((Field)annotatedElementArray[n2]).getModifiers());
            }
        }
        if ((n & 4) != 0 && this.methods == null) {
            String string2;
            Method[] methodArray;
            try {
                annotatedElementArray = clazz.getDeclaredConstructors();
                methodArray = clazz.getDeclaredMethods();
            }
            catch (SecurityException securityException) {
                annotatedElementArray = clazz.getConstructors();
                methodArray = clazz.getMethods();
                GlobalOptions.err.println("Could only get public methods of class " + this.name + ".");
            }
            this.methods = new MethodInfo[annotatedElementArray.length + methodArray.length];
            int n3 = annotatedElementArray.length;
            while (--n3 >= 0) {
                string2 = TypeSignature.getSignature(((Constructor)annotatedElementArray[n3]).getParameterTypes(), Void.TYPE);
                this.methods[n3] = new MethodInfo(this, "<init>", string2, ((Constructor)annotatedElementArray[n3]).getModifiers());
            }
            n3 = methodArray.length;
            while (--n3 >= 0) {
                string2 = TypeSignature.getSignature(methodArray[n3].getParameterTypes(), methodArray[n3].getReturnType());
                this.methods[annotatedElementArray.length + n3] = new MethodInfo(this, methodArray[n3].getName(), string2, methodArray[n3].getModifiers());
            }
        }
        if ((n & 0x20) != 0 && this.innerClasses == null) {
            try {
                annotatedElementArray = clazz.getDeclaredClasses();
            }
            catch (SecurityException securityException) {
                annotatedElementArray = clazz.getClasses();
                GlobalOptions.err.println("Could only get public inner classes of class " + this.name + ".");
            }
            if (annotatedElementArray.length > 0) {
                this.innerClasses = new InnerClassInfo[annotatedElementArray.length];
                int n4 = annotatedElementArray.length;
                while (--n4 >= 0) {
                    clazz2 = ((Class)annotatedElementArray[n4]).getName();
                    int n5 = ((String)((Object)clazz2)).lastIndexOf(36);
                    string = ((String)((Object)clazz2)).substring(n5 + 1);
                    this.innerClasses[n4] = new InnerClassInfo((String)((Object)clazz2), this.getName(), string, ((Class)annotatedElementArray[n4]).getModifiers());
                }
            }
        }
        if ((n & 0x40) != 0 && this.outerClasses == null) {
            int n6 = 0;
            Class<?> clazz3 = clazz.getDeclaringClass();
            while (clazz3 != null) {
                ++n6;
                clazz3 = clazz3.getDeclaringClass();
            }
            if (n6 > 0) {
                this.outerClasses = new InnerClassInfo[n6];
                clazz2 = clazz;
                int n7 = 0;
                while (n7 < n6) {
                    clazz3 = clazz2.getDeclaringClass();
                    string = clazz2.getName();
                    int n8 = string.lastIndexOf(36);
                    this.outerClasses[n7] = new InnerClassInfo(string, clazz3.getName(), string.substring(n8 + 1), clazz2.getModifiers());
                    clazz2 = clazz3;
                    ++n7;
                }
            }
        }
        this.status |= n;
    }

    public void loadInfo(int n) {
        if ((this.status & n) == n) {
            return;
        }
        if (this.modified) {
            System.err.println("Allocating info 0x" + Integer.toHexString(n) + " (status 0x" + Integer.toHexString(this.status) + ") in class " + this);
            Thread.dumpStack();
            return;
        }
        try {
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(classpath.getFile(this.name.replace('.', '/') + ".class")));
            this.read(dataInputStream, n);
        }
        catch (IOException iOException) {
            String string = iOException.getMessage();
            if ((n & 0xFFFFFF98) != 0) {
                throw new NoClassDefFoundError(this.name);
            }
            Class<?> clazz = null;
            try {
                clazz = Class.forName(this.name);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            try {
                if (clazz != null) {
                    this.loadInfoReflection(clazz, n);
                    return;
                }
            }
            catch (SecurityException securityException) {
                GlobalOptions.err.println(securityException + " while collecting info about class " + this.name + ".");
            }
            GlobalOptions.err.println("Can't read class " + this.name + ", types may be incorrect. (" + iOException.getClass().getName() + (string != null ? ": " + string : "") + ")");
            iOException.printStackTrace(GlobalOptions.err);
            if ((n & 1) != 0) {
                this.modifiers = 1;
                this.superclass = this.name.equals("java.lang.Object") ? null : javaLangObject;
                this.interfaces = new ClassInfo[0];
            }
            if ((n & 4) != 0) {
                this.methods = new MethodInfo[0];
            }
            if ((n & 2) != 0) {
                this.fields = new FieldInfo[0];
            }
            this.status |= n;
        }
    }

    public void dropInfo(int n) {
        int n2;
        if ((this.status & n) == 0) {
            return;
        }
        if (this.modified) {
            System.err.println("Dropping info 0x" + Integer.toHexString(n) + " (status 0x" + Integer.toHexString(this.status) + ") in class " + this);
            Thread.dumpStack();
            return;
        }
        if (((n &= this.status) & 2) != 0) {
            this.fields = null;
        } else if ((this.status & 2) != 0 && (n & 0x90) != 0) {
            n2 = 0;
            while (n2 < this.fields.length) {
                this.fields[n2].dropInfo(n);
                ++n2;
            }
        }
        if ((n & 4) != 0) {
            this.methods = null;
        } else if ((this.status & 4) != 0 && (n & 0x90) != 0) {
            n2 = 0;
            while (n2 < this.methods.length) {
                this.methods[n2].dropInfo(n);
                ++n2;
            }
        }
        if ((n & 0x10) != 0) {
            this.sourceFile = null;
        }
        if ((n & 0x40) != 0) {
            this.outerClasses = null;
        }
        if ((n & 0x20) != 0) {
            this.innerClasses = null;
            this.extraClasses = null;
        }
        super.dropInfo(n);
        this.status &= ~n;
    }

    public String getName() {
        return this.name;
    }

    public String getJavaName() {
        if (this.name.indexOf(36) == -1) {
            return this.getName();
        }
        if (this.getOuterClasses() != null) {
            int n = this.outerClasses.length - 1;
            StringBuffer stringBuffer = new StringBuffer(this.outerClasses[n].outer != null ? this.outerClasses[n].outer : "METHOD");
            int n2 = n;
            while (n2 >= 0) {
                stringBuffer.append(".").append(this.outerClasses[n2].name != null ? this.outerClasses[n2].name : "ANONYMOUS");
                --n2;
            }
            return stringBuffer.toString();
        }
        return this.getName();
    }

    public ClassInfo getSuperclass() {
        if ((this.status & 1) == 0) {
            this.loadInfo(1);
        }
        return this.superclass;
    }

    public ClassInfo[] getInterfaces() {
        if ((this.status & 1) == 0) {
            this.loadInfo(1);
        }
        return this.interfaces;
    }

    public int getModifiers() {
        if ((this.status & 1) == 0) {
            this.loadInfo(1);
        }
        return this.modifiers;
    }

    public boolean isInterface() {
        return Modifier.isInterface(this.getModifiers());
    }

    public boolean isDeprecated() {
        return this.deprecatedFlag;
    }

    public FieldInfo findField(String string, String string2) {
        if ((this.status & 2) == 0) {
            this.loadInfo(2);
        }
        int n = 0;
        while (n < this.fields.length) {
            if (this.fields[n].getName().equals(string) && this.fields[n].getType().equals(string2)) {
                return this.fields[n];
            }
            ++n;
        }
        return null;
    }

    public MethodInfo findMethod(String string, String string2) {
        if ((this.status & 4) == 0) {
            this.loadInfo(4);
        }
        int n = 0;
        while (n < this.methods.length) {
            if (this.methods[n].getName().equals(string) && this.methods[n].getType().equals(string2)) {
                return this.methods[n];
            }
            ++n;
        }
        return null;
    }

    public MethodInfo[] getMethods() {
        if ((this.status & 4) == 0) {
            this.loadInfo(4);
        }
        return this.methods;
    }

    public FieldInfo[] getFields() {
        if ((this.status & 2) == 0) {
            this.loadInfo(2);
        }
        return this.fields;
    }

    public InnerClassInfo[] getOuterClasses() {
        if ((this.status & 0x40) == 0) {
            this.loadInfo(64);
        }
        return this.outerClasses;
    }

    public InnerClassInfo[] getInnerClasses() {
        if ((this.status & 0x20) == 0) {
            this.loadInfo(32);
        }
        return this.innerClasses;
    }

    public InnerClassInfo[] getExtraClasses() {
        if ((this.status & 0x20) == 0) {
            this.loadInfo(32);
        }
        return this.extraClasses;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public void setName(String string) {
        this.name = string;
        this.modified = true;
    }

    public void setSuperclass(ClassInfo classInfo) {
        this.superclass = classInfo;
        this.modified = true;
    }

    public void setInterfaces(ClassInfo[] classInfoArray) {
        this.interfaces = classInfoArray;
        this.modified = true;
    }

    public void setModifiers(int n) {
        this.modifiers = n;
        this.modified = true;
    }

    public void setDeprecated(boolean bl) {
        this.deprecatedFlag = bl;
    }

    public void setMethods(MethodInfo[] methodInfoArray) {
        this.methods = methodInfoArray;
        this.modified = true;
    }

    public void setFields(FieldInfo[] fieldInfoArray) {
        this.fields = fieldInfoArray;
        this.modified = true;
    }

    public void setOuterClasses(InnerClassInfo[] innerClassInfoArray) {
        this.outerClasses = innerClassInfoArray;
        this.modified = true;
    }

    public void setInnerClasses(InnerClassInfo[] innerClassInfoArray) {
        this.innerClasses = innerClassInfoArray;
        this.modified = true;
    }

    public void setExtraClasses(InnerClassInfo[] innerClassInfoArray) {
        this.extraClasses = innerClassInfoArray;
        this.modified = true;
    }

    public void setSourceFile(String string) {
        this.sourceFile = string;
        this.modified = true;
    }

    public boolean superClassOf(ClassInfo classInfo) {
        while (classInfo != this && classInfo != null) {
            classInfo = classInfo.getSuperclass();
        }
        return classInfo == this;
    }

    public boolean implementedBy(ClassInfo classInfo) {
        while (classInfo != this && classInfo != null) {
            ClassInfo[] classInfoArray = classInfo.getInterfaces();
            int n = 0;
            while (n < classInfoArray.length) {
                if (this.implementedBy(classInfoArray[n])) {
                    return true;
                }
                ++n;
            }
            classInfo = classInfo.getSuperclass();
        }
        return classInfo == this;
    }

    public String toString() {
        return this.name;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private ClassInfo(String string) {
        this.name = string;
    }

    static {
        classes = new UnifyHash();
        javaLangObject = ClassInfo.forName("java.lang.Object");
    }
}

