/*
 * Decompiled with CFR 0.152.
 */
package jode.flow;

import java.io.IOException;
import jode.decompiler.TabbedPrintWriter;
import jode.expr.Expression;
import jode.expr.InvokeOperator;
import jode.expr.LocalLoadOperator;
import jode.flow.CatchBlock;
import jode.flow.FlowBlock;
import jode.flow.InstructionBlock;
import jode.flow.StructuredBlock;
import jode.flow.ThrowBlock;
import jode.flow.VariableSet;
import jode.flow.VariableStack;
import jode.type.Type;

public class TryBlock
extends StructuredBlock {
    VariableSet gen;
    StructuredBlock[] subBlocks = new StructuredBlock[1];

    public void addCatchBlock(StructuredBlock structuredBlock) {
        StructuredBlock[] structuredBlockArray = new StructuredBlock[this.subBlocks.length + 1];
        System.arraycopy(this.subBlocks, 0, structuredBlockArray, 0, this.subBlocks.length);
        structuredBlockArray[this.subBlocks.length] = structuredBlock;
        this.subBlocks = structuredBlockArray;
        structuredBlock.outer = this;
        structuredBlock.setFlowBlock(this.flowBlock);
    }

    public boolean replaceSubBlock(StructuredBlock structuredBlock, StructuredBlock structuredBlock2) {
        int n = 0;
        while (n < this.subBlocks.length) {
            if (this.subBlocks[n] == structuredBlock) {
                this.subBlocks[n] = structuredBlock2;
                return true;
            }
            ++n;
        }
        return false;
    }

    public StructuredBlock[] getSubBlocks() {
        return this.subBlocks;
    }

    public VariableStack mapStackToLocal(VariableStack variableStack) {
        VariableStack variableStack2 = this.subBlocks[0].mapStackToLocal(variableStack);
        int n = 1;
        while (n < this.subBlocks.length) {
            variableStack2 = VariableStack.merge(variableStack2, this.subBlocks[n].mapStackToLocal(VariableStack.EMPTY));
            ++n;
        }
        if (this.jump != null) {
            this.jump.stackMap = variableStack2;
            return null;
        }
        return variableStack2;
    }

    public void dumpInstruction(TabbedPrintWriter tabbedPrintWriter) throws IOException {
        tabbedPrintWriter.print("try");
        tabbedPrintWriter.openBrace();
        tabbedPrintWriter.tab();
        this.subBlocks[0].dumpSource(tabbedPrintWriter);
        tabbedPrintWriter.untab();
        int n = 1;
        while (n < this.subBlocks.length) {
            this.subBlocks[n].dumpSource(tabbedPrintWriter);
            ++n;
        }
        tabbedPrintWriter.closeBrace();
    }

    public boolean jumpMayBeChanged() {
        int n = 0;
        while (n < this.subBlocks.length) {
            if (this.subBlocks[n].jump == null && !this.subBlocks[n].jumpMayBeChanged()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean checkJikesArrayClone() {
        if (this.subBlocks.length != 2 || !(this.subBlocks[0] instanceof InstructionBlock) || !(this.subBlocks[1] instanceof CatchBlock)) {
            return false;
        }
        Expression expression = ((InstructionBlock)this.subBlocks[0]).getInstruction();
        CatchBlock catchBlock = (CatchBlock)this.subBlocks[1];
        if (expression.isVoid() || expression.getFreeOperandCount() != 0 || !(expression instanceof InvokeOperator) || !(catchBlock.catchBlock instanceof ThrowBlock) || !catchBlock.exceptionType.equals(Type.tClass("java.lang.CloneNotSupportedException"))) {
            return false;
        }
        InvokeOperator invokeOperator = (InvokeOperator)expression;
        if (!invokeOperator.getMethodName().equals("clone") || invokeOperator.isStatic() || !invokeOperator.getMethodType().getTypeSignature().equals("()Ljava/lang/Object;") || !invokeOperator.getSubExpressions()[0].getType().isOfType(Type.tArray(Type.tUnknown))) {
            return false;
        }
        Expression expression2 = ((ThrowBlock)catchBlock.catchBlock).getInstruction();
        if (expression2.getFreeOperandCount() != 0 || !(expression2 instanceof InvokeOperator)) {
            return false;
        }
        InvokeOperator invokeOperator2 = (InvokeOperator)expression2;
        if (!invokeOperator2.isConstructor() || !invokeOperator2.getClassType().equals(Type.tClass("java.lang.InternalError")) || invokeOperator2.getMethodType().getParameterTypes().length != 1) {
            return false;
        }
        Expression expression3 = invokeOperator2.getSubExpressions()[1];
        if (!(expression3 instanceof InvokeOperator)) {
            return false;
        }
        InvokeOperator invokeOperator3 = (InvokeOperator)expression3;
        if (!invokeOperator3.getMethodName().equals("getMessage") || invokeOperator3.isStatic() || invokeOperator3.getMethodType().getParameterTypes().length != 0 || invokeOperator3.getMethodType().getReturnType() != Type.tString) {
            return false;
        }
        Expression expression4 = invokeOperator3.getSubExpressions()[0];
        if (!(expression4 instanceof LocalLoadOperator) || !((LocalLoadOperator)expression4).getLocalInfo().equals(catchBlock.exceptionLocal)) {
            return false;
        }
        this.subBlocks[0].replace(this);
        if (this.flowBlock.lastModified == this) {
            this.flowBlock.lastModified = this.subBlocks[0];
        }
        return true;
    }

    public boolean doTransformations() {
        return this.checkJikesArrayClone();
    }

    public TryBlock(FlowBlock flowBlock) {
        this.gen = (VariableSet)flowBlock.gen.clone();
        this.flowBlock = flowBlock;
        StructuredBlock structuredBlock = flowBlock.block;
        this.replace(structuredBlock);
        this.subBlocks = new StructuredBlock[]{structuredBlock};
        structuredBlock.outer = this;
        flowBlock.lastModified = this;
        flowBlock.checkConsistent();
    }
}

