/*
 * Decompiled with CFR 0.152.
 */
package jode.bytecode;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import jode.bytecode.ConstantPool;
import jode.bytecode.GrowableConstantPool;
import jode.util.SimpleMap;

public class BinaryInfo {
    public static final int HIERARCHY = 1;
    public static final int FIELDS = 2;
    public static final int METHODS = 4;
    public static final int CONSTANTS = 8;
    public static final int KNOWNATTRIBS = 16;
    public static final int INNERCLASSES = 32;
    public static final int OUTERCLASSES = 64;
    public static final int UNKNOWNATTRIBS = 128;
    public static final int FULLINFO = 255;
    public static final int MOSTINFO = 127;
    public static final int REFLECTINFO = 111;
    private Map unknownAttributes = null;

    protected void skipAttributes(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        int n2 = 0;
        while (n2 < n) {
            dataInputStream.readUnsignedShort();
            long l = dataInputStream.readInt();
            while (l > 0L) {
                long l2 = dataInputStream.skip(l);
                if (l2 == 0L) {
                    throw new EOFException("Can't skip. EOF?");
                }
                l -= l2;
            }
            ++n2;
        }
    }

    protected int getKnownAttributeCount() {
        return 0;
    }

    protected void readAttribute(String string, int n, ConstantPool constantPool, DataInputStream dataInputStream, int n2) throws IOException {
        byte[] byArray = new byte[n];
        dataInputStream.readFully(byArray);
        if ((n2 & 0x80) != 0) {
            if (this.unknownAttributes == null) {
                this.unknownAttributes = new SimpleMap();
            }
            this.unknownAttributes.put(string, byArray);
        }
    }

    protected void readAttributes(ConstantPool constantPool, DataInputStream dataInputStream, int n) throws IOException {
        int n2 = dataInputStream.readUnsignedShort();
        this.unknownAttributes = null;
        int n3 = 0;
        while (n3 < n2) {
            String string = constantPool.getUTF8(dataInputStream.readUnsignedShort());
            int n4 = dataInputStream.readInt();
            ConstrainedInputStream constrainedInputStream = new ConstrainedInputStream(n4, dataInputStream);
            this.readAttribute(string, n4, constantPool, new DataInputStream(constrainedInputStream), n);
            constrainedInputStream.skipRemaining();
            ++n3;
        }
    }

    public void dropInfo(int n) {
        if ((n & 0x80) != 0) {
            this.unknownAttributes = null;
        }
    }

    protected void prepareAttributes(GrowableConstantPool growableConstantPool) {
        if (this.unknownAttributes == null) {
            return;
        }
        Iterator iterator = this.unknownAttributes.keySet().iterator();
        while (iterator.hasNext()) {
            growableConstantPool.putUTF8((String)iterator.next());
        }
    }

    protected void writeKnownAttributes(GrowableConstantPool growableConstantPool, DataOutputStream dataOutputStream) throws IOException {
    }

    protected void writeAttributes(GrowableConstantPool growableConstantPool, DataOutputStream dataOutputStream) throws IOException {
        int n = this.getKnownAttributeCount();
        if (this.unknownAttributes != null) {
            n += this.unknownAttributes.size();
        }
        dataOutputStream.writeShort(n);
        this.writeKnownAttributes(growableConstantPool, dataOutputStream);
        if (this.unknownAttributes != null) {
            Iterator iterator = this.unknownAttributes.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                byte[] byArray = (byte[])entry.getValue();
                dataOutputStream.writeShort(growableConstantPool.putUTF8(string));
                dataOutputStream.writeInt(byArray.length);
                dataOutputStream.write(byArray);
            }
        }
    }

    public int getAttributeSize() {
        int n = 2;
        if (this.unknownAttributes != null) {
            Iterator iterator = this.unknownAttributes.values().iterator();
            while (iterator.hasNext()) {
                n += 6 + ((byte[])iterator.next()).length;
            }
        }
        return n;
    }

    public byte[] findAttribute(String string) {
        if (this.unknownAttributes != null) {
            return (byte[])this.unknownAttributes.get(string);
        }
        return null;
    }

    public Iterator getAttributes() {
        if (this.unknownAttributes != null) {
            return this.unknownAttributes.values().iterator();
        }
        return Collections.EMPTY_SET.iterator();
    }

    public void setAttribute(String string, byte[] byArray) {
        if (this.unknownAttributes == null) {
            this.unknownAttributes = new SimpleMap();
        }
        this.unknownAttributes.put(string, byArray);
    }

    public byte[] removeAttribute(String string) {
        if (this.unknownAttributes != null) {
            return (byte[])this.unknownAttributes.remove(string);
        }
        return null;
    }

    public void removeAllAttributes() {
        this.unknownAttributes = null;
    }

    static class ConstrainedInputStream
    extends FilterInputStream {
        int length;

        public int read() throws IOException {
            if (this.length > 0) {
                int n = super.read();
                --this.length;
                return n;
            }
            throw new EOFException();
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.length < n2) {
                n2 = this.length;
            }
            if (n2 == 0) {
                return -1;
            }
            int n3 = super.read(byArray, n, n2);
            this.length -= n3;
            return n3;
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public long skip(long l) throws IOException {
            if ((long)this.length < l) {
                l = this.length;
            }
            l = super.skip(l);
            this.length -= (int)l;
            return l;
        }

        public void skipRemaining() throws IOException {
            while (this.length > 0) {
                int n = (int)this.skip(this.length);
                if (n == 0) {
                    throw new EOFException();
                }
                this.length -= n;
            }
        }

        public ConstrainedInputStream(int n, InputStream inputStream) {
            super(inputStream);
            this.length = n;
        }
    }
}

