/*
 * Decompiled with CFR 0.152.
 */
package jode.expr;

import java.io.IOException;
import jode.decompiler.TabbedPrintWriter;
import jode.expr.CompareBinaryOperator;
import jode.expr.CompareToIntOperator;
import jode.expr.Expression;
import jode.expr.Operator;
import jode.type.Type;

public class CompareUnaryOperator
extends Operator {
    boolean objectType;
    Type compareType;

    public int getPriority() {
        switch (this.getOperatorIndex()) {
            case 26: 
            case 27: {
                return 500;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                return 550;
            }
        }
        throw new RuntimeException("Illegal operator");
    }

    public Type getCompareType() {
        return this.compareType;
    }

    public void updateSubTypes() {
        this.subExpressions[0].setType(Type.tSubType(this.compareType));
    }

    public void updateType() {
    }

    public Expression simplify() {
        if (this.subExpressions[0] instanceof CompareToIntOperator) {
            CompareToIntOperator compareToIntOperator = (CompareToIntOperator)this.subExpressions[0];
            boolean bl = false;
            int n = this.getOperatorIndex();
            if (compareToIntOperator.allowsNaN && this.getOperatorIndex() > 27 && compareToIntOperator.greaterOnNaN == (n == 29 || n == 30)) {
                bl = true;
                n ^= 1;
            }
            Expression expression = new CompareBinaryOperator(compareToIntOperator.compareType, n, compareToIntOperator.allowsNaN).addOperand(compareToIntOperator.subExpressions[1]).addOperand(compareToIntOperator.subExpressions[0]);
            if (bl) {
                return expression.negate().simplify();
            }
            return expression.simplify();
        }
        if (this.subExpressions[0].getType().isOfType(Type.tBoolean)) {
            if (this.getOperatorIndex() == 26) {
                return this.subExpressions[0].negate().simplify();
            }
            if (this.getOperatorIndex() == 27) {
                return this.subExpressions[0].simplify();
            }
        }
        return super.simplify();
    }

    public Expression negate() {
        if (this.getType() != Type.tFloat && this.getType() != Type.tDouble || this.getOperatorIndex() <= 27) {
            this.setOperatorIndex(this.getOperatorIndex() ^ 1);
            return this;
        }
        return super.negate();
    }

    public boolean opEquals(Operator operator) {
        return operator instanceof CompareUnaryOperator && operator.getOperatorIndex() == this.getOperatorIndex();
    }

    public void dumpExpression(TabbedPrintWriter tabbedPrintWriter) throws IOException {
        this.subExpressions[0].dumpExpression(tabbedPrintWriter, this.getPriority() + 1);
        tabbedPrintWriter.breakOp();
        tabbedPrintWriter.print(this.getOperatorString());
        tabbedPrintWriter.print(this.objectType ? "null" : "0");
    }

    public CompareUnaryOperator(Type type, int n) {
        super(Type.tBoolean, n);
        this.compareType = type;
        this.objectType = type.isOfType(Type.tUObject);
        this.initOperands(1);
    }
}

