/*
 * Decompiled with CFR 0.152.
 */
package jode.flow;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import jode.AssertError;
import jode.decompiler.LocalInfo;
import jode.flow.SlotSet;

public final class VariableSet
extends AbstractSet
implements Cloneable {
    LocalInfo[] locals;
    int count;

    public final void grow(int n) {
        if (this.locals != null) {
            if ((n += this.count) > this.locals.length) {
                int n2 = this.locals.length * 2;
                LocalInfo[] localInfoArray = new LocalInfo[n2 > n ? n2 : n];
                System.arraycopy(this.locals, 0, localInfoArray, 0, this.count);
                this.locals = localInfoArray;
            }
        } else if (n > 0) {
            this.locals = new LocalInfo[n];
        }
    }

    public boolean add(Object object) {
        if (this.contains(object)) {
            return false;
        }
        this.grow(1);
        this.locals[this.count++] = (LocalInfo)object;
        return true;
    }

    public boolean contains(Object object) {
        object = ((LocalInfo)object).getLocalInfo();
        int n = 0;
        while (n < this.count) {
            if (this.locals[n].getLocalInfo() == object) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public final boolean containsSlot(int n) {
        return this.findSlot(n) != null;
    }

    public LocalInfo findLocal(String string) {
        int n = 0;
        while (n < this.count) {
            if (this.locals[n].getName().equals(string)) {
                return this.locals[n];
            }
            ++n;
        }
        return null;
    }

    public LocalInfo findSlot(int n) {
        int n2 = 0;
        while (n2 < this.count) {
            if (this.locals[n2].getSlot() == n) {
                return this.locals[n2];
            }
            ++n2;
        }
        return null;
    }

    public boolean remove(Object object) {
        object = ((LocalInfo)object).getLocalInfo();
        int n = 0;
        while (n < this.count) {
            if (this.locals[n].getLocalInfo() == object) {
                this.locals[n] = this.locals[--this.count];
                this.locals[this.count] = null;
                return true;
            }
            ++n;
        }
        return false;
    }

    public int size() {
        return this.count;
    }

    public Iterator iterator() {
        VariableSet variableSet = this;
        if (variableSet == null) {
            throw null;
        }
        return new Iterator(variableSet){
            int pos;
            private final /* synthetic */ VariableSet this$0;

            public boolean hasNext() {
                return this.pos < this.this$0.count;
            }

            public Object next() {
                return this.this$0.locals[this.pos++];
            }

            public void remove() {
                if (this.pos < this.this$0.count) {
                    System.arraycopy(this.this$0.locals, this.pos, this.this$0.locals, this.pos - 1, this.this$0.count - this.pos);
                }
                --this.this$0.count;
                --this.pos;
                this.this$0.locals[this.this$0.count] = null;
            }
            {
                this.this$0 = variableSet;
                this.pos = 0;
                this.constructor$0(variableSet);
            }

            private final void constructor$0(VariableSet variableSet) {
            }
        };
    }

    public void clear() {
        this.locals = null;
        this.count = 0;
    }

    public Object clone() {
        try {
            VariableSet variableSet = (VariableSet)super.clone();
            if (this.count > 0) {
                variableSet.locals = new LocalInfo[this.count];
                System.arraycopy(this.locals, 0, variableSet.locals, 0, this.count);
            }
            return variableSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertError("Clone?");
        }
    }

    public VariableSet intersect(VariableSet variableSet) {
        VariableSet variableSet2 = new VariableSet();
        variableSet2.grow(Math.min(this.count, variableSet.count));
        int n = 0;
        while (n < this.count) {
            LocalInfo localInfo = this.locals[n];
            int n2 = localInfo.getSlot();
            if (variableSet.containsSlot(n2) && !variableSet2.containsSlot(n2)) {
                variableSet2.locals[variableSet2.count++] = localInfo.getLocalInfo();
            }
            ++n;
        }
        return variableSet2;
    }

    public void mergeGenKill(Collection collection, SlotSet slotSet) {
        this.grow(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            LocalInfo localInfo = (LocalInfo)iterator.next();
            if (slotSet.containsSlot(localInfo.getSlot())) continue;
            this.add(localInfo.getLocalInfo());
        }
    }

    public VariableSet() {
        this.locals = null;
        this.count = 0;
    }

    public VariableSet(LocalInfo[] localInfoArray) {
        this.count = localInfoArray.length;
        this.locals = localInfoArray;
    }
}

