/*
 * Decompiled with CFR 0.152.
 */
package jode.decompiler;

import java.io.IOException;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.SortedMap;
import java.util.TreeMap;
import jode.GlobalOptions;
import jode.bytecode.ClassInfo;
import jode.decompiler.ClassAnalyzer;
import jode.decompiler.ImportHandler;
import jode.decompiler.TabbedPrintWriter;
import jode.type.ArrayType;
import jode.type.ClassInterfacesType;
import jode.type.NullType;
import jode.type.Type;

public class ImportHandler {
    public static final int DEFAULT_PACKAGE_LIMIT = Integer.MAX_VALUE;
    public static final int DEFAULT_CLASS_LIMIT = 1;
    static Comparator comparator = new 1();
    SortedMap imports;
    Hashtable cachedClassNames = null;
    ClassAnalyzer main;
    String className;
    String pkg;
    int importPackageLimit;
    int importClassLimit;

    private boolean conflictsImport(String string) {
        int n = string.lastIndexOf(46);
        if (n != -1) {
            String string2 = string.substring(0, n);
            if (string2.equals(this.pkg)) {
                return false;
            }
            string = string.substring(n);
            if (this.pkg.length() != 0 ? ClassInfo.exists(this.pkg + string) : ClassInfo.exists(string.substring(1))) {
                return true;
            }
            Iterator iterator = this.imports.keySet().iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                if (!(string3.endsWith(".*") ? !(string3 = string3.substring(0, string3.length() - 2)).equals(string2) && ClassInfo.exists(string3 + string) : string3.endsWith(string) || string3.equals(string.substring(1)))) continue;
                return true;
            }
        }
        return false;
    }

    private void cleanUpImports() {
        Object object;
        String string;
        Integer n = new Integer(Integer.MAX_VALUE);
        TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>(comparator);
        LinkedList<String> linkedList = new LinkedList<String>();
        Iterator<Object> iterator = this.imports.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            object = (Integer)this.imports.get(string);
            if (!string.endsWith(".*")) {
                if ((Integer)object < this.importClassLimit) continue;
                int n2 = string.lastIndexOf(".");
                if (n2 != -1) {
                    if (treeMap.containsKey(string.substring(0, n2) + ".*")) continue;
                    linkedList.add(string);
                    continue;
                }
                if (this.pkg.length() == 0) continue;
                treeMap.put(string, n);
                continue;
            }
            if ((Integer)object < this.importPackageLimit) continue;
            treeMap.put(string, n);
        }
        this.imports = treeMap;
        this.cachedClassNames = new Hashtable();
        iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (this.conflictsImport(string)) continue;
            this.imports.put(string, n);
            object = string.substring(string.lastIndexOf(46) + 1);
            this.cachedClassNames.put(string, object);
        }
    }

    public void dumpHeader(TabbedPrintWriter tabbedPrintWriter) throws IOException {
        tabbedPrintWriter.println("/* " + this.className + " - Decompiled by JODE");
        tabbedPrintWriter.println(" * Visit http://jode.sourceforge.net/");
        tabbedPrintWriter.println(" */");
        if (this.pkg.length() != 0) {
            tabbedPrintWriter.println("package " + this.pkg + ";");
        }
        this.cleanUpImports();
        Iterator iterator = this.imports.keySet().iterator();
        String string = null;
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (string2.equals("java.lang.*")) continue;
            int n = string2.indexOf(46);
            if (n != -1) {
                String string3 = string2.substring(0, n);
                if (string != null && !string.equals(string3)) {
                    tabbedPrintWriter.println("");
                }
                string = string3;
            }
            tabbedPrintWriter.println("import " + string2 + ";");
        }
        tabbedPrintWriter.println("");
    }

    public void error(String string) {
        GlobalOptions.err.println(string);
    }

    public void init(String string) {
        this.imports = new TreeMap(comparator);
        this.imports.put("java.lang.*", new Integer(Integer.MAX_VALUE));
        int n = string.lastIndexOf(46);
        this.pkg = n == -1 ? "" : string.substring(0, n);
        this.className = n == -1 ? string : string.substring(n + 1);
    }

    public void useClass(ClassInfo classInfo) {
        Object object;
        while ((object = classInfo.getOuterClasses()) != null) {
            if (object[0].name == null || object[0].outer == null) {
                return;
            }
            classInfo = ClassInfo.forName(object[0].outer);
        }
        object = classInfo.getName();
        Integer n = (Integer)this.imports.get(object);
        if (n == null) {
            int n2 = ((String)object).lastIndexOf(46);
            if (n2 != -1) {
                String string = ((String)object).substring(0, n2);
                if (string.equals(this.pkg)) {
                    return;
                }
                Integer n3 = (Integer)this.imports.get(string + ".*");
                if (n3 != null && n3 >= this.importPackageLimit) {
                    return;
                }
                n3 = n3 == null ? new Integer(1) : new Integer(n3 + 1);
                this.imports.put(string + ".*", n3);
            }
            n = new Integer(1);
        } else {
            if (n >= this.importClassLimit) {
                return;
            }
            n = new Integer(n + 1);
        }
        this.imports.put(object, n);
    }

    public final void useType(Type type) {
        if (type instanceof ArrayType) {
            this.useType(((ArrayType)type).getElementType());
        } else if (type instanceof ClassInterfacesType) {
            this.useClass(((ClassInterfacesType)type).getClassInfo());
        }
    }

    public String getClassString(ClassInfo classInfo) {
        String string;
        String string2 = classInfo.getName();
        if (this.cachedClassNames == null) {
            return string2;
        }
        String string3 = (String)this.cachedClassNames.get(string2);
        if (string3 != null) {
            return string3;
        }
        int n = string2.lastIndexOf(46);
        if (n != -1 && ((string = string2.substring(0, n)).equals(this.pkg) || this.imports.get(string + ".*") != null && !this.conflictsImport(string2))) {
            String string4 = string2.substring(n + 1);
            this.cachedClassNames.put(string2, string4);
            return string4;
        }
        this.cachedClassNames.put(string2, string2);
        return string2;
    }

    public String getTypeString(Type type) {
        if (type instanceof ArrayType) {
            return this.getTypeString(((ArrayType)type).getElementType()) + "[]";
        }
        if (type instanceof ClassInterfacesType) {
            return this.getClassString(((ClassInterfacesType)type).getClassInfo());
        }
        if (type instanceof NullType) {
            return "Object";
        }
        return type.toString();
    }

    protected int loadFileFlags() {
        return 1;
    }

    public ImportHandler() {
        this(Integer.MAX_VALUE, 1);
    }

    public ImportHandler(int n, int n2) {
        this.importPackageLimit = n;
        this.importClassLimit = n2;
    }
}

