/*
 * Decompiled with CFR 0.152.
 */
package jode.flow;

import jode.GlobalOptions;
import jode.expr.ArrayStoreOperator;
import jode.expr.ConstOperator;
import jode.expr.ConstantArrayOperator;
import jode.expr.Expression;
import jode.expr.NewArrayOperator;
import jode.expr.NopOperator;
import jode.expr.StoreInstruction;
import jode.flow.InstructionBlock;
import jode.flow.InstructionContainer;
import jode.flow.SequentialBlock;
import jode.flow.SpecialBlock;
import jode.flow.StructuredBlock;

public class CreateConstantArray {
    public static boolean transform(InstructionContainer instructionContainer, StructuredBlock structuredBlock) {
        if (structuredBlock.outer instanceof SequentialBlock) {
            ConstantArrayOperator constantArrayOperator;
            SequentialBlock sequentialBlock = (SequentialBlock)structuredBlock.outer;
            if (!(instructionContainer.getInstruction() instanceof StoreInstruction && instructionContainer.getInstruction().getFreeOperandCount() == 1 && sequentialBlock.subBlocks[0] instanceof SpecialBlock && sequentialBlock.outer instanceof SequentialBlock)) {
                return false;
            }
            StoreInstruction storeInstruction = (StoreInstruction)instructionContainer.getInstruction();
            if (!(storeInstruction.getLValue() instanceof ArrayStoreOperator)) {
                return false;
            }
            ArrayStoreOperator arrayStoreOperator = (ArrayStoreOperator)storeInstruction.getLValue();
            if (!(arrayStoreOperator.getSubExpressions()[0] instanceof NopOperator) || !(arrayStoreOperator.getSubExpressions()[1] instanceof ConstOperator)) {
                return false;
            }
            Expression expression = storeInstruction.getSubExpressions()[1];
            ConstOperator constOperator = (ConstOperator)arrayStoreOperator.getSubExpressions()[1];
            SpecialBlock specialBlock = (SpecialBlock)sequentialBlock.subBlocks[0];
            sequentialBlock = (SequentialBlock)sequentialBlock.outer;
            if (specialBlock.type != SpecialBlock.DUP || specialBlock.depth != 0 || specialBlock.count != 1 || !(constOperator.getValue() instanceof Integer) || !(sequentialBlock.subBlocks[0] instanceof InstructionBlock)) {
                return false;
            }
            int n = (Integer)constOperator.getValue();
            InstructionBlock instructionBlock = (InstructionBlock)sequentialBlock.subBlocks[0];
            if (instructionBlock.getInstruction() instanceof NewArrayOperator) {
                NewArrayOperator newArrayOperator = (NewArrayOperator)instructionBlock.getInstruction();
                if (newArrayOperator.getDimensions() != 1 || !(newArrayOperator.getSubExpressions()[0] instanceof ConstOperator)) {
                    return false;
                }
                ConstOperator constOperator2 = (ConstOperator)newArrayOperator.getSubExpressions()[0];
                if (!(constOperator2.getValue() instanceof Integer)) {
                    return false;
                }
                int n2 = (Integer)constOperator2.getValue();
                if (n2 <= n) {
                    return false;
                }
                if (GlobalOptions.verboseLevel > 0) {
                    GlobalOptions.err.print('a');
                }
                ConstantArrayOperator constantArrayOperator2 = new ConstantArrayOperator(newArrayOperator.getType(), n2);
                constantArrayOperator2.setValue(n, expression);
                instructionContainer.setInstruction(constantArrayOperator2);
                instructionContainer.moveDefinitions(sequentialBlock, structuredBlock);
                structuredBlock.replace(sequentialBlock);
                return true;
            }
            if (instructionBlock.getInstruction() instanceof ConstantArrayOperator && (constantArrayOperator = (ConstantArrayOperator)instructionBlock.getInstruction()).setValue(n, expression)) {
                instructionContainer.setInstruction(constantArrayOperator);
                instructionContainer.moveDefinitions(sequentialBlock, structuredBlock);
                structuredBlock.replace(sequentialBlock);
                return true;
            }
        }
        return false;
    }
}

