/*
 * Decompiled with CFR 0.152.
 */
package jode.flow;

import java.io.IOException;
import jode.AssertError;
import jode.decompiler.TabbedPrintWriter;
import jode.expr.ConstOperator;
import jode.flow.BreakBlock;
import jode.flow.EmptyBlock;
import jode.flow.InstructionBlock;
import jode.flow.Jump;
import jode.flow.SequentialBlock;
import jode.flow.StructuredBlock;
import jode.flow.SwitchBlock;
import jode.type.Type;

public class CaseBlock
extends StructuredBlock {
    StructuredBlock subBlock;
    int value;
    boolean isDefault = false;
    boolean isFallThrough = false;
    boolean isLastBlock = false;

    public void checkConsistent() {
        if (!(this.outer instanceof SwitchBlock)) {
            throw new AssertError("Inconsistency");
        }
        super.checkConsistent();
    }

    public boolean replaceSubBlock(StructuredBlock structuredBlock, StructuredBlock structuredBlock2) {
        if (this.subBlock != structuredBlock) {
            return false;
        }
        this.subBlock = structuredBlock2;
        return true;
    }

    protected boolean wantBraces() {
        StructuredBlock structuredBlock = this.subBlock;
        if (structuredBlock == null) {
            return false;
        }
        while (structuredBlock.declare == null || structuredBlock.declare.isEmpty()) {
            if (!(structuredBlock instanceof SequentialBlock)) {
                return structuredBlock instanceof InstructionBlock && ((InstructionBlock)structuredBlock).isDeclaration;
            }
            StructuredBlock[] structuredBlockArray = structuredBlock.getSubBlocks();
            if (structuredBlockArray[0] instanceof InstructionBlock && ((InstructionBlock)structuredBlockArray[0]).isDeclaration) {
                return true;
            }
            structuredBlock = structuredBlockArray[1];
        }
        return true;
    }

    public StructuredBlock[] getSubBlocks() {
        StructuredBlock[] structuredBlockArray;
        if (this.subBlock != null) {
            StructuredBlock[] structuredBlockArray2 = new StructuredBlock[1];
            structuredBlockArray = structuredBlockArray2;
            structuredBlockArray2[0] = this.subBlock;
        } else {
            structuredBlockArray = new StructuredBlock[]{};
        }
        return structuredBlockArray;
    }

    public void dumpInstruction(TabbedPrintWriter tabbedPrintWriter) throws IOException {
        if (this.isDefault) {
            if (this.isLastBlock && this.subBlock instanceof EmptyBlock && this.subBlock.jump == null) {
                return;
            }
            if (this.subBlock instanceof BreakBlock && ((BreakBlock)this.subBlock).breaksBlock == this) {
                if (this.isFallThrough) {
                    tabbedPrintWriter.tab();
                    this.subBlock.dumpSource(tabbedPrintWriter);
                    tabbedPrintWriter.untab();
                }
                return;
            }
            if (this.isFallThrough) {
                tabbedPrintWriter.tab();
                tabbedPrintWriter.println("/* fall through */");
                tabbedPrintWriter.untab();
            }
            tabbedPrintWriter.print("default:");
        } else {
            if (this.isFallThrough) {
                tabbedPrintWriter.tab();
                tabbedPrintWriter.println("/* fall through */");
                tabbedPrintWriter.untab();
            }
            ConstOperator constOperator = new ConstOperator(new Integer(this.value));
            Type type = ((SwitchBlock)this.outer).getInstruction().getType();
            constOperator.setType(type);
            constOperator.makeInitializer(type);
            tabbedPrintWriter.print("case " + constOperator.toString() + ":");
        }
        if (this.subBlock != null) {
            boolean bl = this.wantBraces();
            if (bl) {
                tabbedPrintWriter.openBrace();
            } else {
                tabbedPrintWriter.println();
            }
            if (this.subBlock != null) {
                tabbedPrintWriter.tab();
                this.subBlock.dumpSource(tabbedPrintWriter);
                tabbedPrintWriter.untab();
            }
            if (bl) {
                tabbedPrintWriter.closeBrace();
            }
        } else {
            tabbedPrintWriter.println();
        }
    }

    public boolean jumpMayBeChanged() {
        return this.subBlock.jump != null || this.subBlock.jumpMayBeChanged();
    }

    public CaseBlock(int n) {
        this.value = n;
        this.subBlock = null;
    }

    public CaseBlock(int n, Jump jump) {
        this.value = n;
        this.subBlock = new EmptyBlock(jump);
        this.subBlock.outer = this;
    }
}

