/*
 * Decompiled with CFR 0.152.
 */
package com.cycling74.max;

import java.io.Serializable;
import java.util.StringTokenizer;

public abstract class Atom
implements Serializable,
Comparable {
    public static final Atom[] emptyArray = new Atom[0];
    private int mType;
    private static final char INT_TYPE_CHAR = 'I';
    private static final char FLOAT_TYPE_CHAR = 'F';
    private static final char STRING_TYPE_CHAR = 'S';

    private Atom(int type) {
        this.mType = type;
    }

    public static Atom newAtom(byte value) {
        return new IntAtom(value);
    }

    public static Atom newAtom(short value) {
        return new IntAtom(value);
    }

    public static Atom newAtom(int value) {
        return new IntAtom(value);
    }

    public static Atom newAtom(long value) {
        return new IntAtom((int)value);
    }

    public static Atom newAtom(float value) {
        return new FloatAtom(value);
    }

    public static Atom newAtom(double value) {
        return new FloatAtom((float)value);
    }

    public static Atom newAtom(char value) {
        return new StringAtom(new String(new char[]{value}));
    }

    public static Atom newAtom(String value) {
        return new StringAtom(value);
    }

    public static Atom newAtom(boolean value) {
        if (value) {
            return new IntAtom(1);
        }
        return new IntAtom(0);
    }

    public static Atom[] newAtom(byte[] array) {
        int len = array.length;
        Atom[] a = new Atom[len];
        for (int i = 0; i < len; ++i) {
            a[i] = Atom.newAtom(array[i]);
        }
        return a;
    }

    public static Atom[] newAtom(short[] array) {
        int len = array.length;
        Atom[] a = new Atom[len];
        for (int i = 0; i < len; ++i) {
            a[i] = Atom.newAtom(array[i]);
        }
        return a;
    }

    public static Atom[] newAtom(int[] array) {
        int len = array.length;
        Atom[] a = new Atom[len];
        for (int i = 0; i < len; ++i) {
            a[i] = Atom.newAtom(array[i]);
        }
        return a;
    }

    public static Atom[] newAtom(long[] array) {
        int len = array.length;
        Atom[] a = new Atom[len];
        for (int i = 0; i < len; ++i) {
            a[i] = Atom.newAtom(array[i]);
        }
        return a;
    }

    public static Atom[] newAtom(float[] array) {
        int len = array.length;
        Atom[] a = new Atom[len];
        for (int i = 0; i < len; ++i) {
            a[i] = Atom.newAtom(array[i]);
        }
        return a;
    }

    public static Atom[] newAtom(double[] array) {
        int len = array.length;
        Atom[] a = new Atom[len];
        for (int i = 0; i < len; ++i) {
            a[i] = Atom.newAtom(array[i]);
        }
        return a;
    }

    public static Atom[] newAtom(char[] array) {
        int len = array.length;
        Atom[] a = new Atom[len];
        for (int i = 0; i < len; ++i) {
            a[i] = Atom.newAtom(array[i]);
        }
        return a;
    }

    public static Atom[] newAtom(String[] array) {
        int len = array.length;
        Atom[] a = new Atom[len];
        for (int i = 0; i < len; ++i) {
            a[i] = Atom.newAtom(array[i]);
        }
        return a;
    }

    public static Atom[] newAtom(String s, Atom[] args) {
        Atom[] newAtomList = new Atom[args.length + 1];
        newAtomList[0] = Atom.newAtom(s);
        for (int i = 1; i <= args.length; ++i) {
            newAtomList[i] = args[i - 1];
        }
        return newAtomList;
    }

    public static Atom[] newAtom(boolean[] array) {
        int len = array.length;
        Atom[] a = new Atom[len];
        for (int i = 0; i < len; ++i) {
            a[i] = Atom.newAtom(array[i]);
        }
        return a;
    }

    public boolean isInt() {
        return false;
    }

    public boolean isFloat() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public float getFloat() {
        throw new UnsupportedOperationException("does not contain a float");
    }

    public int getInt() {
        throw new UnsupportedOperationException("does not contain an int");
    }

    public String getString() {
        throw new UnsupportedOperationException("does not contain a String");
    }

    public abstract Object toObject();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public static Atom[] reverse(Atom[] atoms) {
        for (int i = 0; i < atoms.length / 2; ++i) {
            Atom temp = atoms[i];
            atoms[i] = atoms[atoms.length - i - 1];
            atoms[atoms.length - i - 1] = temp;
        }
        return atoms;
    }

    public static Atom[] rotate(Atom[] atoms, int numberOfPlaces) {
        int newStart;
        for (newStart = numberOfPlaces - atoms.length * (numberOfPlaces / atoms.length); newStart < 0; newStart += atoms.length) {
        }
        Atom[] temp = new Atom[atoms.length];
        System.arraycopy(atoms, 0, temp, newStart, atoms.length - newStart);
        System.arraycopy(atoms, atoms.length - newStart, temp, 0, newStart);
        return temp;
    }

    public static Atom[] intersection(Atom[] a, Atom[] b) {
        Atom[] temp = new Atom[a.length];
        int count = 0;
        for (int i = 0; i < a.length; ++i) {
            if (Atom.isIn(a[i], a, i - 1, 0) != -1 || Atom.isIn(a[i], b) == -1) continue;
            temp[count] = a[i];
            ++count;
        }
        temp = Atom.removeLast(temp, a.length - count);
        return temp;
    }

    public static Atom[] union(Atom[] a, Atom[] b) {
        Atom[] temp = new Atom[a.length + b.length];
        System.arraycopy(a, 0, temp, 0, a.length);
        System.arraycopy(b, 0, temp, a.length, b.length);
        int i = 0;
        while (i < temp.length) {
            if (Atom.isIn(temp[i], temp, i - 1, 0) != -1) {
                temp = Atom.removeOne(temp, i);
                continue;
            }
            ++i;
        }
        return temp;
    }

    public static int isIn(Atom item, Atom[] atoms) {
        return Atom.isIn(item, atoms, atoms.length - 1, 0);
    }

    public static int isIn(Atom item, Atom[] atoms, int highIdx, int lowIdx) {
        int found = -1;
        for (int i = highIdx; i >= lowIdx && found == -1; --i) {
            if (!atoms[i].equals(item)) continue;
            found = i;
        }
        return found;
    }

    public static Atom[] removeOne(Atom[] atoms, int index) {
        return Atom.removeSome(atoms, index, index);
    }

    public static Atom[] removeSome(Atom[] atoms, int first, int last) {
        int length = atoms.length;
        if (length == 0) {
            return atoms;
        }
        if (first < 0 || first > length - 1) {
            throw new IllegalArgumentException("first index out of range");
        }
        if (last < 0 || last > length - 1) {
            throw new IllegalArgumentException("last index out of range");
        }
        if (last < first) {
            throw new IllegalArgumentException("last index is smaller than first");
        }
        if (first == 0 && last == length - 1) {
            return emptyArray;
        }
        Atom[] result = new Atom[length - (last - first + 1)];
        System.arraycopy(atoms, 0, result, 0, first);
        System.arraycopy(atoms, last + 1, result, first, length - last - 1);
        return result;
    }

    public static Atom[] removeFirst(Atom[] atoms) {
        return Atom.removeFirst(atoms, 1);
    }

    public static Atom[] removeFirst(Atom[] atoms, int howMany) {
        if (howMany < 0) {
            throw new IllegalArgumentException("howMany must be >= 0");
        }
        int length = atoms.length;
        if (length == 0) {
            return atoms;
        }
        if (length == howMany) {
            return emptyArray;
        }
        if (howMany > length) {
            throw new IllegalArgumentException("howMany > length");
        }
        Atom[] result = new Atom[length - howMany];
        System.arraycopy(atoms, howMany, result, 0, length - howMany);
        return result;
    }

    public static Atom[] removeLast(Atom[] atoms) {
        return Atom.removeLast(atoms, 1);
    }

    public static Atom[] removeLast(Atom[] atoms, int howMany) {
        if (howMany < 0) {
            throw new IllegalArgumentException("howMany must be >= 0");
        }
        int length = atoms.length;
        if (length == 0) {
            return atoms;
        }
        if (length == howMany) {
            return emptyArray;
        }
        if (howMany > length) {
            throw new IllegalArgumentException("howMany > length");
        }
        Atom[] result = new Atom[length - howMany];
        System.arraycopy(atoms, 0, result, 0, length - howMany);
        return result;
    }

    public static String toOneString(Atom[] array) {
        int len = array.length;
        StringBuffer sb = new StringBuffer(4 * len);
        for (int i = 0; i < len; ++i) {
            sb.append(array[i].toString());
            if (i == len - 1) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public static String[] toString(Atom[] array) {
        int len = array.length;
        String[] s = new String[len];
        for (int i = 0; i < len; ++i) {
            s[i] = array[i].toString();
        }
        return s;
    }

    public byte toByte() {
        return 0;
    }

    public static byte[] toByte(Atom[] array) {
        int len = array.length;
        byte[] bytes = new byte[len];
        for (int i = 0; i < len; ++i) {
            bytes[i] = array[i].toByte();
        }
        return bytes;
    }

    public short toShort() {
        return 0;
    }

    public static short[] toShort(Atom[] array) {
        int len = array.length;
        short[] shorts = new short[len];
        for (int i = 0; i < len; ++i) {
            shorts[i] = array[i].toShort();
        }
        return shorts;
    }

    public int toInt() {
        return 0;
    }

    public static int[] toInt(Atom[] array) {
        int len = array.length;
        int[] ints = new int[len];
        for (int i = 0; i < len; ++i) {
            ints[i] = array[i].toInt();
        }
        return ints;
    }

    public long toLong() {
        return 0L;
    }

    public static long[] toLong(Atom[] array) {
        int len = array.length;
        long[] longs = new long[len];
        for (int i = 0; i < len; ++i) {
            longs[i] = array[i].toLong();
        }
        return longs;
    }

    public float toFloat() {
        return 0.0f;
    }

    public static float[] toFloat(Atom[] array) {
        int len = array.length;
        float[] floats = new float[len];
        for (int i = 0; i < len; ++i) {
            floats[i] = array[i].toFloat();
        }
        return floats;
    }

    public double toDouble() {
        return 0.0;
    }

    public static double[] toDouble(Atom[] array) {
        int len = array.length;
        double[] doubles = new double[len];
        for (int i = 0; i < len; ++i) {
            doubles[i] = array[i].toDouble();
        }
        return doubles;
    }

    public char toChar() {
        return '\u0000';
    }

    public static char[] toChar(Atom[] array) {
        int len = array.length;
        char[] chars = new char[len];
        for (int i = 0; i < len; ++i) {
            chars[i] = array[i].toChar();
        }
        return chars;
    }

    public boolean toBoolean() {
        return true;
    }

    public static boolean[] toBoolean(Atom[] array) {
        int len = array.length;
        boolean[] bools = new boolean[len];
        for (int i = 0; i < len; ++i) {
            bools[i] = array[i].toBoolean();
        }
        return bools;
    }

    public static Atom[] parse(String str) {
        return Atom.parse(str, false);
    }

    public static Atom[] parse(String str, boolean skipFirst) {
        StringTokenizer st = new StringTokenizer(str, " \t");
        int length = st.countTokens();
        if (skipFirst) {
            --length;
            st.nextToken();
        }
        Atom[] result = new Atom[length];
        for (int i = 0; i < length; ++i) {
            String token = st.nextToken();
            try {
                int pi = Integer.parseInt(token);
                result[i] = Atom.newAtom(pi);
                continue;
            }
            catch (NumberFormatException nfe) {
                try {
                    float pf = Float.valueOf(token).floatValue();
                    result[i] = Atom.newAtom(pf);
                    continue;
                }
                catch (NumberFormatException nfe2) {
                    result[i] = Atom.newAtom(token);
                }
            }
        }
        return result;
    }

    int getType() {
        return this.mType;
    }

    public static String toDebugString(Atom[] array) {
        StringBuffer sb = new StringBuffer("Atom");
        sb.append("[");
        sb.append(array.length);
        sb.append("]=");
        for (int i = 0; i < array.length; ++i) {
            char code;
            Atom elt = array[i];
            sb.append("{");
            sb.append(elt);
            sb.append(":");
            switch (elt.getType()) {
                case 1: {
                    code = 'I';
                    break;
                }
                case 2: {
                    code = 'F';
                    break;
                }
                case 3: {
                    code = 'S';
                    break;
                }
                default: {
                    code = '?';
                }
            }
            sb.append(code);
            sb.append("}");
        }
        return sb.toString();
    }

    public int compareTo(Object o) {
        return 0;
    }

    private static final class StringAtom
    extends Atom {
        private String mValue = null;

        private StringAtom(String value) {
            super(3);
            if (value == null) {
                throw new NullPointerException();
            }
            this.mValue = value;
        }

        public boolean equals(Object o) {
            return o instanceof StringAtom && ((StringAtom)o).getString().equals(this.getString());
        }

        public int compareTo(Object o) {
            if (o instanceof StringAtom) {
                return this.getString().compareTo(((StringAtom)o).getString());
            }
            if (o instanceof IntAtom || o instanceof FloatAtom) {
                return -1;
            }
            if (o == null) {
                throw new NullPointerException();
            }
            throw new ClassCastException();
        }

        public int hashCode() {
            return this.mValue.hashCode();
        }

        public String getString() {
            return this.mValue;
        }

        public boolean isString() {
            return true;
        }

        public String toString() {
            return this.getString();
        }

        public char toChar() {
            return this.mValue.charAt(0);
        }

        public boolean toBoolean() {
            return !this.mValue.equals("false");
        }

        public Object toObject() {
            return this.getString();
        }
    }

    private static final class IntAtom
    extends Atom {
        private int mValue = 0;

        private IntAtom(int value) {
            super(1);
            this.mValue = value;
        }

        public boolean equals(Object o) {
            return o instanceof IntAtom && ((IntAtom)o).getInt() == this.getInt();
        }

        public int compareTo(Object o) {
            if (o instanceof IntAtom) {
                if (this.equals(o)) {
                    return 0;
                }
                if (((IntAtom)o).getInt() > this.getInt()) {
                    return -1;
                }
                return 1;
            }
            if (o instanceof FloatAtom) {
                float f = ((FloatAtom)o).getFloat();
                if (f == (float)this.getInt()) {
                    return 0;
                }
                if (f > (float)this.getInt()) {
                    return -1;
                }
                return 1;
            }
            if (o instanceof StringAtom) {
                return 1;
            }
            if (o == null) {
                throw new NullPointerException();
            }
            throw new ClassCastException();
        }

        public int hashCode() {
            return this.mValue;
        }

        public boolean isInt() {
            return true;
        }

        public int getInt() {
            return this.mValue;
        }

        public byte toByte() {
            return (byte)this.mValue;
        }

        public short toShort() {
            return (short)this.mValue;
        }

        public int toInt() {
            return this.mValue;
        }

        public long toLong() {
            return this.mValue;
        }

        public float toFloat() {
            return this.mValue;
        }

        public double toDouble() {
            return this.mValue;
        }

        public String toString() {
            return Integer.toString(this.mValue);
        }

        public char toChar() {
            return (char)this.mValue;
        }

        public boolean toBoolean() {
            return this.mValue != 0;
        }

        public Object toObject() {
            return new Integer(this.mValue);
        }
    }

    private static final class FloatAtom
    extends Atom {
        private float mValue = 0.0f;

        private FloatAtom(float value) {
            super(2);
            this.mValue = value;
        }

        public boolean equals(Object o) {
            return o instanceof FloatAtom && ((FloatAtom)o).getFloat() == this.getFloat();
        }

        public int compareTo(Object o) {
            if (o instanceof FloatAtom) {
                if (this.equals(o)) {
                    return 0;
                }
                if (((FloatAtom)o).getFloat() > this.getFloat()) {
                    return -1;
                }
                return 1;
            }
            if (o instanceof IntAtom) {
                float f = ((IntAtom)o).getInt();
                if (f == this.getFloat()) {
                    return 0;
                }
                if (f > this.getFloat()) {
                    return -1;
                }
                return 1;
            }
            if (o instanceof StringAtom) {
                return 1;
            }
            if (o == null) {
                throw new NullPointerException();
            }
            throw new ClassCastException();
        }

        public int hashCode() {
            return Float.floatToIntBits(this.mValue);
        }

        public boolean isFloat() {
            return true;
        }

        public float getFloat() {
            return this.mValue;
        }

        public byte toByte() {
            return (byte)this.mValue;
        }

        public short toShort() {
            return (short)this.mValue;
        }

        public int toInt() {
            return (int)this.mValue;
        }

        public long toLong() {
            return (long)this.mValue;
        }

        public float toFloat() {
            return this.mValue;
        }

        public double toDouble() {
            return this.mValue;
        }

        public String toString() {
            return Float.toString(this.mValue);
        }

        public char toChar() {
            return (char)this.mValue;
        }

        public boolean toBoolean() {
            return this.mValue != 0.0f;
        }

        public Object toObject() {
            return new Float(this.mValue);
        }
    }
}

